package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Application-Layer Protocol Negotiation Policies for network load balancers.
 * <p>
 * Which protocols should be used over a secure connection.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-06T20:02:54.484Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.AlpnPolicy")
public enum AlpnPolicy {
    /**
     * Negotiate only HTTP/1.*. The ALPN preference list is http/1.1, http/1.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP1_ONLY,
    /**
     * Negotiate only HTTP/2.
     * <p>
     * The ALPN preference list is h2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP2_ONLY,
    /**
     * Prefer HTTP/1.* over HTTP/2 (which can be useful for HTTP/2 testing). The ALPN preference list is http/1.1, http/1.0, h2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP2_OPTIONAL,
    /**
     * Prefer HTTP/2 over HTTP/1.*. The ALPN preference list is h2, http/1.1, http/1.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP2_PREFERRED,
    /**
     * Do not negotiate ALPN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
}
