package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing listener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * SecurityGroup securityGroup;
 * ApplicationListenerAttributes applicationListenerAttributes = ApplicationListenerAttributes.builder()
 *         .listenerArn("listenerArn")
 *         // the properties below are optional
 *         .defaultPort(123)
 *         .securityGroup(securityGroup)
 *         .securityGroupAllowsAllOutbound(false)
 *         .securityGroupId("securityGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T20:25:34.019Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationListenerAttributes")
@software.amazon.jsii.Jsii.Proxy(ApplicationListenerAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationListenerAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * ARN of the listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getListenerArn();

    /**
     * The default port on which this listener is listening.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultPort() {
        return null;
    }

    /**
     * Security group of the load balancer this listener is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * (deprecated) Whether the imported security group allows all outbound traffic or not when imported using `securityGroupId`.
     * <p>
     * Unless set to <code>false</code>, no egress rules will be added to the security group.
     * <p>
     * Default: true
     * <p>
     * @deprecated use `securityGroup` instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSecurityGroupAllowsAllOutbound() {
        return null;
    }

    /**
     * (deprecated) Security group ID of the load balancer this listener is associated with.
     * <p>
     * @deprecated use `securityGroup` instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityGroupId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationListenerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationListenerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationListenerAttributes> {
        java.lang.String listenerArn;
        java.lang.Number defaultPort;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        java.lang.Boolean securityGroupAllowsAllOutbound;
        java.lang.String securityGroupId;

        /**
         * Sets the value of {@link ApplicationListenerAttributes#getListenerArn}
         * @param listenerArn ARN of the listener. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerArn(java.lang.String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerAttributes#getDefaultPort}
         * @param defaultPort The default port on which this listener is listening.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultPort(java.lang.Number defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerAttributes#getSecurityGroup}
         * @param securityGroup Security group of the load balancer this listener is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerAttributes#getSecurityGroupAllowsAllOutbound}
         * @param securityGroupAllowsAllOutbound Whether the imported security group allows all outbound traffic or not when imported using `securityGroupId`.
         *                                       Unless set to <code>false</code>, no egress rules will be added to the security group.
         * @return {@code this}
         * @deprecated use `securityGroup` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder securityGroupAllowsAllOutbound(java.lang.Boolean securityGroupAllowsAllOutbound) {
            this.securityGroupAllowsAllOutbound = securityGroupAllowsAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerAttributes#getSecurityGroupId}
         * @param securityGroupId Security group ID of the load balancer this listener is associated with.
         * @return {@code this}
         * @deprecated use `securityGroup` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder securityGroupId(java.lang.String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationListenerAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationListenerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationListenerAttributes {
        private final java.lang.String listenerArn;
        private final java.lang.Number defaultPort;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final java.lang.Boolean securityGroupAllowsAllOutbound;
        private final java.lang.String securityGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.listenerArn = software.amazon.jsii.Kernel.get(this, "listenerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultPort = software.amazon.jsii.Kernel.get(this, "defaultPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.securityGroupAllowsAllOutbound = software.amazon.jsii.Kernel.get(this, "securityGroupAllowsAllOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.securityGroupId = software.amazon.jsii.Kernel.get(this, "securityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listenerArn = java.util.Objects.requireNonNull(builder.listenerArn, "listenerArn is required");
            this.defaultPort = builder.defaultPort;
            this.securityGroup = builder.securityGroup;
            this.securityGroupAllowsAllOutbound = builder.securityGroupAllowsAllOutbound;
            this.securityGroupId = builder.securityGroupId;
        }

        @Override
        public final java.lang.String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public final java.lang.Number getDefaultPort() {
            return this.defaultPort;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final java.lang.Boolean getSecurityGroupAllowsAllOutbound() {
            return this.securityGroupAllowsAllOutbound;
        }

        @Override
        public final java.lang.String getSecurityGroupId() {
            return this.securityGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("listenerArn", om.valueToTree(this.getListenerArn()));
            if (this.getDefaultPort() != null) {
                data.set("defaultPort", om.valueToTree(this.getDefaultPort()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getSecurityGroupAllowsAllOutbound() != null) {
                data.set("securityGroupAllowsAllOutbound", om.valueToTree(this.getSecurityGroupAllowsAllOutbound()));
            }
            if (this.getSecurityGroupId() != null) {
                data.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.ApplicationListenerAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationListenerAttributes.Jsii$Proxy that = (ApplicationListenerAttributes.Jsii$Proxy) o;

            if (!listenerArn.equals(that.listenerArn)) return false;
            if (this.defaultPort != null ? !this.defaultPort.equals(that.defaultPort) : that.defaultPort != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.securityGroupAllowsAllOutbound != null ? !this.securityGroupAllowsAllOutbound.equals(that.securityGroupAllowsAllOutbound) : that.securityGroupAllowsAllOutbound != null) return false;
            return this.securityGroupId != null ? this.securityGroupId.equals(that.securityGroupId) : that.securityGroupId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.listenerArn.hashCode();
            result = 31 * result + (this.defaultPort != null ? this.defaultPort.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.securityGroupAllowsAllOutbound != null ? this.securityGroupAllowsAllOutbound.hashCode() : 0);
            result = 31 * result + (this.securityGroupId != null ? this.securityGroupId.hashCode() : 0);
            return result;
        }
    }
}
