package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define a Network Target Group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.6 (build 17f281e)", date = "2019-11-19T17:18:05.276Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.NetworkTargetGroup")
public class NetworkTargetGroup extends software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupBase implements software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup {

    protected NetworkTargetGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkTargetGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NetworkTargetGroup(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing target group.
     * 
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup fromTargetGroupAttributes(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup.class, "fromTargetGroupAttributes", software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Import an existing listener.
     * 
     * @deprecated Use `fromTargetGroupAttributes` instead
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup doImport(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup.class, "import", software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a load balancing target to this target group.
     * 
     * @param targets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget... targets) {
        this.jsiiCall("addTarget", Void.class, java.util.Arrays.<Object>stream(targets).toArray(Object[]::new));
    }

    /**
     * Register a listener that is load balancing to this target group.
     * 
     * Don't call this directly. It will be called by listeners.
     * 
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void registerListener(final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener listener) {
        this.jsiiCall("registerListener", Void.class, new Object[] { java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     * Validate the current construct.
     * 
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", java.util.List.class));
    }

    /**
     * Full name of first load balancer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getFirstLoadBalancerFullName() {
        return this.jsiiGet("firstLoadBalancerFullName", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroupProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroupProps.Builder();
        }

        /**
         * @return {@code this}
         * @param deregistrationDelay The amount of time for Elastic Load Balancing to wait before deregistering a target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deregistrationDelay(final software.amazon.awscdk.core.Duration deregistrationDelay) {
            this.props.deregistrationDelay(deregistrationDelay);
            return this;
        }

        /**
         * @return {@code this}
         * @param healthCheck Health check configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        /**
         * @return {@code this}
         * @param targetGroupName The name of the target group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupName(final java.lang.String targetGroupName) {
            this.props.targetGroupName(targetGroupName);
            return this;
        }

        /**
         * @return {@code this}
         * @param targetType The type of targets registered to this TargetGroup, either IP or Instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType) {
            this.props.targetType(targetType);
            return this;
        }

        /**
         * @return {@code this}
         * @param vpc The virtual private cloud (VPC). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * @return {@code this}
         * @param port The port on which the listener listens for requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * @return {@code this}
         * @param proxyProtocolV2 Indicates whether Proxy Protocol version 2 is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyProtocolV2(final java.lang.Boolean proxyProtocolV2) {
            this.props.proxyProtocolV2(proxyProtocolV2);
            return this;
        }

        /**
         * @return {@code this}
         * @param targets The targets to add to this target group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> targets) {
            this.props.targets(targets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
