package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::LoadBalancer`.
 * <p>
 * Specifies an Application Load Balancer, a Network Load Balancer, or a Gateway Load Balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * CfnLoadBalancer cfnLoadBalancer = CfnLoadBalancer.Builder.create(this, "MyCfnLoadBalancer")
 *         .ipAddressType("ipAddressType")
 *         .loadBalancerAttributes(List.of(LoadBalancerAttributeProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .name("name")
 *         .scheme("scheme")
 *         .securityGroups(List.of("securityGroups"))
 *         .subnetMappings(List.of(SubnetMappingProperty.builder()
 *                 .subnetId("subnetId")
 *                 // the properties below are optional
 *                 .allocationId("allocationId")
 *                 .iPv6Address("iPv6Address")
 *                 .privateIPv4Address("privateIPv4Address")
 *                 .build()))
 *         .subnets(List.of("subnets"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .type("type")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:31:07.206Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnLoadBalancer")
public class CfnLoadBalancer extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnLoadBalancer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancer.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ElasticLoadBalancingV2::LoadBalancer`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLoadBalancer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::ElasticLoadBalancingV2::LoadBalancer`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLoadBalancer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the Amazon Route 53 hosted zone associated with the load balancer.
     * <p>
     * For example, <code>Z2P70J7EXAMPLE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCanonicalHostedZoneId() {
        return software.amazon.jsii.Kernel.get(this, "attrCanonicalHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DNS name for the load balancer.
     * <p>
     * For example, <code>my-load-balancer-424835706.us-west-2.elb.amazonaws.com</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDnsName() {
        return software.amazon.jsii.Kernel.get(this, "attrDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The full name of the load balancer.
     * <p>
     * For example, <code>app/my-load-balancer/50dc6c495c0c9188</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLoadBalancerFullName() {
        return software.amazon.jsii.Kernel.get(this, "attrLoadBalancerFullName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the load balancer.
     * <p>
     * For example, <code>my-load-balancer</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLoadBalancerName() {
        return software.amazon.jsii.Kernel.get(this, "attrLoadBalancerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IDs of the security groups for the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrSecurityGroups() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags to assign to the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The IP address type.
     * <p>
     * The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
        return software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IP address type.
     * <p>
     * The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpAddressType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ipAddressType", value);
    }

    /**
     * The load balancer attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoadBalancerAttributes() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancerAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The load balancer attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBalancerAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loadBalancerAttributes", value);
    }

    /**
     * The load balancer attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBalancerAttributes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancer.LoadBalancerAttributeProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancer.LoadBalancerAttributeProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "loadBalancerAttributes", value);
    }

    /**
     * The name of the load balancer.
     * <p>
     * This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must not begin with "internal-".
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID for the load balancer. If you specify a name, you cannot perform updates that require replacement of this resource, but you can perform other updates. To replace the resource, specify a new name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the load balancer.
     * <p>
     * This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must not begin with "internal-".
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID for the load balancer. If you specify a name, you cannot perform updates that require replacement of this resource, but you can perform other updates. To replace the resource, specify a new name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The nodes of an Internet-facing load balancer have public IP addresses.
     * <p>
     * The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.
     * <p>
     * The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.
     * <p>
     * The default is an Internet-facing load balancer.
     * <p>
     * You cannot specify a scheme for a Gateway Load Balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScheme() {
        return software.amazon.jsii.Kernel.get(this, "scheme", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The nodes of an Internet-facing load balancer have public IP addresses.
     * <p>
     * The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.
     * <p>
     * The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.
     * <p>
     * The default is an Internet-facing load balancer.
     * <p>
     * You cannot specify a scheme for a Gateway Load Balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheme(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scheme", value);
    }

    /**
     * [Application Load Balancers] The IDs of the security groups for the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * [Application Load Balancers] The IDs of the security groups for the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroups", value);
    }

    /**
     * The IDs of the public subnets.
     * <p>
     * You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both.
     * <p>
     * [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.
     * <p>
     * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
     * <p>
     * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
     * <p>
     * [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
     * <p>
     * [Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSubnetMappings() {
        return software.amazon.jsii.Kernel.get(this, "subnetMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The IDs of the public subnets.
     * <p>
     * You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both.
     * <p>
     * [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.
     * <p>
     * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
     * <p>
     * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
     * <p>
     * [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
     * <p>
     * [Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnetMappings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "subnetMappings", value);
    }

    /**
     * The IDs of the public subnets.
     * <p>
     * You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both.
     * <p>
     * [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.
     * <p>
     * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
     * <p>
     * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
     * <p>
     * [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
     * <p>
     * [Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnetMappings(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancer.SubnetMappingProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancer.SubnetMappingProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "subnetMappings", value);
    }

    /**
     * The IDs of the public subnets.
     * <p>
     * You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both. To specify an Elastic IP address, specify subnet mappings instead of subnets.
     * <p>
     * [Application Load Balancers] You must specify subnets from at least two Availability Zones.
     * <p>
     * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
     * <p>
     * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
     * <p>
     * [Network Load Balancers] You can specify subnets from one or more Availability Zones.
     * <p>
     * [Gateway Load Balancers] You can specify subnets from one or more Availability Zones.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnets() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The IDs of the public subnets.
     * <p>
     * You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both. To specify an Elastic IP address, specify subnet mappings instead of subnets.
     * <p>
     * [Application Load Balancers] You must specify subnets from at least two Availability Zones.
     * <p>
     * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
     * <p>
     * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
     * <p>
     * [Network Load Balancers] You can specify subnets from one or more Availability Zones.
     * <p>
     * [Gateway Load Balancers] You can specify subnets from one or more Availability Zones.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnets(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "subnets", value);
    }

    /**
     * The type of load balancer.
     * <p>
     * The default is <code>application</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of load balancer.
     * <p>
     * The default is <code>application</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", value);
    }
    /**
     * Specifies an attribute for an Application Load Balancer, a Network Load Balancer, or a Gateway Load Balancer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * LoadBalancerAttributeProperty loadBalancerAttributeProperty = LoadBalancerAttributeProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnLoadBalancer.LoadBalancerAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(LoadBalancerAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoadBalancerAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the attribute.
         * <p>
         * The following attribute is supported by all load balancers:
         * <p>
         * <ul>
         * <li><code>deletion_protection.enabled</code> - Indicates whether deletion protection is enabled. The value is <code>true</code> or <code>false</code> . The default is <code>false</code> .</li>
         * </ul>
         * <p>
         * The following attributes are supported by both Application Load Balancers and Network Load Balancers:
         * <p>
         * <ul>
         * <li><code>access_logs.s3.enabled</code> - Indicates whether access logs are enabled. The value is <code>true</code> or <code>false</code> . The default is <code>false</code> .</li>
         * <li><code>access_logs.s3.bucket</code> - The name of the S3 bucket for the access logs. This attribute is required if access logs are enabled. The bucket must exist in the same region as the load balancer and have a bucket policy that grants Elastic Load Balancing permissions to write to the bucket.</li>
         * <li><code>access_logs.s3.prefix</code> - The prefix for the location in the S3 bucket for the access logs.</li>
         * <li><code>ipv6.deny_all_igw_traffic</code> - Blocks internet gateway (IGW) access to the load balancer. It is set to <code>false</code> for internet-facing load balancers and <code>true</code> for internal load balancers, preventing unintended access to your internal load balancer through an internet gateway.</li>
         * </ul>
         * <p>
         * The following attributes are supported by only Application Load Balancers:
         * <p>
         * <ul>
         * <li><code>idle_timeout.timeout_seconds</code> - The idle timeout value, in seconds. The valid range is 1-4000 seconds. The default is 60 seconds.</li>
         * <li><code>routing.http.desync_mitigation_mode</code> - Determines how the load balancer handles requests that might pose a security risk to your application. The possible values are <code>monitor</code> , <code>defensive</code> , and <code>strictest</code> . The default is <code>defensive</code> .</li>
         * <li><code>routing.http.drop_invalid_header_fields.enabled</code> - Indicates whether HTTP headers with invalid header fields are removed by the load balancer ( <code>true</code> ) or routed to targets ( <code>false</code> ). The default is <code>false</code> .</li>
         * <li><code>routing.http.x_amzn_tls_version_and_cipher_suite.enabled</code> - Indicates whether the two headers ( <code>x-amzn-tls-version</code> and <code>x-amzn-tls-cipher-suite</code> ), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. The <code>x-amzn-tls-version</code> header has information about the TLS protocol version negotiated with the client, and the <code>x-amzn-tls-cipher-suite</code> header has information about the cipher suite negotiated with the client. Both headers are in OpenSSL format. The possible values for the attribute are <code>true</code> and <code>false</code> . The default is <code>false</code> .</li>
         * <li><code>routing.http.xff_client_port.enabled</code> - Indicates whether the <code>X-Forwarded-For</code> header should preserve the source port that the client used to connect to the load balancer. The possible values are <code>true</code> and <code>false</code> . The default is <code>false</code> .</li>
         * <li><code>routing.http2.enabled</code> - Indicates whether HTTP/2 is enabled. The possible values are <code>true</code> and <code>false</code> . The default is <code>true</code> . Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens.</li>
         * <li><code>waf.fail_open.enabled</code> - Indicates whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. The possible values are <code>true</code> and <code>false</code> . The default is <code>false</code> .</li>
         * </ul>
         * <p>
         * The following attribute is supported by Network Load Balancers and Gateway Load Balancers:
         * <p>
         * <ul>
         * <li><code>load_balancing.cross_zone.enabled</code> - Indicates whether cross-zone load balancing is enabled. The possible values are <code>true</code> and <code>false</code> . The default is <code>false</code> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The value of the attribute.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoadBalancerAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoadBalancerAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerAttributeProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link LoadBalancerAttributeProperty#getKey}
             * @param key The name of the attribute.
             *            The following attribute is supported by all load balancers:
             *            <p>
             *            <ul>
             *            <li><code>deletion_protection.enabled</code> - Indicates whether deletion protection is enabled. The value is <code>true</code> or <code>false</code> . The default is <code>false</code> .</li>
             *            </ul>
             *            <p>
             *            The following attributes are supported by both Application Load Balancers and Network Load Balancers:
             *            <p>
             *            <ul>
             *            <li><code>access_logs.s3.enabled</code> - Indicates whether access logs are enabled. The value is <code>true</code> or <code>false</code> . The default is <code>false</code> .</li>
             *            <li><code>access_logs.s3.bucket</code> - The name of the S3 bucket for the access logs. This attribute is required if access logs are enabled. The bucket must exist in the same region as the load balancer and have a bucket policy that grants Elastic Load Balancing permissions to write to the bucket.</li>
             *            <li><code>access_logs.s3.prefix</code> - The prefix for the location in the S3 bucket for the access logs.</li>
             *            <li><code>ipv6.deny_all_igw_traffic</code> - Blocks internet gateway (IGW) access to the load balancer. It is set to <code>false</code> for internet-facing load balancers and <code>true</code> for internal load balancers, preventing unintended access to your internal load balancer through an internet gateway.</li>
             *            </ul>
             *            <p>
             *            The following attributes are supported by only Application Load Balancers:
             *            <p>
             *            <ul>
             *            <li><code>idle_timeout.timeout_seconds</code> - The idle timeout value, in seconds. The valid range is 1-4000 seconds. The default is 60 seconds.</li>
             *            <li><code>routing.http.desync_mitigation_mode</code> - Determines how the load balancer handles requests that might pose a security risk to your application. The possible values are <code>monitor</code> , <code>defensive</code> , and <code>strictest</code> . The default is <code>defensive</code> .</li>
             *            <li><code>routing.http.drop_invalid_header_fields.enabled</code> - Indicates whether HTTP headers with invalid header fields are removed by the load balancer ( <code>true</code> ) or routed to targets ( <code>false</code> ). The default is <code>false</code> .</li>
             *            <li><code>routing.http.x_amzn_tls_version_and_cipher_suite.enabled</code> - Indicates whether the two headers ( <code>x-amzn-tls-version</code> and <code>x-amzn-tls-cipher-suite</code> ), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. The <code>x-amzn-tls-version</code> header has information about the TLS protocol version negotiated with the client, and the <code>x-amzn-tls-cipher-suite</code> header has information about the cipher suite negotiated with the client. Both headers are in OpenSSL format. The possible values for the attribute are <code>true</code> and <code>false</code> . The default is <code>false</code> .</li>
             *            <li><code>routing.http.xff_client_port.enabled</code> - Indicates whether the <code>X-Forwarded-For</code> header should preserve the source port that the client used to connect to the load balancer. The possible values are <code>true</code> and <code>false</code> . The default is <code>false</code> .</li>
             *            <li><code>routing.http2.enabled</code> - Indicates whether HTTP/2 is enabled. The possible values are <code>true</code> and <code>false</code> . The default is <code>true</code> . Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens.</li>
             *            <li><code>waf.fail_open.enabled</code> - Indicates whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. The possible values are <code>true</code> and <code>false</code> . The default is <code>false</code> .</li>
             *            </ul>
             *            <p>
             *            The following attribute is supported by Network Load Balancers and Gateway Load Balancers:
             *            <p>
             *            <ul>
             *            <li><code>load_balancing.cross_zone.enabled</code> - Indicates whether cross-zone load balancing is enabled. The possible values are <code>true</code> and <code>false</code> . The default is <code>false</code> .</li>
             *            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerAttributeProperty#getValue}
             * @param value The value of the attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancerAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoadBalancerAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoadBalancerAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerAttributeProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnLoadBalancer.LoadBalancerAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoadBalancerAttributeProperty.Jsii$Proxy that = (LoadBalancerAttributeProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a subnet for a load balancer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * SubnetMappingProperty subnetMappingProperty = SubnetMappingProperty.builder()
     *         .subnetId("subnetId")
     *         // the properties below are optional
     *         .allocationId("allocationId")
     *         .iPv6Address("iPv6Address")
     *         .privateIPv4Address("privateIPv4Address")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnLoadBalancer.SubnetMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(SubnetMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubnetMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the subnet.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSubnetId();

        /**
         * [Network Load Balancers] The allocation ID of the Elastic IP address for an internet-facing load balancer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationId() {
            return null;
        }

        /**
         * [Network Load Balancers] The IPv6 address.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIPv6Address() {
            return null;
        }

        /**
         * [Network Load Balancers] The private IPv4 address for an internal load balancer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIPv4Address() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SubnetMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubnetMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubnetMappingProperty> {
            java.lang.String subnetId;
            java.lang.String allocationId;
            java.lang.String iPv6Address;
            java.lang.String privateIPv4Address;

            /**
             * Sets the value of {@link SubnetMappingProperty#getSubnetId}
             * @param subnetId The ID of the subnet. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Sets the value of {@link SubnetMappingProperty#getAllocationId}
             * @param allocationId [Network Load Balancers] The allocation ID of the Elastic IP address for an internet-facing load balancer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationId(java.lang.String allocationId) {
                this.allocationId = allocationId;
                return this;
            }

            /**
             * Sets the value of {@link SubnetMappingProperty#getIPv6Address}
             * @param iPv6Address [Network Load Balancers] The IPv6 address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iPv6Address(java.lang.String iPv6Address) {
                this.iPv6Address = iPv6Address;
                return this;
            }

            /**
             * Sets the value of {@link SubnetMappingProperty#getPrivateIPv4Address}
             * @param privateIPv4Address [Network Load Balancers] The private IPv4 address for an internal load balancer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIPv4Address(java.lang.String privateIPv4Address) {
                this.privateIPv4Address = privateIPv4Address;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubnetMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubnetMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubnetMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubnetMappingProperty {
            private final java.lang.String subnetId;
            private final java.lang.String allocationId;
            private final java.lang.String iPv6Address;
            private final java.lang.String privateIPv4Address;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allocationId = software.amazon.jsii.Kernel.get(this, "allocationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iPv6Address = software.amazon.jsii.Kernel.get(this, "iPv6Address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateIPv4Address = software.amazon.jsii.Kernel.get(this, "privateIPv4Address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.subnetId = java.util.Objects.requireNonNull(builder.subnetId, "subnetId is required");
                this.allocationId = builder.allocationId;
                this.iPv6Address = builder.iPv6Address;
                this.privateIPv4Address = builder.privateIPv4Address;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public final java.lang.String getAllocationId() {
                return this.allocationId;
            }

            @Override
            public final java.lang.String getIPv6Address() {
                return this.iPv6Address;
            }

            @Override
            public final java.lang.String getPrivateIPv4Address() {
                return this.privateIPv4Address;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("subnetId", om.valueToTree(this.getSubnetId()));
                if (this.getAllocationId() != null) {
                    data.set("allocationId", om.valueToTree(this.getAllocationId()));
                }
                if (this.getIPv6Address() != null) {
                    data.set("iPv6Address", om.valueToTree(this.getIPv6Address()));
                }
                if (this.getPrivateIPv4Address() != null) {
                    data.set("privateIPv4Address", om.valueToTree(this.getPrivateIPv4Address()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnLoadBalancer.SubnetMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubnetMappingProperty.Jsii$Proxy that = (SubnetMappingProperty.Jsii$Proxy) o;

                if (!subnetId.equals(that.subnetId)) return false;
                if (this.allocationId != null ? !this.allocationId.equals(that.allocationId) : that.allocationId != null) return false;
                if (this.iPv6Address != null ? !this.iPv6Address.equals(that.iPv6Address) : that.iPv6Address != null) return false;
                return this.privateIPv4Address != null ? this.privateIPv4Address.equals(that.privateIPv4Address) : that.privateIPv4Address == null;
            }

            @Override
            public final int hashCode() {
                int result = this.subnetId.hashCode();
                result = 31 * result + (this.allocationId != null ? this.allocationId.hashCode() : 0);
                result = 31 * result + (this.iPv6Address != null ? this.iPv6Address.hashCode() : 0);
                result = 31 * result + (this.privateIPv4Address != null ? this.privateIPv4Address.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancerProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The IP address type.
         * <p>
         * The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses). You can’t specify <code>dualstack</code> for a load balancer with a UDP or TCP_UDP listener.
         * <p>
         * @return {@code this}
         * @param ipAddressType The IP address type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(final java.lang.String ipAddressType) {
            this.props().ipAddressType(ipAddressType);
            return this;
        }

        /**
         * The load balancer attributes.
         * <p>
         * @return {@code this}
         * @param loadBalancerAttributes The load balancer attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerAttributes(final software.amazon.awscdk.core.IResolvable loadBalancerAttributes) {
            this.props().loadBalancerAttributes(loadBalancerAttributes);
            return this;
        }
        /**
         * The load balancer attributes.
         * <p>
         * @return {@code this}
         * @param loadBalancerAttributes The load balancer attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerAttributes(final java.util.List<? extends java.lang.Object> loadBalancerAttributes) {
            this.props().loadBalancerAttributes(loadBalancerAttributes);
            return this;
        }

        /**
         * The name of the load balancer.
         * <p>
         * This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must not begin with "internal-".
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID for the load balancer. If you specify a name, you cannot perform updates that require replacement of this resource, but you can perform other updates. To replace the resource, specify a new name.
         * <p>
         * @return {@code this}
         * @param name The name of the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The nodes of an Internet-facing load balancer have public IP addresses.
         * <p>
         * The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.
         * <p>
         * The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.
         * <p>
         * The default is an Internet-facing load balancer.
         * <p>
         * You cannot specify a scheme for a Gateway Load Balancer.
         * <p>
         * @return {@code this}
         * @param scheme The nodes of an Internet-facing load balancer have public IP addresses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheme(final java.lang.String scheme) {
            this.props().scheme(scheme);
            return this;
        }

        /**
         * [Application Load Balancers] The IDs of the security groups for the load balancer.
         * <p>
         * @return {@code this}
         * @param securityGroups [Application Load Balancers] The IDs of the security groups for the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<java.lang.String> securityGroups) {
            this.props().securityGroups(securityGroups);
            return this;
        }

        /**
         * The IDs of the public subnets.
         * <p>
         * You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both.
         * <p>
         * [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.
         * <p>
         * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         * <p>
         * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         * <p>
         * [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
         * <p>
         * [Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets.
         * <p>
         * @return {@code this}
         * @param subnetMappings The IDs of the public subnets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetMappings(final software.amazon.awscdk.core.IResolvable subnetMappings) {
            this.props().subnetMappings(subnetMappings);
            return this;
        }
        /**
         * The IDs of the public subnets.
         * <p>
         * You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both.
         * <p>
         * [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.
         * <p>
         * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         * <p>
         * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         * <p>
         * [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
         * <p>
         * [Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets.
         * <p>
         * @return {@code this}
         * @param subnetMappings The IDs of the public subnets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetMappings(final java.util.List<? extends java.lang.Object> subnetMappings) {
            this.props().subnetMappings(subnetMappings);
            return this;
        }

        /**
         * The IDs of the public subnets.
         * <p>
         * You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both. To specify an Elastic IP address, specify subnet mappings instead of subnets.
         * <p>
         * [Application Load Balancers] You must specify subnets from at least two Availability Zones.
         * <p>
         * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         * <p>
         * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         * <p>
         * [Network Load Balancers] You can specify subnets from one or more Availability Zones.
         * <p>
         * [Gateway Load Balancers] You can specify subnets from one or more Availability Zones.
         * <p>
         * @return {@code this}
         * @param subnets The IDs of the public subnets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(final java.util.List<java.lang.String> subnets) {
            this.props().subnets(subnets);
            return this;
        }

        /**
         * The tags to assign to the load balancer.
         * <p>
         * @return {@code this}
         * @param tags The tags to assign to the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The type of load balancer.
         * <p>
         * The default is <code>application</code> .
         * <p>
         * @return {@code this}
         * @param type The type of load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props().type(type);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancer build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancer(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancerProps.Builder();
            }
            return this.props;
        }
    }
}
