package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Load balancing protocol version for application load balancers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ApplicationTargetGroup tg = ApplicationTargetGroup.Builder.create(this, "TG")
 *         .targetType(TargetType.IP)
 *         .port(50051)
 *         .protocol(ApplicationProtocol.HTTP)
 *         .protocolVersion(ApplicationProtocolVersion.GRPC)
 *         .healthCheck(HealthCheck.builder()
 *                 .enabled(true)
 *                 .healthyGrpcCodes("0-99")
 *                 .build())
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:42.269Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationProtocolVersion")
public enum ApplicationProtocolVersion {
    /**
     * GRPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRPC,
    /**
     * HTTP1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP1,
    /**
     * HTTP2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP2,
}
