package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Basic properties for defining a rule on a listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:25.266Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.BaseApplicationListenerRuleProps")
@software.amazon.jsii.Jsii.Proxy(BaseApplicationListenerRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseApplicationListenerRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Priority of the rule.
     * 
     * <p>The rule with the lowest priority will be used for every request.</p>
     * <p>Priorities must be unique.</p>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getPriority();

    /**
     * Fixed response to return.
     * 
     * <p>Only one of <code>fixedResponse</code>, <code>redirectResponse</code> or
     * <code>targetGroups</code> can be specified.</p>
     * 
     * Default: - No fixed response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse getFixedResponse() {
        return null;
    }

    /**
     * Rule applies if the requested host matches the indicated host.
     * 
     * <p>May contain up to three '*' wildcards.</p>
     * 
     * Default: - No host condition.
     * 
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getHostHeader() {
        return null;
    }

    /**
     * Rule applies if the requested path matches the given path pattern.
     * 
     * <p>May contain up to three '*' wildcards.</p>
     * 
     * Default: - No path condition.
     * 
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getPathPattern() {
        return null;
    }

    /**
     * Redirect response to return.
     * 
     * <p>Only one of <code>fixedResponse</code>, <code>redirectResponse</code> or
     * <code>targetGroups</code> can be specified.</p>
     * 
     * Default: - No redirect response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse getRedirectResponse() {
        return null;
    }

    /**
     * Target groups to forward requests to.
     * 
     * <p>Only one of <code>fixedResponse</code>, <code>redirectResponse</code> or
     * <code>targetGroups</code> can be specified.</p>
     * 
     * Default: - No target groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BaseApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Number priority;
        private software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse;
        private java.lang.String hostHeader;
        private java.lang.String pathPattern;
        private software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse redirectResponse;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups;

        /**
         * Sets the value of Priority
         * @param priority Priority of the rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of FixedResponse
         * @param fixedResponse Fixed response to return.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fixedResponse(software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse) {
            this.fixedResponse = fixedResponse;
            return this;
        }

        /**
         * Sets the value of HostHeader
         * @param hostHeader Rule applies if the requested host matches the indicated host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostHeader(java.lang.String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        /**
         * Sets the value of PathPattern
         * @param pathPattern Rule applies if the requested path matches the given path pattern.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathPattern(java.lang.String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        /**
         * Sets the value of RedirectResponse
         * @param redirectResponse Redirect response to return.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redirectResponse(software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse redirectResponse) {
            this.redirectResponse = redirectResponse;
            return this;
        }

        /**
         * Sets the value of TargetGroups
         * @param targetGroups Target groups to forward requests to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroups(java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups) {
            this.targetGroups = targetGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseApplicationListenerRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public BaseApplicationListenerRuleProps build() {
            return new Jsii$Proxy(priority, fixedResponse, hostHeader, pathPattern, redirectResponse, targetGroups);
        }
    }

    /**
     * An implementation for {@link BaseApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseApplicationListenerRuleProps {
        private final java.lang.Number priority;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse;
        private final java.lang.String hostHeader;
        private final java.lang.String pathPattern;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse redirectResponse;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.priority = this.jsiiGet("priority", java.lang.Number.class);
            this.fixedResponse = this.jsiiGet("fixedResponse", software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse.class);
            this.hostHeader = this.jsiiGet("hostHeader", java.lang.String.class);
            this.pathPattern = this.jsiiGet("pathPattern", java.lang.String.class);
            this.redirectResponse = this.jsiiGet("redirectResponse", software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse.class);
            this.targetGroups = this.jsiiGet("targetGroups", java.util.List.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number priority, final software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse, final java.lang.String hostHeader, final java.lang.String pathPattern, final software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse redirectResponse, final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.priority = java.util.Objects.requireNonNull(priority, "priority is required");
            this.fixedResponse = fixedResponse;
            this.hostHeader = hostHeader;
            this.pathPattern = pathPattern;
            this.redirectResponse = redirectResponse;
            this.targetGroups = targetGroups;
        }

        @Override
        public java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse getFixedResponse() {
            return this.fixedResponse;
        }

        @Override
        public java.lang.String getHostHeader() {
            return this.hostHeader;
        }

        @Override
        public java.lang.String getPathPattern() {
            return this.pathPattern;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.RedirectResponse getRedirectResponse() {
            return this.redirectResponse;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
            return this.targetGroups;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("priority", om.valueToTree(this.getPriority()));
            if (this.getFixedResponse() != null) {
                data.set("fixedResponse", om.valueToTree(this.getFixedResponse()));
            }
            if (this.getHostHeader() != null) {
                data.set("hostHeader", om.valueToTree(this.getHostHeader()));
            }
            if (this.getPathPattern() != null) {
                data.set("pathPattern", om.valueToTree(this.getPathPattern()));
            }
            if (this.getRedirectResponse() != null) {
                data.set("redirectResponse", om.valueToTree(this.getRedirectResponse()));
            }
            if (this.getTargetGroups() != null) {
                data.set("targetGroups", om.valueToTree(this.getTargetGroups()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.BaseApplicationListenerRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseApplicationListenerRuleProps.Jsii$Proxy that = (BaseApplicationListenerRuleProps.Jsii$Proxy) o;

            if (!priority.equals(that.priority)) return false;
            if (this.fixedResponse != null ? !this.fixedResponse.equals(that.fixedResponse) : that.fixedResponse != null) return false;
            if (this.hostHeader != null ? !this.hostHeader.equals(that.hostHeader) : that.hostHeader != null) return false;
            if (this.pathPattern != null ? !this.pathPattern.equals(that.pathPattern) : that.pathPattern != null) return false;
            if (this.redirectResponse != null ? !this.redirectResponse.equals(that.redirectResponse) : that.redirectResponse != null) return false;
            return this.targetGroups != null ? this.targetGroups.equals(that.targetGroups) : that.targetGroups == null;
        }

        @Override
        public int hashCode() {
            int result = this.priority.hashCode();
            result = 31 * result + (this.fixedResponse != null ? this.fixedResponse.hashCode() : 0);
            result = 31 * result + (this.hostHeader != null ? this.hostHeader.hashCode() : 0);
            result = 31 * result + (this.pathPattern != null ? this.pathPattern.hashCode() : 0);
            result = 31 * result + (this.redirectResponse != null ? this.redirectResponse.hashCode() : 0);
            result = 31 * result + (this.targetGroups != null ? this.targetGroups.hashCode() : 0);
            return result;
        }
    }
}
