/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.Objects;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.elasticloadbalancingv2.$Module;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerAttributes;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeElb;
import software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-elasticloadbalancingv2.ApplicationLoadBalancer")
public class ApplicationLoadBalancer
extends BaseLoadBalancer
implements IApplicationLoadBalancer {
    protected ApplicationLoadBalancer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationLoadBalancer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ApplicationLoadBalancer(Construct scope, String id, ApplicationLoadBalancerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public static IApplicationLoadBalancer fromApplicationLoadBalancerAttributes(Construct scope, String id, ApplicationLoadBalancerAttributes attrs) {
        return (IApplicationLoadBalancer)JsiiObject.jsiiStaticCall(ApplicationLoadBalancer.class, (String)"fromApplicationLoadBalancerAttributes", IApplicationLoadBalancer.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    public ApplicationListener addListener(String id, BaseApplicationListenerProps props) {
        return (ApplicationListener)this.jsiiCall("addListener", ApplicationListener.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void logAccessLogs(IBucket bucket, String prefix) {
        this.jsiiCall("logAccessLogs", Void.class, new Object[]{Objects.requireNonNull(bucket, "bucket is required"), prefix});
    }

    public void logAccessLogs(IBucket bucket) {
        this.jsiiCall("logAccessLogs", Void.class, new Object[]{Objects.requireNonNull(bucket, "bucket is required")});
    }

    public Metric metric(String metricName, MetricOptions props) {
        return (Metric)this.jsiiCall("metric", Metric.class, new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    public Metric metric(String metricName) {
        return (Metric)this.jsiiCall("metric", Metric.class, new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    public Metric metricActiveConnectionCount(MetricOptions props) {
        return (Metric)this.jsiiCall("metricActiveConnectionCount", Metric.class, new Object[]{props});
    }

    public Metric metricActiveConnectionCount() {
        return (Metric)this.jsiiCall("metricActiveConnectionCount", Metric.class, new Object[0]);
    }

    public Metric metricClientTlsNegotiationErrorCount(MetricOptions props) {
        return (Metric)this.jsiiCall("metricClientTlsNegotiationErrorCount", Metric.class, new Object[]{props});
    }

    public Metric metricClientTlsNegotiationErrorCount() {
        return (Metric)this.jsiiCall("metricClientTlsNegotiationErrorCount", Metric.class, new Object[0]);
    }

    public Metric metricConsumedLCUs(MetricOptions props) {
        return (Metric)this.jsiiCall("metricConsumedLCUs", Metric.class, new Object[]{props});
    }

    public Metric metricConsumedLCUs() {
        return (Metric)this.jsiiCall("metricConsumedLCUs", Metric.class, new Object[0]);
    }

    public Metric metricElbAuthError(MetricOptions props) {
        return (Metric)this.jsiiCall("metricElbAuthError", Metric.class, new Object[]{props});
    }

    public Metric metricElbAuthError() {
        return (Metric)this.jsiiCall("metricElbAuthError", Metric.class, new Object[0]);
    }

    public Metric metricElbAuthFailure(MetricOptions props) {
        return (Metric)this.jsiiCall("metricElbAuthFailure", Metric.class, new Object[]{props});
    }

    public Metric metricElbAuthFailure() {
        return (Metric)this.jsiiCall("metricElbAuthFailure", Metric.class, new Object[0]);
    }

    public Metric metricElbAuthLatency(MetricOptions props) {
        return (Metric)this.jsiiCall("metricElbAuthLatency", Metric.class, new Object[]{props});
    }

    public Metric metricElbAuthLatency() {
        return (Metric)this.jsiiCall("metricElbAuthLatency", Metric.class, new Object[0]);
    }

    public Metric metricElbAuthSuccess(MetricOptions props) {
        return (Metric)this.jsiiCall("metricElbAuthSuccess", Metric.class, new Object[]{props});
    }

    public Metric metricElbAuthSuccess() {
        return (Metric)this.jsiiCall("metricElbAuthSuccess", Metric.class, new Object[0]);
    }

    public Metric metricHttpCodeElb(HttpCodeElb code, MetricOptions props) {
        return (Metric)this.jsiiCall("metricHttpCodeElb", Metric.class, new Object[]{Objects.requireNonNull(code, "code is required"), props});
    }

    public Metric metricHttpCodeElb(HttpCodeElb code) {
        return (Metric)this.jsiiCall("metricHttpCodeElb", Metric.class, new Object[]{Objects.requireNonNull(code, "code is required")});
    }

    public Metric metricHttpCodeTarget(HttpCodeTarget code, MetricOptions props) {
        return (Metric)this.jsiiCall("metricHttpCodeTarget", Metric.class, new Object[]{Objects.requireNonNull(code, "code is required"), props});
    }

    public Metric metricHttpCodeTarget(HttpCodeTarget code) {
        return (Metric)this.jsiiCall("metricHttpCodeTarget", Metric.class, new Object[]{Objects.requireNonNull(code, "code is required")});
    }

    public Metric metricHttpFixedResponseCount(MetricOptions props) {
        return (Metric)this.jsiiCall("metricHttpFixedResponseCount", Metric.class, new Object[]{props});
    }

    public Metric metricHttpFixedResponseCount() {
        return (Metric)this.jsiiCall("metricHttpFixedResponseCount", Metric.class, new Object[0]);
    }

    public Metric metricHttpRedirectCount(MetricOptions props) {
        return (Metric)this.jsiiCall("metricHttpRedirectCount", Metric.class, new Object[]{props});
    }

    public Metric metricHttpRedirectCount() {
        return (Metric)this.jsiiCall("metricHttpRedirectCount", Metric.class, new Object[0]);
    }

    public Metric metricHttpRedirectUrlLimitExceededCount(MetricOptions props) {
        return (Metric)this.jsiiCall("metricHttpRedirectUrlLimitExceededCount", Metric.class, new Object[]{props});
    }

    public Metric metricHttpRedirectUrlLimitExceededCount() {
        return (Metric)this.jsiiCall("metricHttpRedirectUrlLimitExceededCount", Metric.class, new Object[0]);
    }

    public Metric metricIpv6ProcessedBytes(MetricOptions props) {
        return (Metric)this.jsiiCall("metricIpv6ProcessedBytes", Metric.class, new Object[]{props});
    }

    public Metric metricIpv6ProcessedBytes() {
        return (Metric)this.jsiiCall("metricIpv6ProcessedBytes", Metric.class, new Object[0]);
    }

    public Metric metricIpv6RequestCount(MetricOptions props) {
        return (Metric)this.jsiiCall("metricIpv6RequestCount", Metric.class, new Object[]{props});
    }

    public Metric metricIpv6RequestCount() {
        return (Metric)this.jsiiCall("metricIpv6RequestCount", Metric.class, new Object[0]);
    }

    public Metric metricNewConnectionCount(MetricOptions props) {
        return (Metric)this.jsiiCall("metricNewConnectionCount", Metric.class, new Object[]{props});
    }

    public Metric metricNewConnectionCount() {
        return (Metric)this.jsiiCall("metricNewConnectionCount", Metric.class, new Object[0]);
    }

    public Metric metricProcessedBytes(MetricOptions props) {
        return (Metric)this.jsiiCall("metricProcessedBytes", Metric.class, new Object[]{props});
    }

    public Metric metricProcessedBytes() {
        return (Metric)this.jsiiCall("metricProcessedBytes", Metric.class, new Object[0]);
    }

    public Metric metricRejectedConnectionCount(MetricOptions props) {
        return (Metric)this.jsiiCall("metricRejectedConnectionCount", Metric.class, new Object[]{props});
    }

    public Metric metricRejectedConnectionCount() {
        return (Metric)this.jsiiCall("metricRejectedConnectionCount", Metric.class, new Object[0]);
    }

    public Metric metricRequestCount(MetricOptions props) {
        return (Metric)this.jsiiCall("metricRequestCount", Metric.class, new Object[]{props});
    }

    public Metric metricRequestCount() {
        return (Metric)this.jsiiCall("metricRequestCount", Metric.class, new Object[0]);
    }

    public Metric metricRuleEvaluations(MetricOptions props) {
        return (Metric)this.jsiiCall("metricRuleEvaluations", Metric.class, new Object[]{props});
    }

    public Metric metricRuleEvaluations() {
        return (Metric)this.jsiiCall("metricRuleEvaluations", Metric.class, new Object[0]);
    }

    public Metric metricTargetConnectionErrorCount(MetricOptions props) {
        return (Metric)this.jsiiCall("metricTargetConnectionErrorCount", Metric.class, new Object[]{props});
    }

    public Metric metricTargetConnectionErrorCount() {
        return (Metric)this.jsiiCall("metricTargetConnectionErrorCount", Metric.class, new Object[0]);
    }

    public Metric metricTargetResponseTime(MetricOptions props) {
        return (Metric)this.jsiiCall("metricTargetResponseTime", Metric.class, new Object[]{props});
    }

    public Metric metricTargetResponseTime() {
        return (Metric)this.jsiiCall("metricTargetResponseTime", Metric.class, new Object[0]);
    }

    public Metric metricTargetTLSNegotiationErrorCount(MetricOptions props) {
        return (Metric)this.jsiiCall("metricTargetTLSNegotiationErrorCount", Metric.class, new Object[]{props});
    }

    public Metric metricTargetTLSNegotiationErrorCount() {
        return (Metric)this.jsiiCall("metricTargetTLSNegotiationErrorCount", Metric.class, new Object[0]);
    }

    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final ApplicationLoadBalancerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ApplicationLoadBalancerProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        public Builder internetFacing(Boolean internetFacing) {
            this.props.internetFacing(internetFacing);
            return this;
        }

        public Builder loadBalancerName(String loadBalancerName) {
            this.props.loadBalancerName(loadBalancerName);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder http2Enabled(Boolean http2Enabled) {
            this.props.http2Enabled(http2Enabled);
            return this;
        }

        public Builder idleTimeout(Duration idleTimeout) {
            this.props.idleTimeout(idleTimeout);
            return this;
        }

        public Builder ipAddressType(IpAddressType ipAddressType) {
            this.props.ipAddressType(ipAddressType);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public ApplicationLoadBalancer build() {
            return new ApplicationLoadBalancer(this.scope, this.id, this.props.build());
        }
    }
}

