package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * What to do when a client makes a request to a listener.
 * <p>
 * Some actions can be combined with other ones (specifically,
 * you can perform authentication before serving the request).
 * <p>
 * Multiple actions form a linked chain; the chain must always terminate in a
 * <em>(weighted)forward</em>, <em>fixedResponse</em> or <em>redirect</em> action.
 * <p>
 * If an action supports chaining, the next action can be indicated
 * by passing it in the <code>next</code> property.
 * <p>
 * (Called <code>ListenerAction</code> instead of the more strictly correct
 * <code>ListenerAction</code> because this is the class most users interact
 * with, and we want to make it not too visually overwhelming).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ApplicationListener listener;
 * ApplicationTargetGroup myTargetGroup;
 * listener.addAction("DefaultAction", AddApplicationActionProps.builder()
 *         .action(ListenerAction.authenticateOidc(AuthenticateOidcOptions.builder()
 *                 .authorizationEndpoint("https://example.com/openid")
 *                 // Other OIDC properties here
 *                 .clientId("...")
 *                 .clientSecret(SecretValue.secretsManager("..."))
 *                 .issuer("...")
 *                 .tokenEndpoint("...")
 *                 .userInfoEndpoint("...")
 *                 // Next
 *                 .next(ListenerAction.forward(List.of(myTargetGroup)))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-14T20:30:53.516Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ListenerAction")
public class ListenerAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.IListenerAction {

    protected ListenerAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ListenerAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create an instance of ListenerAction.
     * <p>
     * The default class should be good enough for most cases and
     * should be created by using one of the static factory functions,
     * but allow overriding to make sure we allow flexibility for the future.
     * <p>
     * @param actionJson This parameter is required.
     * @param next
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ListenerAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty actionJson, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction next) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(actionJson, "actionJson is required"), next });
    }

    /**
     * Create an instance of ListenerAction.
     * <p>
     * The default class should be good enough for most cases and
     * should be created by using one of the static factory functions,
     * but allow overriding to make sure we allow flexibility for the future.
     * <p>
     * @param actionJson This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ListenerAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty actionJson) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(actionJson, "actionJson is required") });
    }

    /**
     * Authenticate using an identity provider (IdP) that is compliant with OpenID Connect (OIDC).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/listener-authenticate-users.html#oidc-requirements">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/listener-authenticate-users.html#oidc-requirements</a>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction authenticateOidc(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.AuthenticateOidcOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class, "authenticateOidc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Return a fixed response.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#fixed-response-actions">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#fixed-response-actions</a>
     * @param statusCode This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction fixedResponse(final @org.jetbrains.annotations.NotNull java.lang.Number statusCode, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponseOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class, "fixedResponse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class), new Object[] { java.util.Objects.requireNonNull(statusCode, "statusCode is required"), options });
    }

    /**
     * Return a fixed response.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#fixed-response-actions">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#fixed-response-actions</a>
     * @param statusCode This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction fixedResponse(final @org.jetbrains.annotations.NotNull java.lang.Number statusCode) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class, "fixedResponse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class), new Object[] { java.util.Objects.requireNonNull(statusCode, "statusCode is required") });
    }

    /**
     * Forward to one or more Target Groups.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#forward-actions">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#forward-actions</a>
     * @param targetGroups This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction forward(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ForwardOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class, "forward", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class), new Object[] { java.util.Objects.requireNonNull(targetGroups, "targetGroups is required"), options });
    }

    /**
     * Forward to one or more Target Groups.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#forward-actions">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#forward-actions</a>
     * @param targetGroups This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction forward(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class, "forward", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class), new Object[] { java.util.Objects.requireNonNull(targetGroups, "targetGroups is required") });
    }

    /**
     * Redirect to a different URI.
     * <p>
     * A URI consists of the following components:
     * protocol://hostname:port/path?query. You must modify at least one of the
     * following components to avoid a redirect loop: protocol, hostname, port, or
     * path. Any components that you do not modify retain their original values.
     * <p>
     * You can reuse URI components using the following reserved keywords:
     * <p>
     * <ul>
     * <li><code>#{protocol}</code></li>
     * <li><code>#{host}</code></li>
     * <li><code>#{port}</code></li>
     * <li><code>#{path}</code> (the leading "/" is removed)</li>
     * <li><code>#{query}</code></li>
     * </ul>
     * <p>
     * For example, you can change the path to "/new/#{path}", the hostname to
     * "example.#{host}", or the query to "#{query}&amp;value=xyz".
     * <p>
     * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#redirect-actions">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#redirect-actions</a>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction redirect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.RedirectOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class, "redirect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Forward to one or more Target Groups which are weighted differently.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#forward-actions">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#forward-actions</a>
     * @param targetGroups This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction weightedForward(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.WeightedTargetGroup> targetGroups, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ForwardOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class, "weightedForward", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class), new Object[] { java.util.Objects.requireNonNull(targetGroups, "targetGroups is required"), options });
    }

    /**
     * Forward to one or more Target Groups which are weighted differently.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#forward-actions">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#forward-actions</a>
     * @param targetGroups This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction weightedForward(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.WeightedTargetGroup> targetGroups) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class, "weightedForward", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class), new Object[] { java.util.Objects.requireNonNull(targetGroups, "targetGroups is required") });
    }

    /**
     * Called when the action is being used in a listener.
     * <p>
     * @param scope This parameter is required.
     * @param listener This parameter is required.
     * @param associatingConstruct
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IConstruct associatingConstruct) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(listener, "listener is required"), associatingConstruct });
    }

    /**
     * Called when the action is being used in a listener.
     * <p>
     * @param scope This parameter is required.
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     * Render the actions in this chain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty> renderActions() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "renderActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty.class))));
    }

    /**
     * Renumber the "order" fields in the actions array.
     * <p>
     * We don't number for 0 or 1 elements, but otherwise number them 1...#actions
     * so ELB knows about the right order.
     * <p>
     * Do this in <code>ListenerAction</code> instead of in <code>Listener</code> so that we give
     * users the opportunity to override by subclassing and overriding <code>renderActions</code>.
     * <p>
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty> renumber(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty> actions) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "renumber", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty.class)), new Object[] { java.util.Objects.requireNonNull(actions, "actions is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction getNext() {
        return software.amazon.jsii.Kernel.get(this, "next", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class));
    }
}
