package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Load balancing protocol for application load balancers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ApplicationListener listener;
 * BaseService service;
 * service.registerLoadBalancerTargets(EcsTarget.builder()
 *         .containerName("web")
 *         .containerPort(80)
 *         .newTargetGroupId("ECS")
 *         .listener(ListenerConfig.applicationListener(listener, AddApplicationTargetsProps.builder()
 *                 .protocol(ApplicationProtocol.HTTPS)
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-31T18:36:57.524Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationProtocol")
public enum ApplicationProtocol {
    /**
     * HTTP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP,
    /**
     * HTTPS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTPS,
}
