package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding a conditional load balancing rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * ListenerCondition listenerCondition;
 * AddRuleProps addRuleProps = AddRuleProps.builder()
 *         .conditions(List.of(listenerCondition))
 *         .hostHeader("hostHeader")
 *         .pathPattern("pathPattern")
 *         .pathPatterns(List.of("pathPatterns"))
 *         .priority(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-15T20:01:42.611Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.AddRuleProps")
@software.amazon.jsii.Jsii.Proxy(AddRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Rule applies if matches the conditions.
     * <p>
     * Default: - No conditions.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> getConditions() {
        return null;
    }

    /**
     * (deprecated) Rule applies if the requested host matches the indicated host.
     * <p>
     * May contain up to three '*' wildcards.
     * <p>
     * Requires that priority is set.
     * <p>
     * Default: No host condition
     * <p>
     * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions</a>
     * @deprecated Use `conditions` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getHostHeader() {
        return null;
    }

    /**
     * (deprecated) Rule applies if the requested path matches the given path pattern.
     * <p>
     * May contain up to three '*' wildcards.
     * <p>
     * Requires that priority is set.
     * <p>
     * Default: No path condition
     * <p>
     * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions</a>
     * @deprecated Use `conditions` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getPathPattern() {
        return null;
    }

    /**
     * (deprecated) Rule applies if the requested path matches any of the given patterns.
     * <p>
     * May contain up to three '*' wildcards.
     * <p>
     * Requires that priority is set.
     * <p>
     * Default: - No path condition.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions</a>
     * @deprecated Use `conditions` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPathPatterns() {
        return null;
    }

    /**
     * Priority of this target group.
     * <p>
     * The rule with the lowest priority will be used for every request.
     * If priority is not given, these target groups will be added as
     * defaults, and must not have conditions.
     * <p>
     * Priorities must be unique.
     * <p>
     * Default: Target groups are used as defaults
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddRuleProps> {
        java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions;
        java.lang.String hostHeader;
        java.lang.String pathPattern;
        java.util.List<java.lang.String> pathPatterns;
        java.lang.Number priority;

        /**
         * Sets the value of {@link AddRuleProps#getConditions}
         * @param conditions Rule applies if matches the conditions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder conditions(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions) {
            this.conditions = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition>)conditions;
            return this;
        }

        /**
         * Sets the value of {@link AddRuleProps#getHostHeader}
         * @param hostHeader Rule applies if the requested host matches the indicated host.
         *                   May contain up to three '*' wildcards.
         *                   <p>
         *                   Requires that priority is set.
         * @return {@code this}
         * @deprecated Use `conditions` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder hostHeader(java.lang.String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        /**
         * Sets the value of {@link AddRuleProps#getPathPattern}
         * @param pathPattern Rule applies if the requested path matches the given path pattern.
         *                    May contain up to three '*' wildcards.
         *                    <p>
         *                    Requires that priority is set.
         * @return {@code this}
         * @deprecated Use `conditions` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pathPattern(java.lang.String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        /**
         * Sets the value of {@link AddRuleProps#getPathPatterns}
         * @param pathPatterns Rule applies if the requested path matches any of the given patterns.
         *                     May contain up to three '*' wildcards.
         *                     <p>
         *                     Requires that priority is set.
         * @return {@code this}
         * @deprecated Use `conditions` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pathPatterns(java.util.List<java.lang.String> pathPatterns) {
            this.pathPatterns = pathPatterns;
            return this;
        }

        /**
         * Sets the value of {@link AddRuleProps#getPriority}
         * @param priority Priority of this target group.
         *                 The rule with the lowest priority will be used for every request.
         *                 If priority is not given, these target groups will be added as
         *                 defaults, and must not have conditions.
         *                 <p>
         *                 Priorities must be unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AddRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddRuleProps {
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions;
        private final java.lang.String hostHeader;
        private final java.lang.String pathPattern;
        private final java.util.List<java.lang.String> pathPatterns;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition.class)));
            this.hostHeader = software.amazon.jsii.Kernel.get(this, "hostHeader", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pathPattern = software.amazon.jsii.Kernel.get(this, "pathPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pathPatterns = software.amazon.jsii.Kernel.get(this, "pathPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.conditions = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition>)builder.conditions;
            this.hostHeader = builder.hostHeader;
            this.pathPattern = builder.pathPattern;
            this.pathPatterns = builder.pathPatterns;
            this.priority = builder.priority;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> getConditions() {
            return this.conditions;
        }

        @Override
        public final java.lang.String getHostHeader() {
            return this.hostHeader;
        }

        @Override
        public final java.lang.String getPathPattern() {
            return this.pathPattern;
        }

        @Override
        public final java.util.List<java.lang.String> getPathPatterns() {
            return this.pathPatterns;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConditions() != null) {
                data.set("conditions", om.valueToTree(this.getConditions()));
            }
            if (this.getHostHeader() != null) {
                data.set("hostHeader", om.valueToTree(this.getHostHeader()));
            }
            if (this.getPathPattern() != null) {
                data.set("pathPattern", om.valueToTree(this.getPathPattern()));
            }
            if (this.getPathPatterns() != null) {
                data.set("pathPatterns", om.valueToTree(this.getPathPatterns()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.AddRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddRuleProps.Jsii$Proxy that = (AddRuleProps.Jsii$Proxy) o;

            if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) return false;
            if (this.hostHeader != null ? !this.hostHeader.equals(that.hostHeader) : that.hostHeader != null) return false;
            if (this.pathPattern != null ? !this.pathPattern.equals(that.pathPattern) : that.pathPattern != null) return false;
            if (this.pathPatterns != null ? !this.pathPatterns.equals(that.pathPatterns) : that.pathPatterns != null) return false;
            return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
        }

        @Override
        public final int hashCode() {
            int result = this.conditions != null ? this.conditions.hashCode() : 0;
            result = 31 * result + (this.hostHeader != null ? this.hostHeader.hashCode() : 0);
            result = 31 * result + (this.pathPattern != null ? this.pathPattern.hashCode() : 0);
            result = 31 * result + (this.pathPatterns != null ? this.pathPatterns.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }
    }
}
