package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for a redirection config.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ApplicationLoadBalancer lb;
 * lb.addRedirect(ApplicationLoadBalancerRedirectConfig.builder()
 *         .sourceProtocol(ApplicationProtocol.HTTPS)
 *         .sourcePort(8443)
 *         .targetProtocol(ApplicationProtocol.HTTP)
 *         .targetPort(8080)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-08T16:00:30.559Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationLoadBalancerRedirectConfig")
@software.amazon.jsii.Jsii.Proxy(ApplicationLoadBalancerRedirectConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationLoadBalancerRedirectConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Allow anyone to connect to this listener.
     * <p>
     * If this is specified, the listener will be opened up to anyone who can reach it.
     * For internal load balancers this is anyone in the same VPC. For public load
     * balancers, this is anyone on the internet.
     * <p>
     * If you want to be more selective about who can access this load
     * balancer, set this to <code>false</code> and use the listener's <code>connections</code>
     * object to selectively grant access to the listener.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOpen() {
        return null;
    }

    /**
     * The port number to listen to.
     * <p>
     * Default: 80
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSourcePort() {
        return null;
    }

    /**
     * The protocol of the listener being created.
     * <p>
     * Default: HTTP
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getSourceProtocol() {
        return null;
    }

    /**
     * The port number to redirect to.
     * <p>
     * Default: 443
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTargetPort() {
        return null;
    }

    /**
     * The protocol of the redirection target.
     * <p>
     * Default: HTTPS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getTargetProtocol() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancerRedirectConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationLoadBalancerRedirectConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationLoadBalancerRedirectConfig> {
        java.lang.Boolean open;
        java.lang.Number sourcePort;
        software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol sourceProtocol;
        java.lang.Number targetPort;
        software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol targetProtocol;

        /**
         * Sets the value of {@link ApplicationLoadBalancerRedirectConfig#getOpen}
         * @param open Allow anyone to connect to this listener.
         *             If this is specified, the listener will be opened up to anyone who can reach it.
         *             For internal load balancers this is anyone in the same VPC. For public load
         *             balancers, this is anyone on the internet.
         *             <p>
         *             If you want to be more selective about who can access this load
         *             balancer, set this to <code>false</code> and use the listener's <code>connections</code>
         *             object to selectively grant access to the listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder open(java.lang.Boolean open) {
            this.open = open;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerRedirectConfig#getSourcePort}
         * @param sourcePort The port number to listen to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourcePort(java.lang.Number sourcePort) {
            this.sourcePort = sourcePort;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerRedirectConfig#getSourceProtocol}
         * @param sourceProtocol The protocol of the listener being created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceProtocol(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol sourceProtocol) {
            this.sourceProtocol = sourceProtocol;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerRedirectConfig#getTargetPort}
         * @param targetPort The port number to redirect to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetPort(java.lang.Number targetPort) {
            this.targetPort = targetPort;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerRedirectConfig#getTargetProtocol}
         * @param targetProtocol The protocol of the redirection target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetProtocol(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol targetProtocol) {
            this.targetProtocol = targetProtocol;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancerRedirectConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationLoadBalancerRedirectConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationLoadBalancerRedirectConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationLoadBalancerRedirectConfig {
        private final java.lang.Boolean open;
        private final java.lang.Number sourcePort;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol sourceProtocol;
        private final java.lang.Number targetPort;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol targetProtocol;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.open = software.amazon.jsii.Kernel.get(this, "open", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.sourcePort = software.amazon.jsii.Kernel.get(this, "sourcePort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.sourceProtocol = software.amazon.jsii.Kernel.get(this, "sourceProtocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class));
            this.targetPort = software.amazon.jsii.Kernel.get(this, "targetPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.targetProtocol = software.amazon.jsii.Kernel.get(this, "targetProtocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.open = builder.open;
            this.sourcePort = builder.sourcePort;
            this.sourceProtocol = builder.sourceProtocol;
            this.targetPort = builder.targetPort;
            this.targetProtocol = builder.targetProtocol;
        }

        @Override
        public final java.lang.Boolean getOpen() {
            return this.open;
        }

        @Override
        public final java.lang.Number getSourcePort() {
            return this.sourcePort;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getSourceProtocol() {
            return this.sourceProtocol;
        }

        @Override
        public final java.lang.Number getTargetPort() {
            return this.targetPort;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getTargetProtocol() {
            return this.targetProtocol;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getOpen() != null) {
                data.set("open", om.valueToTree(this.getOpen()));
            }
            if (this.getSourcePort() != null) {
                data.set("sourcePort", om.valueToTree(this.getSourcePort()));
            }
            if (this.getSourceProtocol() != null) {
                data.set("sourceProtocol", om.valueToTree(this.getSourceProtocol()));
            }
            if (this.getTargetPort() != null) {
                data.set("targetPort", om.valueToTree(this.getTargetPort()));
            }
            if (this.getTargetProtocol() != null) {
                data.set("targetProtocol", om.valueToTree(this.getTargetProtocol()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.ApplicationLoadBalancerRedirectConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationLoadBalancerRedirectConfig.Jsii$Proxy that = (ApplicationLoadBalancerRedirectConfig.Jsii$Proxy) o;

            if (this.open != null ? !this.open.equals(that.open) : that.open != null) return false;
            if (this.sourcePort != null ? !this.sourcePort.equals(that.sourcePort) : that.sourcePort != null) return false;
            if (this.sourceProtocol != null ? !this.sourceProtocol.equals(that.sourceProtocol) : that.sourceProtocol != null) return false;
            if (this.targetPort != null ? !this.targetPort.equals(that.targetPort) : that.targetPort != null) return false;
            return this.targetProtocol != null ? this.targetProtocol.equals(that.targetProtocol) : that.targetProtocol == null;
        }

        @Override
        public final int hashCode() {
            int result = this.open != null ? this.open.hashCode() : 0;
            result = 31 * result + (this.sourcePort != null ? this.sourcePort.hashCode() : 0);
            result = 31 * result + (this.sourceProtocol != null ? this.sourceProtocol.hashCode() : 0);
            result = 31 * result + (this.targetPort != null ? this.targetPort.hashCode() : 0);
            result = 31 * result + (this.targetProtocol != null ? this.targetProtocol.hashCode() : 0);
            return result;
        }
    }
}
