package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define an Application Load Balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.integrations.HttpAlbIntegration;
 * Vpc vpc = new Vpc(this, "VPC");
 * ApplicationLoadBalancer lb = ApplicationLoadBalancer.Builder.create(this, "lb").vpc(vpc).build();
 * ApplicationListener listener = lb.addListener("listener", BaseApplicationListenerProps.builder().port(80).build());
 * listener.addTargets("target", AddApplicationTargetsProps.builder()
 *         .port(80)
 *         .build());
 * HttpApi httpEndpoint = HttpApi.Builder.create(this, "HttpProxyPrivateApi")
 *         .defaultIntegration(new HttpAlbIntegration("DefaultIntegration", listener))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-28T21:34:26.197Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationLoadBalancer")
public class ApplicationLoadBalancer extends software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancer implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer {

    protected ApplicationLoadBalancer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationLoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApplicationLoadBalancer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing Application Load Balancer.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer fromApplicationLoadBalancerAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer.class, "fromApplicationLoadBalancerAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Look up an application load balancer.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer fromLookup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerLookupOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer.class, "fromLookup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Add a new listener to this load balancer.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener addListener(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerProps props) {
        return software.amazon.jsii.Kernel.call(this, "addListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a redirection listener to this load balancer.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener addRedirect(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerRedirectConfig props) {
        return software.amazon.jsii.Kernel.call(this, "addRedirect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class), new Object[] { props });
    }

    /**
     * Add a redirection listener to this load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener addRedirect() {
        return software.amazon.jsii.Kernel.call(this, "addRedirect", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class));
    }

    /**
     * Add a security group to this load balancer.
     * <p>
     * @param securityGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecurityGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
        software.amazon.jsii.Kernel.call(this, "addSecurityGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(securityGroup, "securityGroup is required") });
    }

    /**
     * Return the given named metric for this Application Load Balancer.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Application Load Balancer.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * The total number of concurrent TCP connections active from clients to the load balancer and from the load balancer to targets.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricActiveConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricActiveConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The total number of concurrent TCP connections active from clients to the load balancer and from the load balancer to targets.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricActiveConnectionCount() {
        return software.amazon.jsii.Kernel.call(this, "metricActiveConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of TLS connections initiated by the client that did not establish a session with the load balancer.
     * <p>
     * Possible causes include a
     * mismatch of ciphers or protocols.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClientTlsNegotiationErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricClientTlsNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of TLS connections initiated by the client that did not establish a session with the load balancer.
     * <p>
     * Possible causes include a
     * mismatch of ciphers or protocols.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClientTlsNegotiationErrorCount() {
        return software.amazon.jsii.Kernel.call(this, "metricClientTlsNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of load balancer capacity units (LCU) used by your load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedLCUs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricConsumedLCUs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of load balancer capacity units (LCU) used by your load balancer.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedLCUs() {
        return software.amazon.jsii.Kernel.call(this, "metricConsumedLCUs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of user authentications that could not be completed.
     * <p>
     * Because an authenticate action was misconfigured, the load balancer
     * couldn't establish a connection with the IdP, or the load balancer
     * couldn't complete the authentication flow due to an internal error.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthError(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of user authentications that could not be completed.
     * <p>
     * Because an authenticate action was misconfigured, the load balancer
     * couldn't establish a connection with the IdP, or the load balancer
     * couldn't complete the authentication flow due to an internal error.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthError() {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of user authentications that could not be completed because the IdP denied access to the user or an authorization code was used more than once.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthFailure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of user authentications that could not be completed because the IdP denied access to the user or an authorization code was used more than once.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthFailure() {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The time elapsed, in milliseconds, to query the IdP for the ID token and user info.
     * <p>
     * If one or more of these operations fail, this is the time to failure.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The time elapsed, in milliseconds, to query the IdP for the ID token and user info.
     * <p>
     * If one or more of these operations fail, this is the time to failure.
     * <p>
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthLatency() {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of authenticate actions that were successful.
     * <p>
     * This metric is incremented at the end of the authentication workflow,
     * after the load balancer has retrieved the user claims from the IdP.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of authenticate actions that were successful.
     * <p>
     * This metric is incremented at the end of the authentication workflow,
     * after the load balancer has retrieved the user claims from the IdP.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricElbAuthSuccess() {
        return software.amazon.jsii.Kernel.call(this, "metricElbAuthSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of HTTP 3xx/4xx/5xx codes that originate from the load balancer.
     * <p>
     * This does not include any response codes generated by the targets.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param code This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeElb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeElb code, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpCodeElb", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required"), props });
    }

    /**
     * The number of HTTP 3xx/4xx/5xx codes that originate from the load balancer.
     * <p>
     * This does not include any response codes generated by the targets.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param code This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeElb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeElb code) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpCodeElb", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in the load balancer.
     * <p>
     * This does not include any response codes generated by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param code This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpCodeTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required"), props });
    }

    /**
     * The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in the load balancer.
     * <p>
     * This does not include any response codes generated by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param code This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpCodeTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * The number of fixed-response actions that were successful.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpFixedResponseCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpFixedResponseCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of fixed-response actions that were successful.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpFixedResponseCount() {
        return software.amazon.jsii.Kernel.call(this, "metricHttpFixedResponseCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of redirect actions that were successful.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpRedirectCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpRedirectCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of redirect actions that were successful.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpRedirectCount() {
        return software.amazon.jsii.Kernel.call(this, "metricHttpRedirectCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of redirect actions that couldn't be completed because the URL in the response location header is larger than 8K.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpRedirectUrlLimitExceededCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricHttpRedirectUrlLimitExceededCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of redirect actions that couldn't be completed because the URL in the response location header is larger than 8K.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHttpRedirectUrlLimitExceededCount() {
        return software.amazon.jsii.Kernel.call(this, "metricHttpRedirectUrlLimitExceededCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The total number of bytes processed by the load balancer over IPv6.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIpv6ProcessedBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricIpv6ProcessedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The total number of bytes processed by the load balancer over IPv6.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIpv6ProcessedBytes() {
        return software.amazon.jsii.Kernel.call(this, "metricIpv6ProcessedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of IPv6 requests received by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIpv6RequestCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricIpv6RequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of IPv6 requests received by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIpv6RequestCount() {
        return software.amazon.jsii.Kernel.call(this, "metricIpv6RequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The total number of new TCP connections established from clients to the load balancer and from the load balancer to targets.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNewConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricNewConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The total number of new TCP connections established from clients to the load balancer and from the load balancer to targets.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNewConnectionCount() {
        return software.amazon.jsii.Kernel.call(this, "metricNewConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The total number of bytes processed by the load balancer over IPv4 and IPv6.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricProcessedBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricProcessedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The total number of bytes processed by the load balancer over IPv4 and IPv6.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricProcessedBytes() {
        return software.amazon.jsii.Kernel.call(this, "metricProcessedBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of connections that were rejected because the load balancer had reached its maximum number of connections.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRejectedConnectionCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricRejectedConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of connections that were rejected because the load balancer had reached its maximum number of connections.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRejectedConnectionCount() {
        return software.amazon.jsii.Kernel.call(this, "metricRejectedConnectionCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of requests processed over IPv4 and IPv6.
     * <p>
     * This count includes only the requests with a response generated by a target of the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRequestCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricRequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of requests processed over IPv4 and IPv6.
     * <p>
     * This count includes only the requests with a response generated by a target of the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRequestCount() {
        return software.amazon.jsii.Kernel.call(this, "metricRequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of rules processed by the load balancer given a request rate averaged over an hour.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRuleEvaluations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricRuleEvaluations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of rules processed by the load balancer given a request rate averaged over an hour.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricRuleEvaluations() {
        return software.amazon.jsii.Kernel.call(this, "metricRuleEvaluations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of connections that were not successfully established between the load balancer and target.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetConnectionErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricTargetConnectionErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of connections that were not successfully established between the load balancer and target.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetConnectionErrorCount() {
        return software.amazon.jsii.Kernel.call(this, "metricTargetConnectionErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetResponseTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricTargetResponseTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     * <p>
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetResponseTime() {
        return software.amazon.jsii.Kernel.call(this, "metricTargetResponseTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     * <p>
     * Possible causes include a mismatch of ciphers or protocols.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetTLSNegotiationErrorCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricTargetTLSNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     * <p>
     * Possible causes include a mismatch of ciphers or protocols.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTargetTLSNegotiationErrorCount() {
        return software.amazon.jsii.Kernel.call(this, "metricTargetTLSNegotiationErrorCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The network connections associated with this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * A list of listeners that have been added to the load balancer.
     * <p>
     * This list is only valid for owned constructs.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener> getListeners() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "listeners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class))));
    }

    /**
     * The IP Address Type for this load balancer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType() {
        return software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps.Builder();
        }

        /**
         * The VPC network to place the load balancer in.
         * <p>
         * @return {@code this}
         * @param vpc The VPC network to place the load balancer in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Indicates whether deletion protection is enabled.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param deletionProtection Indicates whether deletion protection is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * Whether the load balancer has an internet-routable address.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param internetFacing Whether the load balancer has an internet-routable address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetFacing(final java.lang.Boolean internetFacing) {
            this.props.internetFacing(internetFacing);
            return this;
        }

        /**
         * Name of the load balancer.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param loadBalancerName Name of the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(final java.lang.String loadBalancerName) {
            this.props.loadBalancerName(loadBalancerName);
            return this;
        }

        /**
         * Which subnets place the load balancer in.
         * <p>
         * Default: - the Vpc default strategy.
         * <p>
         * @return {@code this}
         * @param vpcSubnets Which subnets place the load balancer in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * Indicates whether HTTP/2 is enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param http2Enabled Indicates whether HTTP/2 is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder http2Enabled(final java.lang.Boolean http2Enabled) {
            this.props.http2Enabled(http2Enabled);
            return this;
        }

        /**
         * The load balancer idle timeout, in seconds.
         * <p>
         * Default: 60
         * <p>
         * @return {@code this}
         * @param idleTimeout The load balancer idle timeout, in seconds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleTimeout(final software.amazon.awscdk.core.Duration idleTimeout) {
            this.props.idleTimeout(idleTimeout);
            return this;
        }

        /**
         * The type of IP addresses to use.
         * <p>
         * Only applies to application load balancers.
         * <p>
         * Default: IpAddressType.Ipv4
         * <p>
         * @return {@code this}
         * @param ipAddressType The type of IP addresses to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType ipAddressType) {
            this.props.ipAddressType(ipAddressType);
            return this;
        }

        /**
         * Security group to associate with this load balancer.
         * <p>
         * Default: A security group is created
         * <p>
         * @return {@code this}
         * @param securityGroup Security group to associate with this load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
