/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.elasticloadbalancingv2.;
import software.amazon.awscdk.services.elasticloadbalancingv2.AddNetworkTargetsProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.Protocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticloadbalancingv2.NetworkListener")
public class NetworkListener
extends BaseListener
implements INetworkListener {
    protected NetworkListener(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkListener(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public NetworkListener(Construct scope, String id, NetworkListenerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public static INetworkListener fromNetworkListenerArn(Construct scope, String id, String networkListenerArn) {
        return (INetworkListener)JsiiObject.jsiiStaticCall(NetworkListener.class, (String)"fromNetworkListenerArn", INetworkListener.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(networkListenerArn, "networkListenerArn is required")});
    }

    public void addTargetGroups(String _id, INetworkTargetGroup ... targetGroups) {
        this.jsiiCall("addTargetGroups", Void.class, Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(_id, "_id is required")}), Arrays.stream(targetGroups)).toArray(Object[]::new));
    }

    public NetworkTargetGroup addTargets(String id, AddNetworkTargetsProps props) {
        return (NetworkTargetGroup)this.jsiiCall("addTargets", NetworkTargetGroup.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final NetworkListenerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new NetworkListenerProps.Builder();
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder certificates(List<IListenerCertificate> certificates) {
            this.props.certificates(certificates);
            return this;
        }

        public Builder defaultTargetGroups(List<INetworkTargetGroup> defaultTargetGroups) {
            this.props.defaultTargetGroups(defaultTargetGroups);
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        public Builder sslPolicy(SslPolicy sslPolicy) {
            this.props.sslPolicy(sslPolicy);
            return this;
        }

        public Builder loadBalancer(INetworkLoadBalancer loadBalancer) {
            this.props.loadBalancer(loadBalancer);
            return this;
        }

        public NetworkListener build() {
            return new NetworkListener(this.scope, this.id, this.props.build());
        }
    }
}

