/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.List;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.elasticloadbalancingv2.$Module;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-elasticloadbalancingv2.NetworkTargetGroupProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface NetworkTargetGroupProps
extends JsiiSerializable,
BaseTargetGroupProps {
    public Number getPort();

    default public Boolean getProxyProtocolV2() {
        return null;
    }

    default public List<INetworkLoadBalancerTarget> getTargets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number port;
        private Boolean proxyProtocolV2;
        private List<INetworkLoadBalancerTarget> targets;
        private Duration deregistrationDelay;
        private HealthCheck healthCheck;
        private String targetGroupName;
        private TargetType targetType;
        private IVpc vpc;

        public Builder port(Number port) {
            this.port = port;
            return this;
        }

        public Builder proxyProtocolV2(Boolean proxyProtocolV2) {
            this.proxyProtocolV2 = proxyProtocolV2;
            return this;
        }

        public Builder targets(List<INetworkLoadBalancerTarget> targets) {
            this.targets = targets;
            return this;
        }

        public Builder deregistrationDelay(Duration deregistrationDelay) {
            this.deregistrationDelay = deregistrationDelay;
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public Builder targetType(TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public NetworkTargetGroupProps build() {
            return new Jsii.Proxy(this.port, this.proxyProtocolV2, this.targets, this.deregistrationDelay, this.healthCheck, this.targetGroupName, this.targetType, this.vpc, null);
        }
    }
}

