package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining an Application Target Group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-02-19T09:09:39.915Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationTargetGroupProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationTargetGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationTargetGroupProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps {

    /**
     * The port on which the listener listens for requests.
     * <p>
     * Default: - Determined from protocol if known, optional for Lambda targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Number getPort() {
        return null;
    }

    /**
     * The protocol to use.
     * <p>
     * Default: - Determined from port if known, optional for Lambda targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
        return null;
    }

    /**
     * The time period during which the load balancer sends a newly registered target a linearly increasing share of the traffic to the target group.
     * <p>
     * The range is 30-900 seconds (15 minutes).
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.core.Duration getSlowStart() {
        return null;
    }

    /**
     * The stickiness cookie expiration period.
     * <p>
     * Setting this value enables load balancer stickiness.
     * <p>
     * After this period, the cookie is considered stale. The minimum value is
     * 1 second and the maximum value is 7 days (604800 seconds).
     * <p>
     * Default: Duration.days(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.core.Duration getStickinessCookieDuration() {
        return null;
    }

    /**
     * The targets to add to this target group.
     * <p>
     * Can be <code>Instance</code>, <code>IPAddress</code>, or any self-registering load balancing
     * target. If you use either <code>Instance</code> or <code>IPAddress</code> as targets, all
     * target must be of the same type.
     * <p>
     * Default: - No targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> getTargets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Number port;
        private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol;
        private software.amazon.awscdk.core.Duration slowStart;
        private software.amazon.awscdk.core.Duration stickinessCookieDuration;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> targets;
        private software.amazon.awscdk.core.Duration deregistrationDelay;
        private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck;
        private java.lang.String targetGroupName;
        private software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link ApplicationTargetGroupProps#getPort}
         * @param port The port on which the listener listens for requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationTargetGroupProps#getProtocol}
         * @param protocol The protocol to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationTargetGroupProps#getSlowStart}
         * @param slowStart The time period during which the load balancer sends a newly registered target a linearly increasing share of the traffic to the target group.
         *                  The range is 30-900 seconds (15 minutes).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slowStart(software.amazon.awscdk.core.Duration slowStart) {
            this.slowStart = slowStart;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationTargetGroupProps#getStickinessCookieDuration}
         * @param stickinessCookieDuration The stickiness cookie expiration period.
         *                                 Setting this value enables load balancer stickiness.
         *                                 <p>
         *                                 After this period, the cookie is considered stale. The minimum value is
         *                                 1 second and the maximum value is 7 days (604800 seconds).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stickinessCookieDuration(software.amazon.awscdk.core.Duration stickinessCookieDuration) {
            this.stickinessCookieDuration = stickinessCookieDuration;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationTargetGroupProps#getTargets}
         * @param targets The targets to add to this target group.
         *                Can be <code>Instance</code>, <code>IPAddress</code>, or any self-registering load balancing
         *                target. If you use either <code>Instance</code> or <code>IPAddress</code> as targets, all
         *                target must be of the same type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationTargetGroupProps#getDeregistrationDelay}
         * @param deregistrationDelay The amount of time for Elastic Load Balancing to wait before deregistering a target.
         *                            The range is 0-3600 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deregistrationDelay(software.amazon.awscdk.core.Duration deregistrationDelay) {
            this.deregistrationDelay = deregistrationDelay;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationTargetGroupProps#getHealthCheck}
         * @param healthCheck Health check configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationTargetGroupProps#getTargetGroupName}
         * @param targetGroupName The name of the target group.
         *                        This name must be unique per region per account, can have a maximum of
         *                        32 characters, must contain only alphanumeric characters or hyphens, and
         *                        must not begin or end with a hyphen.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupName(java.lang.String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationTargetGroupProps#getTargetType}
         * @param targetType The type of targets registered to this TargetGroup, either IP or Instance.
         *                   All targets registered into the group must be of this type. If you
         *                   register targets to the TargetGroup in the CDK app, the TargetType is
         *                   determined automatically.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationTargetGroupProps#getVpc}
         * @param vpc The virtual private cloud (VPC).
         *            only if <code>TargetType</code> is <code>Ip</code> or <code>InstanceId</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationTargetGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationTargetGroupProps build() {
            return new Jsii$Proxy(port, protocol, slowStart, stickinessCookieDuration, targets, deregistrationDelay, healthCheck, targetGroupName, targetType, vpc);
        }
    }

    /**
     * An implementation for {@link ApplicationTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationTargetGroupProps {
        private final java.lang.Number port;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol;
        private final software.amazon.awscdk.core.Duration slowStart;
        private final software.amazon.awscdk.core.Duration stickinessCookieDuration;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> targets;
        private final software.amazon.awscdk.core.Duration deregistrationDelay;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck;
        private final java.lang.String targetGroupName;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.port = this.jsiiGet("port", java.lang.Number.class);
            this.protocol = this.jsiiGet("protocol", software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class);
            this.slowStart = this.jsiiGet("slowStart", software.amazon.awscdk.core.Duration.class);
            this.stickinessCookieDuration = this.jsiiGet("stickinessCookieDuration", software.amazon.awscdk.core.Duration.class);
            this.targets = this.jsiiGet("targets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget.class)));
            this.deregistrationDelay = this.jsiiGet("deregistrationDelay", software.amazon.awscdk.core.Duration.class);
            this.healthCheck = this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
            this.targetGroupName = this.jsiiGet("targetGroupName", java.lang.String.class);
            this.targetType = this.jsiiGet("targetType", software.amazon.awscdk.services.elasticloadbalancingv2.TargetType.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number port, final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol, final software.amazon.awscdk.core.Duration slowStart, final software.amazon.awscdk.core.Duration stickinessCookieDuration, final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> targets, final software.amazon.awscdk.core.Duration deregistrationDelay, final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck, final java.lang.String targetGroupName, final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.port = port;
            this.protocol = protocol;
            this.slowStart = slowStart;
            this.stickinessCookieDuration = stickinessCookieDuration;
            this.targets = targets;
            this.deregistrationDelay = deregistrationDelay;
            this.healthCheck = healthCheck;
            this.targetGroupName = targetGroupName;
            this.targetType = targetType;
            this.vpc = vpc;
        }

        @Override
        public java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public software.amazon.awscdk.core.Duration getSlowStart() {
            return this.slowStart;
        }

        @Override
        public software.amazon.awscdk.core.Duration getStickinessCookieDuration() {
            return this.stickinessCookieDuration;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> getTargets() {
            return this.targets;
        }

        @Override
        public software.amazon.awscdk.core.Duration getDeregistrationDelay() {
            return this.deregistrationDelay;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public java.lang.String getTargetGroupName() {
            return this.targetGroupName;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
            return this.targetType;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getSlowStart() != null) {
                data.set("slowStart", om.valueToTree(this.getSlowStart()));
            }
            if (this.getStickinessCookieDuration() != null) {
                data.set("stickinessCookieDuration", om.valueToTree(this.getStickinessCookieDuration()));
            }
            if (this.getTargets() != null) {
                data.set("targets", om.valueToTree(this.getTargets()));
            }
            if (this.getDeregistrationDelay() != null) {
                data.set("deregistrationDelay", om.valueToTree(this.getDeregistrationDelay()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getTargetGroupName() != null) {
                data.set("targetGroupName", om.valueToTree(this.getTargetGroupName()));
            }
            if (this.getTargetType() != null) {
                data.set("targetType", om.valueToTree(this.getTargetType()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.ApplicationTargetGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationTargetGroupProps.Jsii$Proxy that = (ApplicationTargetGroupProps.Jsii$Proxy) o;

            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            if (this.slowStart != null ? !this.slowStart.equals(that.slowStart) : that.slowStart != null) return false;
            if (this.stickinessCookieDuration != null ? !this.stickinessCookieDuration.equals(that.stickinessCookieDuration) : that.stickinessCookieDuration != null) return false;
            if (this.targets != null ? !this.targets.equals(that.targets) : that.targets != null) return false;
            if (this.deregistrationDelay != null ? !this.deregistrationDelay.equals(that.deregistrationDelay) : that.deregistrationDelay != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.targetGroupName != null ? !this.targetGroupName.equals(that.targetGroupName) : that.targetGroupName != null) return false;
            if (this.targetType != null ? !this.targetType.equals(that.targetType) : that.targetType != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public int hashCode() {
            int result = this.port != null ? this.port.hashCode() : 0;
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.slowStart != null ? this.slowStart.hashCode() : 0);
            result = 31 * result + (this.stickinessCookieDuration != null ? this.stickinessCookieDuration.hashCode() : 0);
            result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
            result = 31 * result + (this.deregistrationDelay != null ? this.deregistrationDelay.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.targetGroupName != null ? this.targetGroupName.hashCode() : 0);
            result = 31 * result + (this.targetType != null ? this.targetType.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
