package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::ListenerRule`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-02-26T08:38:50.423Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListenerRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnListenerRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnListenerRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getActions();

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getConditions();

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.ListenerArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-listenerarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getListenerArn();

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Priority`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-priority
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getPriority();

    /**
     * @return a {@link Builder} of {@link CfnListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.Object actions;
        private java.lang.Object conditions;
        private java.lang.String listenerArn;
        private java.lang.Number priority;

        /**
         * Sets the value of {@link CfnListenerRuleProps#getActions}
         * @param actions `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder actions(software.amazon.awscdk.core.IResolvable actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getActions}
         * @param actions `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder actions(java.util.List<java.lang.Object> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getConditions}
         * @param conditions `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder conditions(software.amazon.awscdk.core.IResolvable conditions) {
            this.conditions = conditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getConditions}
         * @param conditions `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder conditions(java.util.List<java.lang.Object> conditions) {
            this.conditions = conditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getListenerArn}
         * @param listenerArn `AWS::ElasticLoadBalancingV2::ListenerRule.ListenerArn`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder listenerArn(java.lang.String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnListenerRuleProps#getPriority}
         * @param priority `AWS::ElasticLoadBalancingV2::ListenerRule.Priority`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnListenerRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnListenerRuleProps build() {
            return new Jsii$Proxy(actions, conditions, listenerArn, priority);
        }
    }

    /**
     * An implementation for {@link CfnListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnListenerRuleProps {
        private final java.lang.Object actions;
        private final java.lang.Object conditions;
        private final java.lang.String listenerArn;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actions = this.jsiiGet("actions", java.lang.Object.class);
            this.conditions = this.jsiiGet("conditions", java.lang.Object.class);
            this.listenerArn = this.jsiiGet("listenerArn", java.lang.String.class);
            this.priority = this.jsiiGet("priority", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Object actions, final java.lang.Object conditions, final java.lang.String listenerArn, final java.lang.Number priority) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actions = java.util.Objects.requireNonNull(actions, "actions is required");
            this.conditions = java.util.Objects.requireNonNull(conditions, "conditions is required");
            this.listenerArn = java.util.Objects.requireNonNull(listenerArn, "listenerArn is required");
            this.priority = java.util.Objects.requireNonNull(priority, "priority is required");
        }

        @Override
        public java.lang.Object getActions() {
            return this.actions;
        }

        @Override
        public java.lang.Object getConditions() {
            return this.conditions;
        }

        @Override
        public java.lang.String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actions", om.valueToTree(this.getActions()));
            data.set("conditions", om.valueToTree(this.getConditions()));
            data.set("listenerArn", om.valueToTree(this.getListenerArn()));
            data.set("priority", om.valueToTree(this.getPriority()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnListenerRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnListenerRuleProps.Jsii$Proxy that = (CfnListenerRuleProps.Jsii$Proxy) o;

            if (!actions.equals(that.actions)) return false;
            if (!conditions.equals(that.conditions)) return false;
            if (!listenerArn.equals(that.listenerArn)) return false;
            return this.priority.equals(that.priority);
        }

        @Override
        public int hashCode() {
            int result = this.actions.hashCode();
            result = 31 * result + (this.conditions.hashCode());
            result = 31 * result + (this.listenerArn.hashCode());
            result = 31 * result + (this.priority.hashCode());
            return result;
        }
    }
}
