package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding a set of certificates to a listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-03-03T11:43:18.313Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationListenerCertificateProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationListenerCertificateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationListenerCertificateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The listener to attach the rule to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener();

    /**
     * ARNs of certificates to attach.
     * <p>
     * Duplicates are not allowed.
     * <p>
     * Default: - One of 'certificates' and 'certificateArns' is required.
     * <p>
     * @deprecated Use `certificates` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default java.util.List<java.lang.String> getCertificateArns() {
        return null;
    }

    /**
     * Certificates to attach.
     * <p>
     * Duplicates are not allowed.
     * <p>
     * Default: - One of 'certificates' and 'certificateArns' is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> getCertificates() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationListenerCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationListenerCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener;
        private java.util.List<java.lang.String> certificateArns;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates;

        /**
         * Sets the value of {@link ApplicationListenerCertificateProps#getListener}
         * @param listener The listener to attach the rule to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listener(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener) {
            this.listener = listener;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerCertificateProps#getCertificateArns}
         * @param certificateArns ARNs of certificates to attach.
         *                        Duplicates are not allowed.
         * @return {@code this}
         * @deprecated Use `certificates` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder certificateArns(java.util.List<java.lang.String> certificateArns) {
            this.certificateArns = certificateArns;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerCertificateProps#getCertificates}
         * @param certificates Certificates to attach.
         *                     Duplicates are not allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificates(java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates) {
            this.certificates = certificates;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationListenerCertificateProps build() {
            return new Jsii$Proxy(listener, certificateArns, certificates);
        }
    }

    /**
     * An implementation for {@link ApplicationListenerCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationListenerCertificateProps {
        private final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener;
        private final java.util.List<java.lang.String> certificateArns;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.listener = this.jsiiGet("listener", software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener.class);
            this.certificateArns = this.jsiiGet("certificateArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.certificates = this.jsiiGet("certificates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener, final java.util.List<java.lang.String> certificateArns, final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listener = java.util.Objects.requireNonNull(listener, "listener is required");
            this.certificateArns = certificateArns;
            this.certificates = certificates;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener() {
            return this.listener;
        }

        @Override
        public java.util.List<java.lang.String> getCertificateArns() {
            return this.certificateArns;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> getCertificates() {
            return this.certificates;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("listener", om.valueToTree(this.getListener()));
            if (this.getCertificateArns() != null) {
                data.set("certificateArns", om.valueToTree(this.getCertificateArns()));
            }
            if (this.getCertificates() != null) {
                data.set("certificates", om.valueToTree(this.getCertificates()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.ApplicationListenerCertificateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationListenerCertificateProps.Jsii$Proxy that = (ApplicationListenerCertificateProps.Jsii$Proxy) o;

            if (!listener.equals(that.listener)) return false;
            if (this.certificateArns != null ? !this.certificateArns.equals(that.certificateArns) : that.certificateArns != null) return false;
            return this.certificates != null ? this.certificates.equals(that.certificates) : that.certificates == null;
        }

        @Override
        public int hashCode() {
            int result = this.listener.hashCode();
            result = 31 * result + (this.certificateArns != null ? this.certificateArns.hashCode() : 0);
            result = 31 * result + (this.certificates != null ? this.certificates.hashCode() : 0);
            return result;
        }
    }
}
