package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding a conditional load balancing rule.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.1.0 (build df55f5e)", date = "2020-03-24T17:01:39.368Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.AddRuleProps")
@software.amazon.jsii.Jsii.Proxy(AddRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Rule applies if the requested host matches the indicated host.
     * <p>
     * May contain up to three '*' wildcards.
     * <p>
     * Requires that priority is set.
     * <p>
     * Default: No host condition
     * <p>
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostHeader() {
        return null;
    }

    /**
     * Rule applies if the requested path matches the given path pattern.
     * <p>
     * May contain up to three '*' wildcards.
     * <p>
     * Requires that priority is set.
     * <p>
     * Default: No path condition
     * <p>
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     * @deprecated Use `pathPatterns` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getPathPattern() {
        return null;
    }

    /**
     * Rule applies if the requested path matches any of the given patterns.
     * <p>
     * May contain up to three '*' wildcards.
     * <p>
     * Requires that priority is set.
     * <p>
     * Default: - No path condition.
     * <p>
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPathPatterns() {
        return null;
    }

    /**
     * Priority of this target group.
     * <p>
     * The rule with the lowest priority will be used for every request.
     * If priority is not given, these target groups will be added as
     * defaults, and must not have conditions.
     * <p>
     * Priorities must be unique.
     * <p>
     * Default: Target groups are used as defaults
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String hostHeader;
        private java.lang.String pathPattern;
        private java.util.List<java.lang.String> pathPatterns;
        private java.lang.Number priority;

        /**
         * Sets the value of {@link AddRuleProps#getHostHeader}
         * @param hostHeader Rule applies if the requested host matches the indicated host.
         *                   May contain up to three '*' wildcards.
         *                   <p>
         *                   Requires that priority is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostHeader(java.lang.String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        /**
         * Sets the value of {@link AddRuleProps#getPathPattern}
         * @param pathPattern Rule applies if the requested path matches the given path pattern.
         *                    May contain up to three '*' wildcards.
         *                    <p>
         *                    Requires that priority is set.
         * @return {@code this}
         * @deprecated Use `pathPatterns` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pathPattern(java.lang.String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        /**
         * Sets the value of {@link AddRuleProps#getPathPatterns}
         * @param pathPatterns Rule applies if the requested path matches any of the given patterns.
         *                     May contain up to three '*' wildcards.
         *                     <p>
         *                     Requires that priority is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathPatterns(java.util.List<java.lang.String> pathPatterns) {
            this.pathPatterns = pathPatterns;
            return this;
        }

        /**
         * Sets the value of {@link AddRuleProps#getPriority}
         * @param priority Priority of this target group.
         *                 The rule with the lowest priority will be used for every request.
         *                 If priority is not given, these target groups will be added as
         *                 defaults, and must not have conditions.
         *                 <p>
         *                 Priorities must be unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AddRuleProps build() {
            return new Jsii$Proxy(hostHeader, pathPattern, pathPatterns, priority);
        }
    }

    /**
     * An implementation for {@link AddRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddRuleProps {
        private final java.lang.String hostHeader;
        private final java.lang.String pathPattern;
        private final java.util.List<java.lang.String> pathPatterns;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostHeader = this.jsiiGet("hostHeader", java.lang.String.class);
            this.pathPattern = this.jsiiGet("pathPattern", java.lang.String.class);
            this.pathPatterns = this.jsiiGet("pathPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.priority = this.jsiiGet("priority", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String hostHeader, final java.lang.String pathPattern, final java.util.List<java.lang.String> pathPatterns, final java.lang.Number priority) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostHeader = hostHeader;
            this.pathPattern = pathPattern;
            this.pathPatterns = pathPatterns;
            this.priority = priority;
        }

        @Override
        public java.lang.String getHostHeader() {
            return this.hostHeader;
        }

        @Override
        public java.lang.String getPathPattern() {
            return this.pathPattern;
        }

        @Override
        public java.util.List<java.lang.String> getPathPatterns() {
            return this.pathPatterns;
        }

        @Override
        public java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHostHeader() != null) {
                data.set("hostHeader", om.valueToTree(this.getHostHeader()));
            }
            if (this.getPathPattern() != null) {
                data.set("pathPattern", om.valueToTree(this.getPathPattern()));
            }
            if (this.getPathPatterns() != null) {
                data.set("pathPatterns", om.valueToTree(this.getPathPatterns()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.AddRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddRuleProps.Jsii$Proxy that = (AddRuleProps.Jsii$Proxy) o;

            if (this.hostHeader != null ? !this.hostHeader.equals(that.hostHeader) : that.hostHeader != null) return false;
            if (this.pathPattern != null ? !this.pathPattern.equals(that.pathPattern) : that.pathPattern != null) return false;
            if (this.pathPatterns != null ? !this.pathPatterns.equals(that.pathPatterns) : that.pathPatterns != null) return false;
            return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
        }

        @Override
        public int hashCode() {
            int result = this.hostHeader != null ? this.hostHeader.hashCode() : 0;
            result = 31 * result + (this.pathPattern != null ? this.pathPattern.hashCode() : 0);
            result = 31 * result + (this.pathPatterns != null ? this.pathPatterns.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }
    }
}
