package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define a Network Listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-29T22:50:02.089Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.NetworkListener")
public class NetworkListener extends software.amazon.awscdk.services.elasticloadbalancingv2.BaseListener implements software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener {

    protected NetworkListener(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkListener(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NetworkListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing listener.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param networkListenerArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener fromNetworkListenerArn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String networkListenerArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener.class, "fromNetworkListenerArn", software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(networkListenerArn, "networkListenerArn is required") });
    }

    /**
     * Load balance incoming requests to the given target groups.
     * <p>
     * @param _id This parameter is required.
     * @param targetGroups This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addTargetGroups(final @org.jetbrains.annotations.NotNull java.lang.String _id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup... targetGroups) {
        this.jsiiCall("addTargetGroups", software.amazon.jsii.NativeType.VOID, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(_id, "_id is required") }), java.util.Arrays.<Object>stream(targetGroups)).toArray(Object[]::new));
    }

    /**
     * Load balance incoming requests to the given load balancing targets.
     * <p>
     * This method implicitly creates an ApplicationTargetGroup for the targets
     * involved.
     * <p>
     * @return The newly created target group
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup addTargets(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.AddNetworkTargetsProps props) {
        return this.jsiiCall("addTargets", software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerProps.Builder();
        }

        /**
         * The port on which the listener listens for requests.
         * <p>
         * @return {@code this}
         * @param port The port on which the listener listens for requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * Certificate list of ACM cert ARNs.
         * <p>
         * Default: - No certificates.
         * <p>
         * @return {@code this}
         * @param certificates Certificate list of ACM cert ARNs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificates(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates) {
            this.props.certificates(certificates);
            return this;
        }

        /**
         * Default target groups to load balance to.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param defaultTargetGroups Default target groups to load balance to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultTargetGroups(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> defaultTargetGroups) {
            this.props.defaultTargetGroups(defaultTargetGroups);
            return this;
        }

        /**
         * Protocol for listener, expects TCP or TLS.
         * <p>
         * Default: - TLS if certificates are provided. TCP otherwise.
         * <p>
         * @return {@code this}
         * @param protocol Protocol for listener, expects TCP or TLS. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * SSL Policy.
         * <p>
         * Default: - Current predefined security policy.
         * <p>
         * @return {@code this}
         * @param sslPolicy SSL Policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslPolicy(final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            this.props.sslPolicy(sslPolicy);
            return this;
        }

        /**
         * The load balancer to attach this listener to.
         * <p>
         * @return {@code this}
         * @param loadBalancer The load balancer to attach this listener to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancer(final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer) {
            this.props.loadBalancer(loadBalancer);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
