package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:23:50.763Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationListenerAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * ARN of the listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getListenerArn();
    /**
     * Security group ID of the load balancer this listener is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getSecurityGroupId();
    /**
     * The default port on which this listener is listening.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getDefaultPort();

    /**
     * @return a {@link Builder} of {@link ApplicationListenerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationListenerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String _listenerArn;
        private java.lang.String _securityGroupId;
        @javax.annotation.Nullable
        private java.lang.Number _defaultPort;

        /**
         * Sets the value of ListenerArn
         * @param value ARN of the listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withListenerArn(final java.lang.String value) {
            this._listenerArn = java.util.Objects.requireNonNull(value, "listenerArn is required");
            return this;
        }
        /**
         * Sets the value of SecurityGroupId
         * @param value Security group ID of the load balancer this listener is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSecurityGroupId(final java.lang.String value) {
            this._securityGroupId = java.util.Objects.requireNonNull(value, "securityGroupId is required");
            return this;
        }
        /**
         * Sets the value of DefaultPort
         * @param value The default port on which this listener is listening.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDefaultPort(@javax.annotation.Nullable final java.lang.Number value) {
            this._defaultPort = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationListenerAttributes build() {
            return new ApplicationListenerAttributes() {
                private final java.lang.String $listenerArn = java.util.Objects.requireNonNull(_listenerArn, "listenerArn is required");
                private final java.lang.String $securityGroupId = java.util.Objects.requireNonNull(_securityGroupId, "securityGroupId is required");
                @javax.annotation.Nullable
                private final java.lang.Number $defaultPort = _defaultPort;

                @Override
                public java.lang.String getListenerArn() {
                    return this.$listenerArn;
                }

                @Override
                public java.lang.String getSecurityGroupId() {
                    return this.$securityGroupId;
                }

                @Override
                public java.lang.Number getDefaultPort() {
                    return this.$defaultPort;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("listenerArn", om.valueToTree(this.getListenerArn()));
                    obj.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));
                    if (this.getDefaultPort() != null) {
                        obj.set("defaultPort", om.valueToTree(this.getDefaultPort()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerAttributes {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * ARN of the listener.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getListenerArn() {
            return this.jsiiGet("listenerArn", java.lang.String.class);
        }

        /**
         * Security group ID of the load balancer this listener is associated with.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getSecurityGroupId() {
            return this.jsiiGet("securityGroupId", java.lang.String.class);
        }

        /**
         * The default port on which this listener is listening.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getDefaultPort() {
            return this.jsiiGet("defaultPort", java.lang.Number.class);
        }
    }
}
