/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancerProps;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface NetworkLoadBalancerProps
extends JsiiSerializable,
BaseLoadBalancerProps {
    public Boolean getCrossZoneEnabled();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Boolean _crossZoneEnabled;
        private IVpc _vpc;
        @Nullable
        private Boolean _deletionProtection;
        @Nullable
        private Boolean _internetFacing;
        @Nullable
        private String _loadBalancerName;
        @Nullable
        private SubnetSelection _vpcSubnets;

        public Builder withCrossZoneEnabled(@Nullable Boolean value) {
            this._crossZoneEnabled = value;
            return this;
        }

        public Builder withVpc(IVpc value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withDeletionProtection(@Nullable Boolean value) {
            this._deletionProtection = value;
            return this;
        }

        public Builder withInternetFacing(@Nullable Boolean value) {
            this._internetFacing = value;
            return this;
        }

        public Builder withLoadBalancerName(@Nullable String value) {
            this._loadBalancerName = value;
            return this;
        }

        public Builder withVpcSubnets(@Nullable SubnetSelection value) {
            this._vpcSubnets = value;
            return this;
        }

        public NetworkLoadBalancerProps build() {
            return new NetworkLoadBalancerProps(){
                @Nullable
                private final Boolean $crossZoneEnabled;
                private final IVpc $vpc;
                @Nullable
                private final Boolean $deletionProtection;
                @Nullable
                private final Boolean $internetFacing;
                @Nullable
                private final String $loadBalancerName;
                @Nullable
                private final SubnetSelection $vpcSubnets;
                {
                    this.$crossZoneEnabled = _crossZoneEnabled;
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$deletionProtection = _deletionProtection;
                    this.$internetFacing = _internetFacing;
                    this.$loadBalancerName = _loadBalancerName;
                    this.$vpcSubnets = _vpcSubnets;
                }

                @Override
                public Boolean getCrossZoneEnabled() {
                    return this.$crossZoneEnabled;
                }

                @Override
                public IVpc getVpc() {
                    return this.$vpc;
                }

                @Override
                public Boolean getDeletionProtection() {
                    return this.$deletionProtection;
                }

                @Override
                public Boolean getInternetFacing() {
                    return this.$internetFacing;
                }

                @Override
                public String getLoadBalancerName() {
                    return this.$loadBalancerName;
                }

                @Override
                public SubnetSelection getVpcSubnets() {
                    return this.$vpcSubnets;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    if (this.getCrossZoneEnabled() != null) {
                        obj.set("crossZoneEnabled", om.valueToTree((Object)this.getCrossZoneEnabled()));
                    }
                    obj.set("vpc", om.valueToTree((Object)this.getVpc()));
                    if (this.getDeletionProtection() != null) {
                        obj.set("deletionProtection", om.valueToTree((Object)this.getDeletionProtection()));
                    }
                    if (this.getInternetFacing() != null) {
                        obj.set("internetFacing", om.valueToTree((Object)this.getInternetFacing()));
                    }
                    if (this.getLoadBalancerName() != null) {
                        obj.set("loadBalancerName", om.valueToTree((Object)this.getLoadBalancerName()));
                    }
                    if (this.getVpcSubnets() != null) {
                        obj.set("vpcSubnets", om.valueToTree((Object)this.getVpcSubnets()));
                    }
                    return obj;
                }
            };
        }
    }
}

