package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * What to do when a client makes a request to a listener.
 * <p>
 * Some actions can be combined with other ones (specifically,
 * you can perform authentication before serving the request).
 * <p>
 * Multiple actions form a linked chain; the chain must always terminate in a
 * <em>(weighted)forward</em>, <em>fixedResponse</em> or <em>redirect</em> action.
 * <p>
 * If an action supports chaining, the next action can be indicated
 * by passing it in the <code>next</code> property.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-20T13:23:26.500Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.NetworkListenerAction")
public class NetworkListenerAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.IListenerAction {

    protected NetworkListenerAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkListenerAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create an instance of NetworkListenerAction.
     * <p>
     * The default class should be good enough for most cases and
     * should be created by using one of the static factory functions,
     * but allow overriding to make sure we allow flexibility for the future.
     * <p>
     * @param actionJson This parameter is required.
     * @param next
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected NetworkListenerAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty actionJson, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction next) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(actionJson, "actionJson is required"), next });
    }

    /**
     * Create an instance of NetworkListenerAction.
     * <p>
     * The default class should be good enough for most cases and
     * should be created by using one of the static factory functions,
     * but allow overriding to make sure we allow flexibility for the future.
     * <p>
     * @param actionJson This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected NetworkListenerAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty actionJson) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(actionJson, "actionJson is required") });
    }

    /**
     * Forward to one or more Target Groups.
     * <p>
     * @param targetGroups This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction forward(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> targetGroups, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.NetworkForwardOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class, "forward", software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class, new Object[] { java.util.Objects.requireNonNull(targetGroups, "targetGroups is required"), options });
    }

    /**
     * Forward to one or more Target Groups.
     * <p>
     * @param targetGroups This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction forward(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> targetGroups) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class, "forward", software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class, new Object[] { java.util.Objects.requireNonNull(targetGroups, "targetGroups is required") });
    }

    /**
     * Forward to one or more Target Groups which are weighted differently.
     * <p>
     * @param targetGroups This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction weightedForward(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.NetworkWeightedTargetGroup> targetGroups, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.NetworkForwardOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class, "weightedForward", software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class, new Object[] { java.util.Objects.requireNonNull(targetGroups, "targetGroups is required"), options });
    }

    /**
     * Forward to one or more Target Groups which are weighted differently.
     * <p>
     * @param targetGroups This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction weightedForward(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.NetworkWeightedTargetGroup> targetGroups) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class, "weightedForward", software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class, new Object[] { java.util.Objects.requireNonNull(targetGroups, "targetGroups is required") });
    }

    /**
     * Called when the action is being used in a listener.
     * <p>
     * @param scope This parameter is required.
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener listener) {
        this.jsiiCall("bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     * Render the actions in this chain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty> renderActions() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("renderActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty.class))));
    }

    /**
     * Renumber the "order" fields in the actions array.
     * <p>
     * We don't number for 0 or 1 elements, but otherwise number them 1...#actions
     * so ELB knows about the right order.
     * <p>
     * Do this in <code>NetworkListenerAction</code> instead of in <code>Listener</code> so that we give
     * users the opportunity to override by subclassing and overriding <code>renderActions</code>.
     * <p>
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty> renumber(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty> actions) {
        return java.util.Collections.unmodifiableList(this.jsiiCall("renumber", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty.class)), new Object[] { java.util.Objects.requireNonNull(actions, "actions is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction getNext() {
        return this.jsiiGet("next", software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerAction.class);
    }
}
