package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.6.0 (build 248e75b)", date = "2020-06-09T15:22:49.625Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListener")
public class CfnListener extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnListener(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnListener(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ElasticLoadBalancingV2::Listener`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A factory method that creates a new instance of this class from an object containing the CloudFormation properties of this resource.
     * <p>
     * Used in the &#64;aws-cdk/cloudformation-include module.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param resourceAttributes This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener fromCloudFormation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.Object resourceAttributes, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FromCloudFormationOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.class, "fromCloudFormation", software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), resourceAttributes, java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::Listener.DefaultActions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-defaultactions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDefaultActions() {
        return this.jsiiGet("defaultActions", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::Listener.DefaultActions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-defaultactions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultActions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("defaultActions", java.util.Objects.requireNonNull(value, "defaultActions is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::Listener.DefaultActions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-defaultactions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultActions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        this.jsiiSet("defaultActions", java.util.Objects.requireNonNull(value, "defaultActions is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::Listener.LoadBalancerArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-loadbalancerarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerArn() {
        return this.jsiiGet("loadBalancerArn", java.lang.String.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::Listener.LoadBalancerArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-loadbalancerarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBalancerArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("loadBalancerArn", java.util.Objects.requireNonNull(value, "loadBalancerArn is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Port`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-port
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getPort() {
        return this.jsiiGet("port", java.lang.Number.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Port`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-port
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        this.jsiiSet("port", java.util.Objects.requireNonNull(value, "port is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Protocol`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-protocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProtocol() {
        return this.jsiiGet("protocol", java.lang.String.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Protocol`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-protocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocol(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("protocol", java.util.Objects.requireNonNull(value, "protocol is required"));
    }

    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Certificates`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-certificates
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCertificates() {
        return this.jsiiGet("certificates", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Certificates`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-certificates
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificates(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("certificates", value);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Certificates`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-certificates
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificates(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("certificates", value);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::Listener.SslPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-sslpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSslPolicy() {
        return this.jsiiGet("sslPolicy", java.lang.String.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::Listener.SslPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-sslpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSslPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("sslPolicy", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListener.ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListener.ActionProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnListener.ActionProperty.AuthenticateCognitoConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticatecognitoconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticateCognitoConfig() {
            return null;
        }

        /**
         * `CfnListener.ActionProperty.AuthenticateOidcConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticateoidcconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticateOidcConfig() {
            return null;
        }

        /**
         * `CfnListener.ActionProperty.FixedResponseConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-fixedresponseconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFixedResponseConfig() {
            return null;
        }

        /**
         * `CfnListener.ActionProperty.ForwardConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-forwardconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardConfig() {
            return null;
        }

        /**
         * `CfnListener.ActionProperty.Order`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-order
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOrder() {
            return null;
        }

        /**
         * `CfnListener.ActionProperty.RedirectConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-redirectconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedirectConfig() {
            return null;
        }

        /**
         * `CfnListener.ActionProperty.TargetGroupArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetGroupArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionProperty> {
            private java.lang.String type;
            private java.lang.Object authenticateCognitoConfig;
            private java.lang.Object authenticateOidcConfig;
            private java.lang.Object fixedResponseConfig;
            private java.lang.Object forwardConfig;
            private java.lang.Number order;
            private java.lang.Object redirectConfig;
            private java.lang.String targetGroupArn;

            /**
             * Sets the value of {@link ActionProperty#getType}
             * @param type `CfnListener.ActionProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getAuthenticateCognitoConfig}
             * @param authenticateCognitoConfig `CfnListener.ActionProperty.AuthenticateCognitoConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticateCognitoConfig(software.amazon.awscdk.core.IResolvable authenticateCognitoConfig) {
                this.authenticateCognitoConfig = authenticateCognitoConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getAuthenticateCognitoConfig}
             * @param authenticateCognitoConfig `CfnListener.ActionProperty.AuthenticateCognitoConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticateCognitoConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.AuthenticateCognitoConfigProperty authenticateCognitoConfig) {
                this.authenticateCognitoConfig = authenticateCognitoConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getAuthenticateOidcConfig}
             * @param authenticateOidcConfig `CfnListener.ActionProperty.AuthenticateOidcConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticateOidcConfig(software.amazon.awscdk.core.IResolvable authenticateOidcConfig) {
                this.authenticateOidcConfig = authenticateOidcConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getAuthenticateOidcConfig}
             * @param authenticateOidcConfig `CfnListener.ActionProperty.AuthenticateOidcConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticateOidcConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.AuthenticateOidcConfigProperty authenticateOidcConfig) {
                this.authenticateOidcConfig = authenticateOidcConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getFixedResponseConfig}
             * @param fixedResponseConfig `CfnListener.ActionProperty.FixedResponseConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedResponseConfig(software.amazon.awscdk.core.IResolvable fixedResponseConfig) {
                this.fixedResponseConfig = fixedResponseConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getFixedResponseConfig}
             * @param fixedResponseConfig `CfnListener.ActionProperty.FixedResponseConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedResponseConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.FixedResponseConfigProperty fixedResponseConfig) {
                this.fixedResponseConfig = fixedResponseConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getForwardConfig}
             * @param forwardConfig `CfnListener.ActionProperty.ForwardConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardConfig(software.amazon.awscdk.core.IResolvable forwardConfig) {
                this.forwardConfig = forwardConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getForwardConfig}
             * @param forwardConfig `CfnListener.ActionProperty.ForwardConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ForwardConfigProperty forwardConfig) {
                this.forwardConfig = forwardConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getOrder}
             * @param order `CfnListener.ActionProperty.Order`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder order(java.lang.Number order) {
                this.order = order;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getRedirectConfig}
             * @param redirectConfig `CfnListener.ActionProperty.RedirectConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectConfig(software.amazon.awscdk.core.IResolvable redirectConfig) {
                this.redirectConfig = redirectConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getRedirectConfig}
             * @param redirectConfig `CfnListener.ActionProperty.RedirectConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.RedirectConfigProperty redirectConfig) {
                this.redirectConfig = redirectConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getTargetGroupArn}
             * @param targetGroupArn `CfnListener.ActionProperty.TargetGroupArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupArn(java.lang.String targetGroupArn) {
                this.targetGroupArn = targetGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionProperty build() {
                return new Jsii$Proxy(type, authenticateCognitoConfig, authenticateOidcConfig, fixedResponseConfig, forwardConfig, order, redirectConfig, targetGroupArn);
            }
        }

        /**
         * An implementation for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperty {
            private final java.lang.String type;
            private final java.lang.Object authenticateCognitoConfig;
            private final java.lang.Object authenticateOidcConfig;
            private final java.lang.Object fixedResponseConfig;
            private final java.lang.Object forwardConfig;
            private final java.lang.Number order;
            private final java.lang.Object redirectConfig;
            private final java.lang.String targetGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.authenticateCognitoConfig = this.jsiiGet("authenticateCognitoConfig", java.lang.Object.class);
                this.authenticateOidcConfig = this.jsiiGet("authenticateOidcConfig", java.lang.Object.class);
                this.fixedResponseConfig = this.jsiiGet("fixedResponseConfig", java.lang.Object.class);
                this.forwardConfig = this.jsiiGet("forwardConfig", java.lang.Object.class);
                this.order = this.jsiiGet("order", java.lang.Number.class);
                this.redirectConfig = this.jsiiGet("redirectConfig", java.lang.Object.class);
                this.targetGroupArn = this.jsiiGet("targetGroupArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String type, final java.lang.Object authenticateCognitoConfig, final java.lang.Object authenticateOidcConfig, final java.lang.Object fixedResponseConfig, final java.lang.Object forwardConfig, final java.lang.Number order, final java.lang.Object redirectConfig, final java.lang.String targetGroupArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.authenticateCognitoConfig = authenticateCognitoConfig;
                this.authenticateOidcConfig = authenticateOidcConfig;
                this.fixedResponseConfig = fixedResponseConfig;
                this.forwardConfig = forwardConfig;
                this.order = order;
                this.redirectConfig = redirectConfig;
                this.targetGroupArn = targetGroupArn;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.Object getAuthenticateCognitoConfig() {
                return this.authenticateCognitoConfig;
            }

            @Override
            public java.lang.Object getAuthenticateOidcConfig() {
                return this.authenticateOidcConfig;
            }

            @Override
            public java.lang.Object getFixedResponseConfig() {
                return this.fixedResponseConfig;
            }

            @Override
            public java.lang.Object getForwardConfig() {
                return this.forwardConfig;
            }

            @Override
            public java.lang.Number getOrder() {
                return this.order;
            }

            @Override
            public java.lang.Object getRedirectConfig() {
                return this.redirectConfig;
            }

            @Override
            public java.lang.String getTargetGroupArn() {
                return this.targetGroupArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getAuthenticateCognitoConfig() != null) {
                    data.set("authenticateCognitoConfig", om.valueToTree(this.getAuthenticateCognitoConfig()));
                }
                if (this.getAuthenticateOidcConfig() != null) {
                    data.set("authenticateOidcConfig", om.valueToTree(this.getAuthenticateOidcConfig()));
                }
                if (this.getFixedResponseConfig() != null) {
                    data.set("fixedResponseConfig", om.valueToTree(this.getFixedResponseConfig()));
                }
                if (this.getForwardConfig() != null) {
                    data.set("forwardConfig", om.valueToTree(this.getForwardConfig()));
                }
                if (this.getOrder() != null) {
                    data.set("order", om.valueToTree(this.getOrder()));
                }
                if (this.getRedirectConfig() != null) {
                    data.set("redirectConfig", om.valueToTree(this.getRedirectConfig()));
                }
                if (this.getTargetGroupArn() != null) {
                    data.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnListener.ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionProperty.Jsii$Proxy that = (ActionProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.authenticateCognitoConfig != null ? !this.authenticateCognitoConfig.equals(that.authenticateCognitoConfig) : that.authenticateCognitoConfig != null) return false;
                if (this.authenticateOidcConfig != null ? !this.authenticateOidcConfig.equals(that.authenticateOidcConfig) : that.authenticateOidcConfig != null) return false;
                if (this.fixedResponseConfig != null ? !this.fixedResponseConfig.equals(that.fixedResponseConfig) : that.fixedResponseConfig != null) return false;
                if (this.forwardConfig != null ? !this.forwardConfig.equals(that.forwardConfig) : that.forwardConfig != null) return false;
                if (this.order != null ? !this.order.equals(that.order) : that.order != null) return false;
                if (this.redirectConfig != null ? !this.redirectConfig.equals(that.redirectConfig) : that.redirectConfig != null) return false;
                return this.targetGroupArn != null ? this.targetGroupArn.equals(that.targetGroupArn) : that.targetGroupArn == null;
            }

            @Override
            public int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.authenticateCognitoConfig != null ? this.authenticateCognitoConfig.hashCode() : 0);
                result = 31 * result + (this.authenticateOidcConfig != null ? this.authenticateOidcConfig.hashCode() : 0);
                result = 31 * result + (this.fixedResponseConfig != null ? this.fixedResponseConfig.hashCode() : 0);
                result = 31 * result + (this.forwardConfig != null ? this.forwardConfig.hashCode() : 0);
                result = 31 * result + (this.order != null ? this.order.hashCode() : 0);
                result = 31 * result + (this.redirectConfig != null ? this.redirectConfig.hashCode() : 0);
                result = 31 * result + (this.targetGroupArn != null ? this.targetGroupArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListener.AuthenticateCognitoConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthenticateCognitoConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthenticateCognitoConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserPoolArn();

        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolClientId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolclientid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserPoolClientId();

        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolDomain`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpooldomain
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserPoolDomain();

        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-authenticationrequestextraparams
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticationRequestExtraParams() {
            return null;
        }

        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-onunauthenticatedrequest
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnUnauthenticatedRequest() {
            return null;
        }

        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.Scope`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-scope
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
            return null;
        }

        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.SessionCookieName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessioncookiename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSessionCookieName() {
            return null;
        }

        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.SessionTimeout`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessiontimeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSessionTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthenticateCognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthenticateCognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthenticateCognitoConfigProperty> {
            private java.lang.String userPoolArn;
            private java.lang.String userPoolClientId;
            private java.lang.String userPoolDomain;
            private java.lang.Object authenticationRequestExtraParams;
            private java.lang.String onUnauthenticatedRequest;
            private java.lang.String scope;
            private java.lang.String sessionCookieName;
            private java.lang.Number sessionTimeout;

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getUserPoolArn}
             * @param userPoolArn `CfnListener.AuthenticateCognitoConfigProperty.UserPoolArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolArn(java.lang.String userPoolArn) {
                this.userPoolArn = userPoolArn;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getUserPoolClientId}
             * @param userPoolClientId `CfnListener.AuthenticateCognitoConfigProperty.UserPoolClientId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolClientId(java.lang.String userPoolClientId) {
                this.userPoolClientId = userPoolClientId;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getUserPoolDomain}
             * @param userPoolDomain `CfnListener.AuthenticateCognitoConfigProperty.UserPoolDomain`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolDomain(java.lang.String userPoolDomain) {
                this.userPoolDomain = userPoolDomain;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getAuthenticationRequestExtraParams}
             * @param authenticationRequestExtraParams `CfnListener.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationRequestExtraParams(software.amazon.awscdk.core.IResolvable authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getAuthenticationRequestExtraParams}
             * @param authenticationRequestExtraParams `CfnListener.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationRequestExtraParams(java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getOnUnauthenticatedRequest}
             * @param onUnauthenticatedRequest `CfnListener.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onUnauthenticatedRequest(java.lang.String onUnauthenticatedRequest) {
                this.onUnauthenticatedRequest = onUnauthenticatedRequest;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getScope}
             * @param scope `CfnListener.AuthenticateCognitoConfigProperty.Scope`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getSessionCookieName}
             * @param sessionCookieName `CfnListener.AuthenticateCognitoConfigProperty.SessionCookieName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionCookieName(java.lang.String sessionCookieName) {
                this.sessionCookieName = sessionCookieName;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getSessionTimeout}
             * @param sessionTimeout `CfnListener.AuthenticateCognitoConfigProperty.SessionTimeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionTimeout(java.lang.Number sessionTimeout) {
                this.sessionTimeout = sessionTimeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticateCognitoConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthenticateCognitoConfigProperty build() {
                return new Jsii$Proxy(userPoolArn, userPoolClientId, userPoolDomain, authenticationRequestExtraParams, onUnauthenticatedRequest, scope, sessionCookieName, sessionTimeout);
            }
        }

        /**
         * An implementation for {@link AuthenticateCognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticateCognitoConfigProperty {
            private final java.lang.String userPoolArn;
            private final java.lang.String userPoolClientId;
            private final java.lang.String userPoolDomain;
            private final java.lang.Object authenticationRequestExtraParams;
            private final java.lang.String onUnauthenticatedRequest;
            private final java.lang.String scope;
            private final java.lang.String sessionCookieName;
            private final java.lang.Number sessionTimeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.userPoolArn = this.jsiiGet("userPoolArn", java.lang.String.class);
                this.userPoolClientId = this.jsiiGet("userPoolClientId", java.lang.String.class);
                this.userPoolDomain = this.jsiiGet("userPoolDomain", java.lang.String.class);
                this.authenticationRequestExtraParams = this.jsiiGet("authenticationRequestExtraParams", java.lang.Object.class);
                this.onUnauthenticatedRequest = this.jsiiGet("onUnauthenticatedRequest", java.lang.String.class);
                this.scope = this.jsiiGet("scope", java.lang.String.class);
                this.sessionCookieName = this.jsiiGet("sessionCookieName", java.lang.String.class);
                this.sessionTimeout = this.jsiiGet("sessionTimeout", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String userPoolArn, final java.lang.String userPoolClientId, final java.lang.String userPoolDomain, final java.lang.Object authenticationRequestExtraParams, final java.lang.String onUnauthenticatedRequest, final java.lang.String scope, final java.lang.String sessionCookieName, final java.lang.Number sessionTimeout) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.userPoolArn = java.util.Objects.requireNonNull(userPoolArn, "userPoolArn is required");
                this.userPoolClientId = java.util.Objects.requireNonNull(userPoolClientId, "userPoolClientId is required");
                this.userPoolDomain = java.util.Objects.requireNonNull(userPoolDomain, "userPoolDomain is required");
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                this.onUnauthenticatedRequest = onUnauthenticatedRequest;
                this.scope = scope;
                this.sessionCookieName = sessionCookieName;
                this.sessionTimeout = sessionTimeout;
            }

            @Override
            public java.lang.String getUserPoolArn() {
                return this.userPoolArn;
            }

            @Override
            public java.lang.String getUserPoolClientId() {
                return this.userPoolClientId;
            }

            @Override
            public java.lang.String getUserPoolDomain() {
                return this.userPoolDomain;
            }

            @Override
            public java.lang.Object getAuthenticationRequestExtraParams() {
                return this.authenticationRequestExtraParams;
            }

            @Override
            public java.lang.String getOnUnauthenticatedRequest() {
                return this.onUnauthenticatedRequest;
            }

            @Override
            public java.lang.String getScope() {
                return this.scope;
            }

            @Override
            public java.lang.String getSessionCookieName() {
                return this.sessionCookieName;
            }

            @Override
            public java.lang.Number getSessionTimeout() {
                return this.sessionTimeout;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("userPoolArn", om.valueToTree(this.getUserPoolArn()));
                data.set("userPoolClientId", om.valueToTree(this.getUserPoolClientId()));
                data.set("userPoolDomain", om.valueToTree(this.getUserPoolDomain()));
                if (this.getAuthenticationRequestExtraParams() != null) {
                    data.set("authenticationRequestExtraParams", om.valueToTree(this.getAuthenticationRequestExtraParams()));
                }
                if (this.getOnUnauthenticatedRequest() != null) {
                    data.set("onUnauthenticatedRequest", om.valueToTree(this.getOnUnauthenticatedRequest()));
                }
                if (this.getScope() != null) {
                    data.set("scope", om.valueToTree(this.getScope()));
                }
                if (this.getSessionCookieName() != null) {
                    data.set("sessionCookieName", om.valueToTree(this.getSessionCookieName()));
                }
                if (this.getSessionTimeout() != null) {
                    data.set("sessionTimeout", om.valueToTree(this.getSessionTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnListener.AuthenticateCognitoConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthenticateCognitoConfigProperty.Jsii$Proxy that = (AuthenticateCognitoConfigProperty.Jsii$Proxy) o;

                if (!userPoolArn.equals(that.userPoolArn)) return false;
                if (!userPoolClientId.equals(that.userPoolClientId)) return false;
                if (!userPoolDomain.equals(that.userPoolDomain)) return false;
                if (this.authenticationRequestExtraParams != null ? !this.authenticationRequestExtraParams.equals(that.authenticationRequestExtraParams) : that.authenticationRequestExtraParams != null) return false;
                if (this.onUnauthenticatedRequest != null ? !this.onUnauthenticatedRequest.equals(that.onUnauthenticatedRequest) : that.onUnauthenticatedRequest != null) return false;
                if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
                if (this.sessionCookieName != null ? !this.sessionCookieName.equals(that.sessionCookieName) : that.sessionCookieName != null) return false;
                return this.sessionTimeout != null ? this.sessionTimeout.equals(that.sessionTimeout) : that.sessionTimeout == null;
            }

            @Override
            public int hashCode() {
                int result = this.userPoolArn.hashCode();
                result = 31 * result + (this.userPoolClientId.hashCode());
                result = 31 * result + (this.userPoolDomain.hashCode());
                result = 31 * result + (this.authenticationRequestExtraParams != null ? this.authenticationRequestExtraParams.hashCode() : 0);
                result = 31 * result + (this.onUnauthenticatedRequest != null ? this.onUnauthenticatedRequest.hashCode() : 0);
                result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
                result = 31 * result + (this.sessionCookieName != null ? this.sessionCookieName.hashCode() : 0);
                result = 31 * result + (this.sessionTimeout != null ? this.sessionTimeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListener.AuthenticateOidcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthenticateOidcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthenticateOidcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListener.AuthenticateOidcConfigProperty.AuthorizationEndpoint`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authorizationendpoint
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthorizationEndpoint();

        /**
         * `CfnListener.AuthenticateOidcConfigProperty.ClientId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * `CfnListener.AuthenticateOidcConfigProperty.ClientSecret`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientsecret
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientSecret();

        /**
         * `CfnListener.AuthenticateOidcConfigProperty.Issuer`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-issuer
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIssuer();

        /**
         * `CfnListener.AuthenticateOidcConfigProperty.TokenEndpoint`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-tokenendpoint
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTokenEndpoint();

        /**
         * `CfnListener.AuthenticateOidcConfigProperty.UserInfoEndpoint`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-userinfoendpoint
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserInfoEndpoint();

        /**
         * `CfnListener.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authenticationrequestextraparams
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticationRequestExtraParams() {
            return null;
        }

        /**
         * `CfnListener.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-onunauthenticatedrequest
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnUnauthenticatedRequest() {
            return null;
        }

        /**
         * `CfnListener.AuthenticateOidcConfigProperty.Scope`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-scope
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
            return null;
        }

        /**
         * `CfnListener.AuthenticateOidcConfigProperty.SessionCookieName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessioncookiename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSessionCookieName() {
            return null;
        }

        /**
         * `CfnListener.AuthenticateOidcConfigProperty.SessionTimeout`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessiontimeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSessionTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthenticateOidcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthenticateOidcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthenticateOidcConfigProperty> {
            private java.lang.String authorizationEndpoint;
            private java.lang.String clientId;
            private java.lang.String clientSecret;
            private java.lang.String issuer;
            private java.lang.String tokenEndpoint;
            private java.lang.String userInfoEndpoint;
            private java.lang.Object authenticationRequestExtraParams;
            private java.lang.String onUnauthenticatedRequest;
            private java.lang.String scope;
            private java.lang.String sessionCookieName;
            private java.lang.Number sessionTimeout;

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getAuthorizationEndpoint}
             * @param authorizationEndpoint `CfnListener.AuthenticateOidcConfigProperty.AuthorizationEndpoint`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationEndpoint(java.lang.String authorizationEndpoint) {
                this.authorizationEndpoint = authorizationEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getClientId}
             * @param clientId `CfnListener.AuthenticateOidcConfigProperty.ClientId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getClientSecret}
             * @param clientSecret `CfnListener.AuthenticateOidcConfigProperty.ClientSecret`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getIssuer}
             * @param issuer `CfnListener.AuthenticateOidcConfigProperty.Issuer`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder issuer(java.lang.String issuer) {
                this.issuer = issuer;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getTokenEndpoint}
             * @param tokenEndpoint `CfnListener.AuthenticateOidcConfigProperty.TokenEndpoint`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenEndpoint(java.lang.String tokenEndpoint) {
                this.tokenEndpoint = tokenEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getUserInfoEndpoint}
             * @param userInfoEndpoint `CfnListener.AuthenticateOidcConfigProperty.UserInfoEndpoint`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userInfoEndpoint(java.lang.String userInfoEndpoint) {
                this.userInfoEndpoint = userInfoEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getAuthenticationRequestExtraParams}
             * @param authenticationRequestExtraParams `CfnListener.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationRequestExtraParams(software.amazon.awscdk.core.IResolvable authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getAuthenticationRequestExtraParams}
             * @param authenticationRequestExtraParams `CfnListener.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationRequestExtraParams(java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getOnUnauthenticatedRequest}
             * @param onUnauthenticatedRequest `CfnListener.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onUnauthenticatedRequest(java.lang.String onUnauthenticatedRequest) {
                this.onUnauthenticatedRequest = onUnauthenticatedRequest;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getScope}
             * @param scope `CfnListener.AuthenticateOidcConfigProperty.Scope`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getSessionCookieName}
             * @param sessionCookieName `CfnListener.AuthenticateOidcConfigProperty.SessionCookieName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionCookieName(java.lang.String sessionCookieName) {
                this.sessionCookieName = sessionCookieName;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getSessionTimeout}
             * @param sessionTimeout `CfnListener.AuthenticateOidcConfigProperty.SessionTimeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionTimeout(java.lang.Number sessionTimeout) {
                this.sessionTimeout = sessionTimeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticateOidcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthenticateOidcConfigProperty build() {
                return new Jsii$Proxy(authorizationEndpoint, clientId, clientSecret, issuer, tokenEndpoint, userInfoEndpoint, authenticationRequestExtraParams, onUnauthenticatedRequest, scope, sessionCookieName, sessionTimeout);
            }
        }

        /**
         * An implementation for {@link AuthenticateOidcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticateOidcConfigProperty {
            private final java.lang.String authorizationEndpoint;
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;
            private final java.lang.String issuer;
            private final java.lang.String tokenEndpoint;
            private final java.lang.String userInfoEndpoint;
            private final java.lang.Object authenticationRequestExtraParams;
            private final java.lang.String onUnauthenticatedRequest;
            private final java.lang.String scope;
            private final java.lang.String sessionCookieName;
            private final java.lang.Number sessionTimeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizationEndpoint = this.jsiiGet("authorizationEndpoint", java.lang.String.class);
                this.clientId = this.jsiiGet("clientId", java.lang.String.class);
                this.clientSecret = this.jsiiGet("clientSecret", java.lang.String.class);
                this.issuer = this.jsiiGet("issuer", java.lang.String.class);
                this.tokenEndpoint = this.jsiiGet("tokenEndpoint", java.lang.String.class);
                this.userInfoEndpoint = this.jsiiGet("userInfoEndpoint", java.lang.String.class);
                this.authenticationRequestExtraParams = this.jsiiGet("authenticationRequestExtraParams", java.lang.Object.class);
                this.onUnauthenticatedRequest = this.jsiiGet("onUnauthenticatedRequest", java.lang.String.class);
                this.scope = this.jsiiGet("scope", java.lang.String.class);
                this.sessionCookieName = this.jsiiGet("sessionCookieName", java.lang.String.class);
                this.sessionTimeout = this.jsiiGet("sessionTimeout", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String authorizationEndpoint, final java.lang.String clientId, final java.lang.String clientSecret, final java.lang.String issuer, final java.lang.String tokenEndpoint, final java.lang.String userInfoEndpoint, final java.lang.Object authenticationRequestExtraParams, final java.lang.String onUnauthenticatedRequest, final java.lang.String scope, final java.lang.String sessionCookieName, final java.lang.Number sessionTimeout) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizationEndpoint = java.util.Objects.requireNonNull(authorizationEndpoint, "authorizationEndpoint is required");
                this.clientId = java.util.Objects.requireNonNull(clientId, "clientId is required");
                this.clientSecret = java.util.Objects.requireNonNull(clientSecret, "clientSecret is required");
                this.issuer = java.util.Objects.requireNonNull(issuer, "issuer is required");
                this.tokenEndpoint = java.util.Objects.requireNonNull(tokenEndpoint, "tokenEndpoint is required");
                this.userInfoEndpoint = java.util.Objects.requireNonNull(userInfoEndpoint, "userInfoEndpoint is required");
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                this.onUnauthenticatedRequest = onUnauthenticatedRequest;
                this.scope = scope;
                this.sessionCookieName = sessionCookieName;
                this.sessionTimeout = sessionTimeout;
            }

            @Override
            public java.lang.String getAuthorizationEndpoint() {
                return this.authorizationEndpoint;
            }

            @Override
            public java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public java.lang.String getIssuer() {
                return this.issuer;
            }

            @Override
            public java.lang.String getTokenEndpoint() {
                return this.tokenEndpoint;
            }

            @Override
            public java.lang.String getUserInfoEndpoint() {
                return this.userInfoEndpoint;
            }

            @Override
            public java.lang.Object getAuthenticationRequestExtraParams() {
                return this.authenticationRequestExtraParams;
            }

            @Override
            public java.lang.String getOnUnauthenticatedRequest() {
                return this.onUnauthenticatedRequest;
            }

            @Override
            public java.lang.String getScope() {
                return this.scope;
            }

            @Override
            public java.lang.String getSessionCookieName() {
                return this.sessionCookieName;
            }

            @Override
            public java.lang.Number getSessionTimeout() {
                return this.sessionTimeout;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authorizationEndpoint", om.valueToTree(this.getAuthorizationEndpoint()));
                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                data.set("issuer", om.valueToTree(this.getIssuer()));
                data.set("tokenEndpoint", om.valueToTree(this.getTokenEndpoint()));
                data.set("userInfoEndpoint", om.valueToTree(this.getUserInfoEndpoint()));
                if (this.getAuthenticationRequestExtraParams() != null) {
                    data.set("authenticationRequestExtraParams", om.valueToTree(this.getAuthenticationRequestExtraParams()));
                }
                if (this.getOnUnauthenticatedRequest() != null) {
                    data.set("onUnauthenticatedRequest", om.valueToTree(this.getOnUnauthenticatedRequest()));
                }
                if (this.getScope() != null) {
                    data.set("scope", om.valueToTree(this.getScope()));
                }
                if (this.getSessionCookieName() != null) {
                    data.set("sessionCookieName", om.valueToTree(this.getSessionCookieName()));
                }
                if (this.getSessionTimeout() != null) {
                    data.set("sessionTimeout", om.valueToTree(this.getSessionTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnListener.AuthenticateOidcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthenticateOidcConfigProperty.Jsii$Proxy that = (AuthenticateOidcConfigProperty.Jsii$Proxy) o;

                if (!authorizationEndpoint.equals(that.authorizationEndpoint)) return false;
                if (!clientId.equals(that.clientId)) return false;
                if (!clientSecret.equals(that.clientSecret)) return false;
                if (!issuer.equals(that.issuer)) return false;
                if (!tokenEndpoint.equals(that.tokenEndpoint)) return false;
                if (!userInfoEndpoint.equals(that.userInfoEndpoint)) return false;
                if (this.authenticationRequestExtraParams != null ? !this.authenticationRequestExtraParams.equals(that.authenticationRequestExtraParams) : that.authenticationRequestExtraParams != null) return false;
                if (this.onUnauthenticatedRequest != null ? !this.onUnauthenticatedRequest.equals(that.onUnauthenticatedRequest) : that.onUnauthenticatedRequest != null) return false;
                if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
                if (this.sessionCookieName != null ? !this.sessionCookieName.equals(that.sessionCookieName) : that.sessionCookieName != null) return false;
                return this.sessionTimeout != null ? this.sessionTimeout.equals(that.sessionTimeout) : that.sessionTimeout == null;
            }

            @Override
            public int hashCode() {
                int result = this.authorizationEndpoint.hashCode();
                result = 31 * result + (this.clientId.hashCode());
                result = 31 * result + (this.clientSecret.hashCode());
                result = 31 * result + (this.issuer.hashCode());
                result = 31 * result + (this.tokenEndpoint.hashCode());
                result = 31 * result + (this.userInfoEndpoint.hashCode());
                result = 31 * result + (this.authenticationRequestExtraParams != null ? this.authenticationRequestExtraParams.hashCode() : 0);
                result = 31 * result + (this.onUnauthenticatedRequest != null ? this.onUnauthenticatedRequest.hashCode() : 0);
                result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
                result = 31 * result + (this.sessionCookieName != null ? this.sessionCookieName.hashCode() : 0);
                result = 31 * result + (this.sessionTimeout != null ? this.sessionTimeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListener.CertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(CertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListener.CertificateProperty.CertificateArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CertificateProperty> {
            private java.lang.String certificateArn;

            /**
             * Sets the value of {@link CertificateProperty#getCertificateArn}
             * @param certificateArn `CfnListener.CertificateProperty.CertificateArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CertificateProperty build() {
                return new Jsii$Proxy(certificateArn);
            }
        }

        /**
         * An implementation for {@link CertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateProperty {
            private final java.lang.String certificateArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateArn = this.jsiiGet("certificateArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String certificateArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateArn = certificateArn;
            }

            @Override
            public java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCertificateArn() != null) {
                    data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnListener.CertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CertificateProperty.Jsii$Proxy that = (CertificateProperty.Jsii$Proxy) o;

                return this.certificateArn != null ? this.certificateArn.equals(that.certificateArn) : that.certificateArn == null;
            }

            @Override
            public int hashCode() {
                int result = this.certificateArn != null ? this.certificateArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListener.FixedResponseConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FixedResponseConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FixedResponseConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListener.FixedResponseConfigProperty.StatusCode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-statuscode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

        /**
         * `CfnListener.FixedResponseConfigProperty.ContentType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-contenttype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
            return null;
        }

        /**
         * `CfnListener.FixedResponseConfigProperty.MessageBody`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-messagebody
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageBody() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FixedResponseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FixedResponseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FixedResponseConfigProperty> {
            private java.lang.String statusCode;
            private java.lang.String contentType;
            private java.lang.String messageBody;

            /**
             * Sets the value of {@link FixedResponseConfigProperty#getStatusCode}
             * @param statusCode `CfnListener.FixedResponseConfigProperty.StatusCode`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of {@link FixedResponseConfigProperty#getContentType}
             * @param contentType `CfnListener.FixedResponseConfigProperty.ContentType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentType(java.lang.String contentType) {
                this.contentType = contentType;
                return this;
            }

            /**
             * Sets the value of {@link FixedResponseConfigProperty#getMessageBody}
             * @param messageBody `CfnListener.FixedResponseConfigProperty.MessageBody`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageBody(java.lang.String messageBody) {
                this.messageBody = messageBody;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FixedResponseConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FixedResponseConfigProperty build() {
                return new Jsii$Proxy(statusCode, contentType, messageBody);
            }
        }

        /**
         * An implementation for {@link FixedResponseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FixedResponseConfigProperty {
            private final java.lang.String statusCode;
            private final java.lang.String contentType;
            private final java.lang.String messageBody;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCode = this.jsiiGet("statusCode", java.lang.String.class);
                this.contentType = this.jsiiGet("contentType", java.lang.String.class);
                this.messageBody = this.jsiiGet("messageBody", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String statusCode, final java.lang.String contentType, final java.lang.String messageBody) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(statusCode, "statusCode is required");
                this.contentType = contentType;
                this.messageBody = messageBody;
            }

            @Override
            public java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public java.lang.String getContentType() {
                return this.contentType;
            }

            @Override
            public java.lang.String getMessageBody() {
                return this.messageBody;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getContentType() != null) {
                    data.set("contentType", om.valueToTree(this.getContentType()));
                }
                if (this.getMessageBody() != null) {
                    data.set("messageBody", om.valueToTree(this.getMessageBody()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnListener.FixedResponseConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FixedResponseConfigProperty.Jsii$Proxy that = (FixedResponseConfigProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
                return this.messageBody != null ? this.messageBody.equals(that.messageBody) : that.messageBody == null;
            }

            @Override
            public int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
                result = 31 * result + (this.messageBody != null ? this.messageBody.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListener.ForwardConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ForwardConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ForwardConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListener.ForwardConfigProperty.TargetGroups`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html#cfn-elasticloadbalancingv2-listener-forwardconfig-targetgroups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetGroups() {
            return null;
        }

        /**
         * `CfnListener.ForwardConfigProperty.TargetGroupStickinessConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html#cfn-elasticloadbalancingv2-listener-forwardconfig-targetgroupstickinessconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetGroupStickinessConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ForwardConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ForwardConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ForwardConfigProperty> {
            private java.lang.Object targetGroups;
            private java.lang.Object targetGroupStickinessConfig;

            /**
             * Sets the value of {@link ForwardConfigProperty#getTargetGroups}
             * @param targetGroups `CfnListener.ForwardConfigProperty.TargetGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroups(software.amazon.awscdk.core.IResolvable targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            /**
             * Sets the value of {@link ForwardConfigProperty#getTargetGroups}
             * @param targetGroups `CfnListener.ForwardConfigProperty.TargetGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroups(java.util.List<java.lang.Object> targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            /**
             * Sets the value of {@link ForwardConfigProperty#getTargetGroupStickinessConfig}
             * @param targetGroupStickinessConfig `CfnListener.ForwardConfigProperty.TargetGroupStickinessConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupStickinessConfig(software.amazon.awscdk.core.IResolvable targetGroupStickinessConfig) {
                this.targetGroupStickinessConfig = targetGroupStickinessConfig;
                return this;
            }

            /**
             * Sets the value of {@link ForwardConfigProperty#getTargetGroupStickinessConfig}
             * @param targetGroupStickinessConfig `CfnListener.ForwardConfigProperty.TargetGroupStickinessConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupStickinessConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.TargetGroupStickinessConfigProperty targetGroupStickinessConfig) {
                this.targetGroupStickinessConfig = targetGroupStickinessConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ForwardConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ForwardConfigProperty build() {
                return new Jsii$Proxy(targetGroups, targetGroupStickinessConfig);
            }
        }

        /**
         * An implementation for {@link ForwardConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ForwardConfigProperty {
            private final java.lang.Object targetGroups;
            private final java.lang.Object targetGroupStickinessConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetGroups = this.jsiiGet("targetGroups", java.lang.Object.class);
                this.targetGroupStickinessConfig = this.jsiiGet("targetGroupStickinessConfig", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object targetGroups, final java.lang.Object targetGroupStickinessConfig) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetGroups = targetGroups;
                this.targetGroupStickinessConfig = targetGroupStickinessConfig;
            }

            @Override
            public java.lang.Object getTargetGroups() {
                return this.targetGroups;
            }

            @Override
            public java.lang.Object getTargetGroupStickinessConfig() {
                return this.targetGroupStickinessConfig;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTargetGroups() != null) {
                    data.set("targetGroups", om.valueToTree(this.getTargetGroups()));
                }
                if (this.getTargetGroupStickinessConfig() != null) {
                    data.set("targetGroupStickinessConfig", om.valueToTree(this.getTargetGroupStickinessConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnListener.ForwardConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ForwardConfigProperty.Jsii$Proxy that = (ForwardConfigProperty.Jsii$Proxy) o;

                if (this.targetGroups != null ? !this.targetGroups.equals(that.targetGroups) : that.targetGroups != null) return false;
                return this.targetGroupStickinessConfig != null ? this.targetGroupStickinessConfig.equals(that.targetGroupStickinessConfig) : that.targetGroupStickinessConfig == null;
            }

            @Override
            public int hashCode() {
                int result = this.targetGroups != null ? this.targetGroups.hashCode() : 0;
                result = 31 * result + (this.targetGroupStickinessConfig != null ? this.targetGroupStickinessConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListener.RedirectConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RedirectConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedirectConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListener.RedirectConfigProperty.StatusCode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-statuscode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

        /**
         * `CfnListener.RedirectConfigProperty.Host`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-host
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHost() {
            return null;
        }

        /**
         * `CfnListener.RedirectConfigProperty.Path`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-path
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * `CfnListener.RedirectConfigProperty.Port`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-port
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
            return null;
        }

        /**
         * `CfnListener.RedirectConfigProperty.Protocol`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-protocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * `CfnListener.RedirectConfigProperty.Query`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-query
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQuery() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedirectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedirectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedirectConfigProperty> {
            private java.lang.String statusCode;
            private java.lang.String host;
            private java.lang.String path;
            private java.lang.String port;
            private java.lang.String protocol;
            private java.lang.String query;

            /**
             * Sets the value of {@link RedirectConfigProperty#getStatusCode}
             * @param statusCode `CfnListener.RedirectConfigProperty.StatusCode`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getHost}
             * @param host `CfnListener.RedirectConfigProperty.Host`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getPath}
             * @param path `CfnListener.RedirectConfigProperty.Path`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getPort}
             * @param port `CfnListener.RedirectConfigProperty.Port`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.String port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getProtocol}
             * @param protocol `CfnListener.RedirectConfigProperty.Protocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getQuery}
             * @param query `CfnListener.RedirectConfigProperty.Query`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder query(java.lang.String query) {
                this.query = query;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedirectConfigProperty build() {
                return new Jsii$Proxy(statusCode, host, path, port, protocol, query);
            }
        }

        /**
         * An implementation for {@link RedirectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedirectConfigProperty {
            private final java.lang.String statusCode;
            private final java.lang.String host;
            private final java.lang.String path;
            private final java.lang.String port;
            private final java.lang.String protocol;
            private final java.lang.String query;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCode = this.jsiiGet("statusCode", java.lang.String.class);
                this.host = this.jsiiGet("host", java.lang.String.class);
                this.path = this.jsiiGet("path", java.lang.String.class);
                this.port = this.jsiiGet("port", java.lang.String.class);
                this.protocol = this.jsiiGet("protocol", java.lang.String.class);
                this.query = this.jsiiGet("query", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String statusCode, final java.lang.String host, final java.lang.String path, final java.lang.String port, final java.lang.String protocol, final java.lang.String query) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(statusCode, "statusCode is required");
                this.host = host;
                this.path = path;
                this.port = port;
                this.protocol = protocol;
                this.query = query;
            }

            @Override
            public java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public java.lang.String getHost() {
                return this.host;
            }

            @Override
            public java.lang.String getPath() {
                return this.path;
            }

            @Override
            public java.lang.String getPort() {
                return this.port;
            }

            @Override
            public java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public java.lang.String getQuery() {
                return this.query;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getHost() != null) {
                    data.set("host", om.valueToTree(this.getHost()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getQuery() != null) {
                    data.set("query", om.valueToTree(this.getQuery()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnListener.RedirectConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedirectConfigProperty.Jsii$Proxy that = (RedirectConfigProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                return this.query != null ? this.query.equals(that.query) : that.query == null;
            }

            @Override
            public int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListener.TargetGroupStickinessConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetGroupStickinessConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupStickinessConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListener.TargetGroupStickinessConfigProperty.DurationSeconds`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listener-targetgroupstickinessconfig-durationseconds
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationSeconds() {
            return null;
        }

        /**
         * `CfnListener.TargetGroupStickinessConfigProperty.Enabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listener-targetgroupstickinessconfig-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetGroupStickinessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetGroupStickinessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetGroupStickinessConfigProperty> {
            private java.lang.Number durationSeconds;
            private java.lang.Object enabled;

            /**
             * Sets the value of {@link TargetGroupStickinessConfigProperty#getDurationSeconds}
             * @param durationSeconds `CfnListener.TargetGroupStickinessConfigProperty.DurationSeconds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationSeconds(java.lang.Number durationSeconds) {
                this.durationSeconds = durationSeconds;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupStickinessConfigProperty#getEnabled}
             * @param enabled `CfnListener.TargetGroupStickinessConfigProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupStickinessConfigProperty#getEnabled}
             * @param enabled `CfnListener.TargetGroupStickinessConfigProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupStickinessConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetGroupStickinessConfigProperty build() {
                return new Jsii$Proxy(durationSeconds, enabled);
            }
        }

        /**
         * An implementation for {@link TargetGroupStickinessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupStickinessConfigProperty {
            private final java.lang.Number durationSeconds;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationSeconds = this.jsiiGet("durationSeconds", java.lang.Number.class);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number durationSeconds, final java.lang.Object enabled) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationSeconds = durationSeconds;
                this.enabled = enabled;
            }

            @Override
            public java.lang.Number getDurationSeconds() {
                return this.durationSeconds;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationSeconds() != null) {
                    data.set("durationSeconds", om.valueToTree(this.getDurationSeconds()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnListener.TargetGroupStickinessConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetGroupStickinessConfigProperty.Jsii$Proxy that = (TargetGroupStickinessConfigProperty.Jsii$Proxy) o;

                if (this.durationSeconds != null ? !this.durationSeconds.equals(that.durationSeconds) : that.durationSeconds != null) return false;
                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public int hashCode() {
                int result = this.durationSeconds != null ? this.durationSeconds.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListener.TargetGroupTupleProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetGroupTupleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupTupleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnListener.TargetGroupTupleProperty.TargetGroupArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html#cfn-elasticloadbalancingv2-listener-targetgrouptuple-targetgrouparn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetGroupArn() {
            return null;
        }

        /**
         * `CfnListener.TargetGroupTupleProperty.Weight`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html#cfn-elasticloadbalancingv2-listener-targetgrouptuple-weight
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetGroupTupleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetGroupTupleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetGroupTupleProperty> {
            private java.lang.String targetGroupArn;
            private java.lang.Number weight;

            /**
             * Sets the value of {@link TargetGroupTupleProperty#getTargetGroupArn}
             * @param targetGroupArn `CfnListener.TargetGroupTupleProperty.TargetGroupArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupArn(java.lang.String targetGroupArn) {
                this.targetGroupArn = targetGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupTupleProperty#getWeight}
             * @param weight `CfnListener.TargetGroupTupleProperty.Weight`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupTupleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetGroupTupleProperty build() {
                return new Jsii$Proxy(targetGroupArn, weight);
            }
        }

        /**
         * An implementation for {@link TargetGroupTupleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupTupleProperty {
            private final java.lang.String targetGroupArn;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetGroupArn = this.jsiiGet("targetGroupArn", java.lang.String.class);
                this.weight = this.jsiiGet("weight", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String targetGroupArn, final java.lang.Number weight) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetGroupArn = targetGroupArn;
                this.weight = weight;
            }

            @Override
            public java.lang.String getTargetGroupArn() {
                return this.targetGroupArn;
            }

            @Override
            public java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTargetGroupArn() != null) {
                    data.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.CfnListener.TargetGroupTupleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetGroupTupleProperty.Jsii$Proxy that = (TargetGroupTupleProperty.Jsii$Proxy) o;

                if (this.targetGroupArn != null ? !this.targetGroupArn.equals(that.targetGroupArn) : that.targetGroupArn != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public int hashCode() {
                int result = this.targetGroupArn != null ? this.targetGroupArn.hashCode() : 0;
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerProps.Builder();
        }

        /**
         * `AWS::ElasticLoadBalancingV2::Listener.DefaultActions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-defaultactions
         * @param defaultActions `AWS::ElasticLoadBalancingV2::Listener.DefaultActions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultActions(final software.amazon.awscdk.core.IResolvable defaultActions) {
            this.props.defaultActions(defaultActions);
            return this;
        }
        /**
         * `AWS::ElasticLoadBalancingV2::Listener.DefaultActions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-defaultactions
         * @param defaultActions `AWS::ElasticLoadBalancingV2::Listener.DefaultActions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultActions(final java.util.List<java.lang.Object> defaultActions) {
            this.props.defaultActions(defaultActions);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancingV2::Listener.LoadBalancerArn`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-loadbalancerarn
         * @param loadBalancerArn `AWS::ElasticLoadBalancingV2::Listener.LoadBalancerArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerArn(final java.lang.String loadBalancerArn) {
            this.props.loadBalancerArn(loadBalancerArn);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancingV2::Listener.Port`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-port
         * @param port `AWS::ElasticLoadBalancingV2::Listener.Port`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancingV2::Listener.Protocol`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-protocol
         * @param protocol `AWS::ElasticLoadBalancingV2::Listener.Protocol`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final java.lang.String protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancingV2::Listener.Certificates`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-certificates
         * @param certificates `AWS::ElasticLoadBalancingV2::Listener.Certificates`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificates(final software.amazon.awscdk.core.IResolvable certificates) {
            this.props.certificates(certificates);
            return this;
        }
        /**
         * `AWS::ElasticLoadBalancingV2::Listener.Certificates`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-certificates
         * @param certificates `AWS::ElasticLoadBalancingV2::Listener.Certificates`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificates(final java.util.List<java.lang.Object> certificates) {
            this.props.certificates(certificates);
            return this;
        }

        /**
         * `AWS::ElasticLoadBalancingV2::Listener.SslPolicy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-sslpolicy
         * @param sslPolicy `AWS::ElasticLoadBalancingV2::Listener.SslPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslPolicy(final java.lang.String sslPolicy) {
            this.props.sslPolicy(sslPolicy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
