package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::ListenerRule`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-21T10:55:00.802Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnListenerRuleProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getActions();

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getConditions();

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.ListenerArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-listenerarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getListenerArn();

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Priority`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-priority
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getPriority();

    /**
     * @return a {@link Builder} of {@link CfnListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.Object actions;
        private java.lang.Object conditions;
        private java.lang.String listenerArn;
        private java.lang.Number priority;

        /**
         * Sets the value of Actions
         * @param actions `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder actions(software.amazon.awscdk.core.IResolvable actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of Actions
         * @param actions `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder actions(java.util.List<java.lang.Object> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of Conditions
         * @param conditions `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder conditions(software.amazon.awscdk.core.IResolvable conditions) {
            this.conditions = conditions;
            return this;
        }

        /**
         * Sets the value of Conditions
         * @param conditions `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder conditions(java.util.List<java.lang.Object> conditions) {
            this.conditions = conditions;
            return this;
        }

        /**
         * Sets the value of ListenerArn
         * @param listenerArn `AWS::ElasticLoadBalancingV2::ListenerRule.ListenerArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder listenerArn(java.lang.String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        /**
         * Sets the value of Priority
         * @param priority `AWS::ElasticLoadBalancingV2::ListenerRule.Priority`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnListenerRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnListenerRuleProps build() {
            return new Jsii$Proxy(actions, conditions, listenerArn, priority);
        }

    }

    /**
     * An implementation for {@link CfnListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnListenerRuleProps {
        private final java.lang.Object actions;
        private final java.lang.Object conditions;
        private final java.lang.String listenerArn;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.actions = this.jsiiGet("actions", java.lang.Object.class);
            this.conditions = this.jsiiGet("conditions", java.lang.Object.class);
            this.listenerArn = this.jsiiGet("listenerArn", java.lang.String.class);
            this.priority = this.jsiiGet("priority", java.lang.Number.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Object actions, java.lang.Object conditions, java.lang.String listenerArn, java.lang.Number priority) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actions = java.util.Objects.requireNonNull(actions, "actions is required");
            this.conditions = java.util.Objects.requireNonNull(conditions, "conditions is required");
            this.listenerArn = java.util.Objects.requireNonNull(listenerArn, "listenerArn is required");
            this.priority = java.util.Objects.requireNonNull(priority, "priority is required");
        }

        @Override
        public java.lang.Object getActions() {
            return this.actions;
        }

        @Override
        public java.lang.Object getConditions() {
            return this.conditions;
        }

        @Override
        public java.lang.String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("actions", om.valueToTree(this.getActions()));
            obj.set("conditions", om.valueToTree(this.getConditions()));
            obj.set("listenerArn", om.valueToTree(this.getListenerArn()));
            obj.set("priority", om.valueToTree(this.getPriority()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnListenerRuleProps.Jsii$Proxy that = (CfnListenerRuleProps.Jsii$Proxy) o;

            if (!actions.equals(that.actions)) return false;
            if (!conditions.equals(that.conditions)) return false;
            if (!listenerArn.equals(that.listenerArn)) return false;
            return this.priority.equals(that.priority);
        }

        @Override
        public int hashCode() {
            int result = this.actions.hashCode();
            result = 31 * result + (this.conditions.hashCode());
            result = 31 * result + (this.listenerArn.hashCode());
            result = 31 * result + (this.priority.hashCode());
            return result;
        }

    }
}
