package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::LoadBalancer`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-21T10:55:00.802Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnLoadBalancer")
public class CfnLoadBalancer extends software.amazon.awscdk.core.CfnResource {

    protected CfnLoadBalancer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancer.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::ElasticLoadBalancingV2::LoadBalancer`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnLoadBalancer(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props }));
    }
    /**
     * Create a new `AWS::ElasticLoadBalancingV2::LoadBalancer`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnLoadBalancer(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrCanonicalHostedZoneId() {
        return this.jsiiGet("attrCanonicalHostedZoneId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrDnsName() {
        return this.jsiiGet("attrDnsName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrLoadBalancerFullName() {
        return this.jsiiGet("attrLoadBalancerFullName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrLoadBalancerName() {
        return this.jsiiGet("attrLoadBalancerName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getAttrSecurityGroups() {
        return this.jsiiGet("attrSecurityGroups", java.util.List.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.IpAddressType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-ipaddresstype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getIpAddressType() {
        return this.jsiiGet("ipAddressType", java.lang.String.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.IpAddressType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-ipaddresstype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIpAddressType(final java.lang.String value) {
        this.jsiiSet("ipAddressType", value);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.LoadBalancerAttributes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getLoadBalancerAttributes() {
        return this.jsiiGet("loadBalancerAttributes", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.LoadBalancerAttributes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLoadBalancerAttributes(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("loadBalancerAttributes", value);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.LoadBalancerAttributes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLoadBalancerAttributes(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("loadBalancerAttributes", value);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setName(final java.lang.String value) {
        this.jsiiSet("name", value);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Scheme`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-scheme
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getScheme() {
        return this.jsiiGet("scheme", java.lang.String.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Scheme`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-scheme
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setScheme(final java.lang.String value) {
        this.jsiiSet("scheme", value);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SecurityGroups`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getSecurityGroups() {
        return this.jsiiGet("securityGroups", java.util.List.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SecurityGroups`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroups(final java.util.List<java.lang.String> value) {
        this.jsiiSet("securityGroups", value);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SubnetMappings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getSubnetMappings() {
        return this.jsiiGet("subnetMappings", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SubnetMappings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSubnetMappings(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("subnetMappings", value);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SubnetMappings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSubnetMappings(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("subnetMappings", value);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Subnets`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getSubnets() {
        return this.jsiiGet("subnets", java.util.List.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Subnets`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSubnets(final java.util.List<java.lang.String> value) {
        this.jsiiSet("subnets", value);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Type`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getType() {
        return this.jsiiGet("type", java.lang.String.class);
    }

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Type`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setType(final java.lang.String value) {
        this.jsiiSet("type", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LoadBalancerAttributeProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLoadBalancer.LoadBalancerAttributeProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKey();

        /**
         * `CfnLoadBalancer.LoadBalancerAttributeProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link LoadBalancerAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LoadBalancerAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String key;
            private java.lang.String value;

            /**
             * Sets the value of Key
             * @param key `CfnLoadBalancer.LoadBalancerAttributeProperty.Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of Value
             * @param value `CfnLoadBalancer.LoadBalancerAttributeProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancerAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LoadBalancerAttributeProperty build() {
                return new Jsii$Proxy(key, value);
            }

        }

        /**
         * An implementation for {@link LoadBalancerAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerAttributeProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String key, java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = key;
                this.value = value;
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getKey() != null) {
                    obj.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    obj.set("value", om.valueToTree(this.getValue()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoadBalancerAttributeProperty.Jsii$Proxy that = (LoadBalancerAttributeProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SubnetMappingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnLoadBalancer.SubnetMappingProperty.AllocationId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-allocationid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getAllocationId();

        /**
         * `CfnLoadBalancer.SubnetMappingProperty.SubnetId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-subnetid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSubnetId();

        /**
         * @return a {@link Builder} of {@link SubnetMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SubnetMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String allocationId;
            private java.lang.String subnetId;

            /**
             * Sets the value of AllocationId
             * @param allocationId `CfnLoadBalancer.SubnetMappingProperty.AllocationId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder allocationId(java.lang.String allocationId) {
                this.allocationId = allocationId;
                return this;
            }

            /**
             * Sets the value of SubnetId
             * @param subnetId `CfnLoadBalancer.SubnetMappingProperty.SubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubnetMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SubnetMappingProperty build() {
                return new Jsii$Proxy(allocationId, subnetId);
            }

        }

        /**
         * An implementation for {@link SubnetMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubnetMappingProperty {
            private final java.lang.String allocationId;
            private final java.lang.String subnetId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.allocationId = this.jsiiGet("allocationId", java.lang.String.class);
                this.subnetId = this.jsiiGet("subnetId", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String allocationId, java.lang.String subnetId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allocationId = java.util.Objects.requireNonNull(allocationId, "allocationId is required");
                this.subnetId = java.util.Objects.requireNonNull(subnetId, "subnetId is required");
            }

            @Override
            public java.lang.String getAllocationId() {
                return this.allocationId;
            }

            @Override
            public java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("allocationId", om.valueToTree(this.getAllocationId()));
                obj.set("subnetId", om.valueToTree(this.getSubnetId()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubnetMappingProperty.Jsii$Proxy that = (SubnetMappingProperty.Jsii$Proxy) o;

                if (!allocationId.equals(that.allocationId)) return false;
                return this.subnetId.equals(that.subnetId);
            }

            @Override
            public int hashCode() {
                int result = this.allocationId.hashCode();
                result = 31 * result + (this.subnetId.hashCode());
                return result;
            }

        }
    }
}
