/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.List;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetType;
import software.amazon.jsii.JsiiSerializable;

public interface ApplicationTargetGroupProps
extends JsiiSerializable,
BaseTargetGroupProps {
    public Number getPort();

    public ApplicationProtocol getProtocol();

    public Duration getSlowStart();

    public Duration getStickinessCookieDuration();

    public List<IApplicationLoadBalancerTarget> getTargets();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number port;
        private ApplicationProtocol protocol;
        private Duration slowStart;
        private Duration stickinessCookieDuration;
        private List<IApplicationLoadBalancerTarget> targets;
        private IVpc vpc;
        private Duration deregistrationDelay;
        private HealthCheck healthCheck;
        private String targetGroupName;
        private TargetType targetType;

        public Builder port(Number port) {
            this.port = port;
            return this;
        }

        public Builder protocol(ApplicationProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder slowStart(Duration slowStart) {
            this.slowStart = slowStart;
            return this;
        }

        public Builder stickinessCookieDuration(Duration stickinessCookieDuration) {
            this.stickinessCookieDuration = stickinessCookieDuration;
            return this;
        }

        public Builder targets(List<IApplicationLoadBalancerTarget> targets) {
            this.targets = targets;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder deregistrationDelay(Duration deregistrationDelay) {
            this.deregistrationDelay = deregistrationDelay;
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public Builder targetType(TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        public ApplicationTargetGroupProps build() {
            return new Jsii.Proxy(this.port, this.protocol, this.slowStart, this.stickinessCookieDuration, this.targets, this.vpc, this.deregistrationDelay, this.healthCheck, this.targetGroupName, this.targetType, null);
        }
    }
}

