/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetType;
import software.amazon.jsii.JsiiSerializable;

public interface BaseTargetGroupProps
extends JsiiSerializable {
    public IVpc getVpc();

    public Duration getDeregistrationDelay();

    public HealthCheck getHealthCheck();

    public String getTargetGroupName();

    public TargetType getTargetType();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IVpc vpc;
        private Duration deregistrationDelay;
        private HealthCheck healthCheck;
        private String targetGroupName;
        private TargetType targetType;

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder deregistrationDelay(Duration deregistrationDelay) {
            this.deregistrationDelay = deregistrationDelay;
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public Builder targetType(TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        public BaseTargetGroupProps build() {
            return new Jsii.Proxy(this.vpc, this.deregistrationDelay, this.healthCheck, this.targetGroupName, this.targetType, null);
        }
    }
}

