package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define a new network load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.8.0 (build 4a047ac)", date = "2020-07-09T13:05:32.773Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.NetworkLoadBalancer")
public class NetworkLoadBalancer extends software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancer implements software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer {

    protected NetworkLoadBalancer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkLoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NetworkLoadBalancer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer fromNetworkLoadBalancerAttributes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer.class, "fromNetworkLoadBalancerAttributes", software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add a listener to this load balancer.
     * <p>
     * @return The newly created listener
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener addListener(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.BaseNetworkListenerProps props) {
        return this.jsiiCall("addListener", software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Enable access logging for this load balancer.
     * <p>
     * A region must be specified on the stack containing the load balancer; you cannot enable logging on
     * environment-agnostic stacks. See https://docs.aws.amazon.com/cdk/latest/guide/environments.html
     * <p>
     * This is extending the BaseLoadBalancer.logAccessLogs method to match the bucket permissions described
     * at https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-access-logs.html#access-logging-bucket-requirements
     * <p>
     * @param bucket This parameter is required.
     * @param prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void logAccessLogs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable java.lang.String prefix) {
        this.jsiiCall("logAccessLogs", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), prefix });
    }

    /**
     * Enable access logging for this load balancer.
     * <p>
     * A region must be specified on the stack containing the load balancer; you cannot enable logging on
     * environment-agnostic stacks. See https://docs.aws.amazon.com/cdk/latest/guide/environments.html
     * <p>
     * This is extending the BaseLoadBalancer.logAccessLogs method to match the bucket permissions described
     * at https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-access-logs.html#access-logging-bucket-requirements
     * <p>
     * @param bucket This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void logAccessLogs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        this.jsiiCall("logAccessLogs", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * Return the given named metric for this Network Load Balancer.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Network Load Balancer.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * The total number of concurrent TCP flows (or connections) from clients to targets.
     * <p>
     * This metric includes connections in the SYN_SENT and ESTABLISHED states.
     * TCP connections are not terminated at the load balancer, so a client
     * opening a TCP connection to a target counts as a single flow.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricActiveFlowCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricActiveFlowCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The total number of concurrent TCP flows (or connections) from clients to targets.
     * <p>
     * This metric includes connections in the SYN_SENT and ESTABLISHED states.
     * TCP connections are not terminated at the load balancer, so a client
     * opening a TCP connection to a target counts as a single flow.
     * <p>
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricActiveFlowCount() {
        return this.jsiiCall("metricActiveFlowCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of load balancer capacity units (LCU) used by your load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedLCUs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricConsumedLCUs", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of load balancer capacity units (LCU) used by your load balancer.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedLCUs() {
        return this.jsiiCall("metricConsumedLCUs", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of targets that are considered healthy.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHealthyHostCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricHealthyHostCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of targets that are considered healthy.
     * <p>
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHealthyHostCount() {
        return this.jsiiCall("metricHealthyHostCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The total number of new TCP flows (or connections) established from clients to targets in the time period.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNewFlowCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricNewFlowCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The total number of new TCP flows (or connections) established from clients to targets in the time period.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNewFlowCount() {
        return this.jsiiCall("metricNewFlowCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The total number of bytes processed by the load balancer, including TCP/IP headers.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricProcessedBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricProcessedBytes", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The total number of bytes processed by the load balancer, including TCP/IP headers.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricProcessedBytes() {
        return this.jsiiCall("metricProcessedBytes", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The total number of reset (RST) packets sent from a client to a target.
     * <p>
     * These resets are generated by the client and forwarded by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTcpClientResetCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricTcpClientResetCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The total number of reset (RST) packets sent from a client to a target.
     * <p>
     * These resets are generated by the client and forwarded by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTcpClientResetCount() {
        return this.jsiiCall("metricTcpClientResetCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The total number of reset (RST) packets generated by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTcpElbResetCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricTcpElbResetCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The total number of reset (RST) packets generated by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTcpElbResetCount() {
        return this.jsiiCall("metricTcpElbResetCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The total number of reset (RST) packets sent from a target to a client.
     * <p>
     * These resets are generated by the target and forwarded by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTcpTargetResetCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricTcpTargetResetCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The total number of reset (RST) packets sent from a target to a client.
     * <p>
     * These resets are generated by the target and forwarded by the load balancer.
     * <p>
     * Default: Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTcpTargetResetCount() {
        return this.jsiiCall("metricTcpTargetResetCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of targets that are considered unhealthy.
     * <p>
     * Default: Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUnHealthyHostCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricUnHealthyHostCount", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * The number of targets that are considered unhealthy.
     * <p>
     * Default: Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUnHealthyHostCount() {
        return this.jsiiCall("metricUnHealthyHostCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerProps.Builder();
        }

        /**
         * The VPC network to place the load balancer in.
         * <p>
         * @return {@code this}
         * @param vpc The VPC network to place the load balancer in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Indicates whether deletion protection is enabled.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param deletionProtection Indicates whether deletion protection is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * Whether the load balancer has an internet-routable address.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param internetFacing Whether the load balancer has an internet-routable address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetFacing(final java.lang.Boolean internetFacing) {
            this.props.internetFacing(internetFacing);
            return this;
        }

        /**
         * Name of the load balancer.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param loadBalancerName Name of the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(final java.lang.String loadBalancerName) {
            this.props.loadBalancerName(loadBalancerName);
            return this;
        }

        /**
         * Which subnets place the load balancer in.
         * <p>
         * Default: - the Vpc default strategy.
         * <p>
         * @return {@code this}
         * @param vpcSubnets Which subnets place the load balancer in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * Indicates whether cross-zone load balancing is enabled.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param crossZoneEnabled Indicates whether cross-zone load balancing is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossZoneEnabled(final java.lang.Boolean crossZoneEnabled) {
            this.props.crossZoneEnabled(crossZoneEnabled);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
