package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * A redirect response.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-20T10:46:46.083Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.RedirectResponse")
@software.amazon.jsii.Jsii.Proxy(RedirectResponse.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RedirectResponse extends software.amazon.jsii.JsiiSerializable {

    /**
     * The HTTP redirect code (HTTP_301 or HTTP_302).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

    /**
     * The hostname.
     * <p>
     * This component is not percent-encoded. The hostname can contain #{host}.
     * <p>
     * Default: origin host of request
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHost() {
        return null;
    }

    /**
     * The absolute path, starting with the leading "/".
     * <p>
     * This component is not percent-encoded.
     * The path can contain #{host}, #{path}, and #{port}.
     * <p>
     * Default: origin path of request
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * The port.
     * <p>
     * You can specify a value from 1 to 65535 or #{port}.
     * <p>
     * Default: origin port of request
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
        return null;
    }

    /**
     * The protocol.
     * <p>
     * You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP,
     * HTTP to HTTPS, and HTTPS to HTTPS. You cannot redirect HTTPS to HTTP.
     * <p>
     * Default: origin protocol of request
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
        return null;
    }

    /**
     * The query parameters, URL-encoded when necessary, but not percent-encoded.
     * <p>
     * Do not include the leading "?", as it is automatically added.
     * You can specify any of the reserved keywords.
     * <p>
     * Default: origin query string of request
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQuery() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RedirectResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RedirectResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RedirectResponse> {
        private java.lang.String statusCode;
        private java.lang.String host;
        private java.lang.String path;
        private java.lang.String port;
        private java.lang.String protocol;
        private java.lang.String query;

        /**
         * Sets the value of {@link RedirectResponse#getStatusCode}
         * @param statusCode The HTTP redirect code (HTTP_301 or HTTP_302). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statusCode(java.lang.String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Sets the value of {@link RedirectResponse#getHost}
         * @param host The hostname.
         *             This component is not percent-encoded. The hostname can contain #{host}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder host(java.lang.String host) {
            this.host = host;
            return this;
        }

        /**
         * Sets the value of {@link RedirectResponse#getPath}
         * @param path The absolute path, starting with the leading "/".
         *             This component is not percent-encoded.
         *             The path can contain #{host}, #{path}, and #{port}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link RedirectResponse#getPort}
         * @param port The port.
         *             You can specify a value from 1 to 65535 or #{port}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.String port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link RedirectResponse#getProtocol}
         * @param protocol The protocol.
         *                 You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP,
         *                 HTTP to HTTPS, and HTTPS to HTTPS. You cannot redirect HTTPS to HTTP.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link RedirectResponse#getQuery}
         * @param query The query parameters, URL-encoded when necessary, but not percent-encoded.
         *              Do not include the leading "?", as it is automatically added.
         *              You can specify any of the reserved keywords.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder query(java.lang.String query) {
            this.query = query;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RedirectResponse}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RedirectResponse build() {
            return new Jsii$Proxy(statusCode, host, path, port, protocol, query);
        }
    }

    /**
     * An implementation for {@link RedirectResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedirectResponse {
        private final java.lang.String statusCode;
        private final java.lang.String host;
        private final java.lang.String path;
        private final java.lang.String port;
        private final java.lang.String protocol;
        private final java.lang.String query;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.statusCode = this.jsiiGet("statusCode", java.lang.String.class);
            this.host = this.jsiiGet("host", java.lang.String.class);
            this.path = this.jsiiGet("path", java.lang.String.class);
            this.port = this.jsiiGet("port", java.lang.String.class);
            this.protocol = this.jsiiGet("protocol", java.lang.String.class);
            this.query = this.jsiiGet("query", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String statusCode, final java.lang.String host, final java.lang.String path, final java.lang.String port, final java.lang.String protocol, final java.lang.String query) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.statusCode = java.util.Objects.requireNonNull(statusCode, "statusCode is required");
            this.host = host;
            this.path = path;
            this.port = port;
            this.protocol = protocol;
            this.query = query;
        }

        @Override
        public java.lang.String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public java.lang.String getHost() {
            return this.host;
        }

        @Override
        public java.lang.String getPath() {
            return this.path;
        }

        @Override
        public java.lang.String getPort() {
            return this.port;
        }

        @Override
        public java.lang.String getProtocol() {
            return this.protocol;
        }

        @Override
        public java.lang.String getQuery() {
            return this.query;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("statusCode", om.valueToTree(this.getStatusCode()));
            if (this.getHost() != null) {
                data.set("host", om.valueToTree(this.getHost()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getQuery() != null) {
                data.set("query", om.valueToTree(this.getQuery()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.RedirectResponse"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RedirectResponse.Jsii$Proxy that = (RedirectResponse.Jsii$Proxy) o;

            if (!statusCode.equals(that.statusCode)) return false;
            if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            return this.query != null ? this.query.equals(that.query) : that.query == null;
        }

        @Override
        public int hashCode() {
            int result = this.statusCode.hashCode();
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
            return result;
        }
    }
}
