package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding a new target group to a listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-31T23:31:38.090Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.AddApplicationTargetGroupsProps")
@software.amazon.jsii.Jsii.Proxy(AddApplicationTargetGroupsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddApplicationTargetGroupsProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.AddRuleProps {

    /**
     * Target groups to forward requests to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups();

    /**
     * @return a {@link Builder} of {@link AddApplicationTargetGroupsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddApplicationTargetGroupsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddApplicationTargetGroupsProps> {
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions;
        private java.lang.String hostHeader;
        private java.lang.String pathPattern;
        private java.util.List<java.lang.String> pathPatterns;
        private java.lang.Number priority;

        /**
         * Sets the value of {@link AddApplicationTargetGroupsProps#getTargetGroups}
         * @param targetGroups Target groups to forward requests to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroups(java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups) {
            this.targetGroups = targetGroups;
            return this;
        }

        /**
         * Sets the value of {@link AddApplicationTargetGroupsProps#getConditions}
         * @param conditions Rule applies if matches the conditions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions) {
            this.conditions = conditions;
            return this;
        }

        /**
         * Sets the value of {@link AddApplicationTargetGroupsProps#getHostHeader}
         * @param hostHeader Rule applies if the requested host matches the indicated host.
         *                   May contain up to three '*' wildcards.
         *                   <p>
         *                   Requires that priority is set.
         * @return {@code this}
         * @deprecated Use `conditions` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder hostHeader(java.lang.String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        /**
         * Sets the value of {@link AddApplicationTargetGroupsProps#getPathPattern}
         * @param pathPattern Rule applies if the requested path matches the given path pattern.
         *                    May contain up to three '*' wildcards.
         *                    <p>
         *                    Requires that priority is set.
         * @return {@code this}
         * @deprecated Use `conditions` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pathPattern(java.lang.String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        /**
         * Sets the value of {@link AddApplicationTargetGroupsProps#getPathPatterns}
         * @param pathPatterns Rule applies if the requested path matches any of the given patterns.
         *                     May contain up to three '*' wildcards.
         *                     <p>
         *                     Requires that priority is set.
         * @return {@code this}
         * @deprecated Use `conditions` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pathPatterns(java.util.List<java.lang.String> pathPatterns) {
            this.pathPatterns = pathPatterns;
            return this;
        }

        /**
         * Sets the value of {@link AddApplicationTargetGroupsProps#getPriority}
         * @param priority Priority of this target group.
         *                 The rule with the lowest priority will be used for every request.
         *                 If priority is not given, these target groups will be added as
         *                 defaults, and must not have conditions.
         *                 <p>
         *                 Priorities must be unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddApplicationTargetGroupsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddApplicationTargetGroupsProps build() {
            return new Jsii$Proxy(targetGroups, conditions, hostHeader, pathPattern, pathPatterns, priority);
        }
    }

    /**
     * An implementation for {@link AddApplicationTargetGroupsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddApplicationTargetGroupsProps {
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions;
        private final java.lang.String hostHeader;
        private final java.lang.String pathPattern;
        private final java.util.List<java.lang.String> pathPatterns;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.targetGroups = this.jsiiGet("targetGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup.class)));
            this.conditions = this.jsiiGet("conditions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition.class)));
            this.hostHeader = this.jsiiGet("hostHeader", java.lang.String.class);
            this.pathPattern = this.jsiiGet("pathPattern", java.lang.String.class);
            this.pathPatterns = this.jsiiGet("pathPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.priority = this.jsiiGet("priority", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups, final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions, final java.lang.String hostHeader, final java.lang.String pathPattern, final java.util.List<java.lang.String> pathPatterns, final java.lang.Number priority) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.targetGroups = java.util.Objects.requireNonNull(targetGroups, "targetGroups is required");
            this.conditions = conditions;
            this.hostHeader = hostHeader;
            this.pathPattern = pathPattern;
            this.pathPatterns = pathPatterns;
            this.priority = priority;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
            return this.targetGroups;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> getConditions() {
            return this.conditions;
        }

        @Override
        public java.lang.String getHostHeader() {
            return this.hostHeader;
        }

        @Override
        public java.lang.String getPathPattern() {
            return this.pathPattern;
        }

        @Override
        public java.util.List<java.lang.String> getPathPatterns() {
            return this.pathPatterns;
        }

        @Override
        public java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("targetGroups", om.valueToTree(this.getTargetGroups()));
            if (this.getConditions() != null) {
                data.set("conditions", om.valueToTree(this.getConditions()));
            }
            if (this.getHostHeader() != null) {
                data.set("hostHeader", om.valueToTree(this.getHostHeader()));
            }
            if (this.getPathPattern() != null) {
                data.set("pathPattern", om.valueToTree(this.getPathPattern()));
            }
            if (this.getPathPatterns() != null) {
                data.set("pathPatterns", om.valueToTree(this.getPathPatterns()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.AddApplicationTargetGroupsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddApplicationTargetGroupsProps.Jsii$Proxy that = (AddApplicationTargetGroupsProps.Jsii$Proxy) o;

            if (!targetGroups.equals(that.targetGroups)) return false;
            if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) return false;
            if (this.hostHeader != null ? !this.hostHeader.equals(that.hostHeader) : that.hostHeader != null) return false;
            if (this.pathPattern != null ? !this.pathPattern.equals(that.pathPattern) : that.pathPattern != null) return false;
            if (this.pathPatterns != null ? !this.pathPatterns.equals(that.pathPatterns) : that.pathPatterns != null) return false;
            return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
        }

        @Override
        public int hashCode() {
            int result = this.targetGroups.hashCode();
            result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
            result = 31 * result + (this.hostHeader != null ? this.hostHeader.hashCode() : 0);
            result = 31 * result + (this.pathPattern != null ? this.pathPattern.hashCode() : 0);
            result = 31 * result + (this.pathPatterns != null ? this.pathPatterns.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }
    }
}
