package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::LoadBalancer`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-27T17:33:38.391Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnLoadBalancerProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.IpAddressType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-ipaddresstype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getIpAddressType();

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.LoadBalancerAttributes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getLoadBalancerAttributes();

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getName();

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Scheme`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-scheme
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getScheme();

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SecurityGroups`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<java.lang.String> getSecurityGroups();

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SubnetMappings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getSubnetMappings();

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Subnets`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<java.lang.String> getSubnets();

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Type`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getType();

    /**
     * @return a {@link Builder} of {@link CfnLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.String ipAddressType;
        private java.lang.Object loadBalancerAttributes;
        private java.lang.String name;
        private java.lang.String scheme;
        private java.util.List<java.lang.String> securityGroups;
        private java.lang.Object subnetMappings;
        private java.util.List<java.lang.String> subnets;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private java.lang.String type;

        /**
         * Sets the value of IpAddressType
         * @param ipAddressType `AWS::ElasticLoadBalancingV2::LoadBalancer.IpAddressType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ipAddressType(java.lang.String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of LoadBalancerAttributes
         * @param loadBalancerAttributes `AWS::ElasticLoadBalancingV2::LoadBalancer.LoadBalancerAttributes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder loadBalancerAttributes(software.amazon.awscdk.core.IResolvable loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes;
            return this;
        }

        /**
         * Sets the value of LoadBalancerAttributes
         * @param loadBalancerAttributes `AWS::ElasticLoadBalancingV2::LoadBalancer.LoadBalancerAttributes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder loadBalancerAttributes(java.util.List<java.lang.Object> loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes;
            return this;
        }

        /**
         * Sets the value of Name
         * @param name `AWS::ElasticLoadBalancingV2::LoadBalancer.Name`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of Scheme
         * @param scheme `AWS::ElasticLoadBalancingV2::LoadBalancer.Scheme`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder scheme(java.lang.String scheme) {
            this.scheme = scheme;
            return this;
        }

        /**
         * Sets the value of SecurityGroups
         * @param securityGroups `AWS::ElasticLoadBalancingV2::LoadBalancer.SecurityGroups`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Sets the value of SubnetMappings
         * @param subnetMappings `AWS::ElasticLoadBalancingV2::LoadBalancer.SubnetMappings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder subnetMappings(software.amazon.awscdk.core.IResolvable subnetMappings) {
            this.subnetMappings = subnetMappings;
            return this;
        }

        /**
         * Sets the value of SubnetMappings
         * @param subnetMappings `AWS::ElasticLoadBalancingV2::LoadBalancer.SubnetMappings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder subnetMappings(java.util.List<java.lang.Object> subnetMappings) {
            this.subnetMappings = subnetMappings;
            return this;
        }

        /**
         * Sets the value of Subnets
         * @param subnets `AWS::ElasticLoadBalancingV2::LoadBalancer.Subnets`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder subnets(java.util.List<java.lang.String> subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::ElasticLoadBalancingV2::LoadBalancer.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of Type
         * @param type `AWS::ElasticLoadBalancingV2::LoadBalancer.Type`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnLoadBalancerProps build() {
            return new Jsii$Proxy(ipAddressType, loadBalancerAttributes, name, scheme, securityGroups, subnetMappings, subnets, tags, type);
        }

    }

    /**
     * An implementation for {@link CfnLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLoadBalancerProps {
        private final java.lang.String ipAddressType;
        private final java.lang.Object loadBalancerAttributes;
        private final java.lang.String name;
        private final java.lang.String scheme;
        private final java.util.List<java.lang.String> securityGroups;
        private final java.lang.Object subnetMappings;
        private final java.util.List<java.lang.String> subnets;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.String type;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.ipAddressType = this.jsiiGet("ipAddressType", java.lang.String.class);
            this.loadBalancerAttributes = this.jsiiGet("loadBalancerAttributes", java.lang.Object.class);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.scheme = this.jsiiGet("scheme", java.lang.String.class);
            this.securityGroups = this.jsiiGet("securityGroups", java.util.List.class);
            this.subnetMappings = this.jsiiGet("subnetMappings", java.lang.Object.class);
            this.subnets = this.jsiiGet("subnets", java.util.List.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
            this.type = this.jsiiGet("type", java.lang.String.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String ipAddressType, java.lang.Object loadBalancerAttributes, java.lang.String name, java.lang.String scheme, java.util.List<java.lang.String> securityGroups, java.lang.Object subnetMappings, java.util.List<java.lang.String> subnets, java.util.List<software.amazon.awscdk.core.CfnTag> tags, java.lang.String type) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ipAddressType = ipAddressType;
            this.loadBalancerAttributes = loadBalancerAttributes;
            this.name = name;
            this.scheme = scheme;
            this.securityGroups = securityGroups;
            this.subnetMappings = subnetMappings;
            this.subnets = subnets;
            this.tags = tags;
            this.type = type;
        }

        @Override
        public java.lang.String getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public java.lang.Object getLoadBalancerAttributes() {
            return this.loadBalancerAttributes;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public java.lang.String getScheme() {
            return this.scheme;
        }

        @Override
        public java.util.List<java.lang.String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public java.lang.Object getSubnetMappings() {
            return this.subnetMappings;
        }

        @Override
        public java.util.List<java.lang.String> getSubnets() {
            return this.subnets;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public java.lang.String getType() {
            return this.type;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getIpAddressType() != null) {
                obj.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getLoadBalancerAttributes() != null) {
                obj.set("loadBalancerAttributes", om.valueToTree(this.getLoadBalancerAttributes()));
            }
            if (this.getName() != null) {
                obj.set("name", om.valueToTree(this.getName()));
            }
            if (this.getScheme() != null) {
                obj.set("scheme", om.valueToTree(this.getScheme()));
            }
            if (this.getSecurityGroups() != null) {
                obj.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnetMappings() != null) {
                obj.set("subnetMappings", om.valueToTree(this.getSubnetMappings()));
            }
            if (this.getSubnets() != null) {
                obj.set("subnets", om.valueToTree(this.getSubnets()));
            }
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getType() != null) {
                obj.set("type", om.valueToTree(this.getType()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLoadBalancerProps.Jsii$Proxy that = (CfnLoadBalancerProps.Jsii$Proxy) o;

            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            if (this.loadBalancerAttributes != null ? !this.loadBalancerAttributes.equals(that.loadBalancerAttributes) : that.loadBalancerAttributes != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.subnetMappings != null ? !this.subnetMappings.equals(that.subnetMappings) : that.subnetMappings != null) return false;
            if (this.subnets != null ? !this.subnets.equals(that.subnets) : that.subnets != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.type != null ? this.type.equals(that.type) : that.type == null;
        }

        @Override
        public int hashCode() {
            int result = this.ipAddressType != null ? this.ipAddressType.hashCode() : 0;
            result = 31 * result + (this.loadBalancerAttributes != null ? this.loadBalancerAttributes.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.scheme != null ? this.scheme.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnetMappings != null ? this.subnetMappings.hashCode() : 0);
            result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }

    }
}
