package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding a conditional load balancing rule.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.2 (build dfe9aaf)", date = "2019-08-29T13:51:03.673Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddRuleProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Rule applies if the requested host matches the indicated host.
     * 
     * May contain up to three '*' wildcards.
     * 
     * Requires that priority is set.
     * 
     * Default: No host condition
     * 
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getHostHeader();

    /**
     * Rule applies if the requested path matches the given path pattern.
     * 
     * May contain up to three '*' wildcards.
     * 
     * Requires that priority is set.
     * 
     * Default: No path condition
     * 
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPathPattern();

    /**
     * Priority of this target group.
     * 
     * The rule with the lowest priority will be used for every request.
     * If priority is not given, these target groups will be added as
     * defaults, and must not have conditions.
     * 
     * Priorities must be unique.
     * 
     * Default: Target groups are used as defaults
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getPriority();

    /**
     * @return a {@link Builder} of {@link AddRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AddRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String hostHeader;
        private java.lang.String pathPattern;
        private java.lang.Number priority;

        /**
         * Sets the value of HostHeader
         * @param hostHeader Rule applies if the requested host matches the indicated host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostHeader(java.lang.String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        /**
         * Sets the value of PathPattern
         * @param pathPattern Rule applies if the requested path matches the given path pattern.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathPattern(java.lang.String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        /**
         * Sets the value of Priority
         * @param priority Priority of this target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AddRuleProps build() {
            return new Jsii$Proxy(hostHeader, pathPattern, priority);
        }

    }

    /**
     * An implementation for {@link AddRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddRuleProps {
        private final java.lang.String hostHeader;
        private final java.lang.String pathPattern;
        private final java.lang.Number priority;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.hostHeader = this.jsiiGet("hostHeader", java.lang.String.class);
            this.pathPattern = this.jsiiGet("pathPattern", java.lang.String.class);
            this.priority = this.jsiiGet("priority", java.lang.Number.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String hostHeader, java.lang.String pathPattern, java.lang.Number priority) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostHeader = hostHeader;
            this.pathPattern = pathPattern;
            this.priority = priority;
        }

        @Override
        public java.lang.String getHostHeader() {
            return this.hostHeader;
        }

        @Override
        public java.lang.String getPathPattern() {
            return this.pathPattern;
        }

        @Override
        public java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getHostHeader() != null) {
                obj.set("hostHeader", om.valueToTree(this.getHostHeader()));
            }
            if (this.getPathPattern() != null) {
                obj.set("pathPattern", om.valueToTree(this.getPathPattern()));
            }
            if (this.getPriority() != null) {
                obj.set("priority", om.valueToTree(this.getPriority()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddRuleProps.Jsii$Proxy that = (AddRuleProps.Jsii$Proxy) o;

            if (this.hostHeader != null ? !this.hostHeader.equals(that.hostHeader) : that.hostHeader != null) return false;
            if (this.pathPattern != null ? !this.pathPattern.equals(that.pathPattern) : that.pathPattern != null) return false;
            return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
        }

        @Override
        public int hashCode() {
            int result = this.hostHeader != null ? this.hostHeader.hashCode() : 0;
            result = 31 * result + (this.pathPattern != null ? this.pathPattern.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }

    }
}
