package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.2 (build dfe9aaf)", date = "2019-08-29T13:51:03.677Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationListenerAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * ARN of the listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getListenerArn();

    /**
     * Security group ID of the load balancer this listener is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getSecurityGroupId();

    /**
     * The default port on which this listener is listening.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getDefaultPort();

    /**
     * Whether the security group allows all outbound traffic or not.
     * 
     * Unless set to `false`, no egress rules will be added to the security group.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getSecurityGroupAllowsAllOutbound();

    /**
     * @return a {@link Builder} of {@link ApplicationListenerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationListenerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String listenerArn;
        private java.lang.String securityGroupId;
        private java.lang.Number defaultPort;
        private java.lang.Boolean securityGroupAllowsAllOutbound;

        /**
         * Sets the value of ListenerArn
         * @param listenerArn ARN of the listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerArn(java.lang.String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        /**
         * Sets the value of SecurityGroupId
         * @param securityGroupId Security group ID of the load balancer this listener is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupId(java.lang.String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        /**
         * Sets the value of DefaultPort
         * @param defaultPort The default port on which this listener is listening.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultPort(java.lang.Number defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        /**
         * Sets the value of SecurityGroupAllowsAllOutbound
         * @param securityGroupAllowsAllOutbound Whether the security group allows all outbound traffic or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupAllowsAllOutbound(java.lang.Boolean securityGroupAllowsAllOutbound) {
            this.securityGroupAllowsAllOutbound = securityGroupAllowsAllOutbound;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationListenerAttributes build() {
            return new Jsii$Proxy(listenerArn, securityGroupId, defaultPort, securityGroupAllowsAllOutbound);
        }

    }

    /**
     * An implementation for {@link ApplicationListenerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationListenerAttributes {
        private final java.lang.String listenerArn;
        private final java.lang.String securityGroupId;
        private final java.lang.Number defaultPort;
        private final java.lang.Boolean securityGroupAllowsAllOutbound;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.listenerArn = this.jsiiGet("listenerArn", java.lang.String.class);
            this.securityGroupId = this.jsiiGet("securityGroupId", java.lang.String.class);
            this.defaultPort = this.jsiiGet("defaultPort", java.lang.Number.class);
            this.securityGroupAllowsAllOutbound = this.jsiiGet("securityGroupAllowsAllOutbound", java.lang.Boolean.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String listenerArn, java.lang.String securityGroupId, java.lang.Number defaultPort, java.lang.Boolean securityGroupAllowsAllOutbound) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listenerArn = java.util.Objects.requireNonNull(listenerArn, "listenerArn is required");
            this.securityGroupId = java.util.Objects.requireNonNull(securityGroupId, "securityGroupId is required");
            this.defaultPort = defaultPort;
            this.securityGroupAllowsAllOutbound = securityGroupAllowsAllOutbound;
        }

        @Override
        public java.lang.String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public java.lang.String getSecurityGroupId() {
            return this.securityGroupId;
        }

        @Override
        public java.lang.Number getDefaultPort() {
            return this.defaultPort;
        }

        @Override
        public java.lang.Boolean getSecurityGroupAllowsAllOutbound() {
            return this.securityGroupAllowsAllOutbound;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("listenerArn", om.valueToTree(this.getListenerArn()));
            obj.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));
            if (this.getDefaultPort() != null) {
                obj.set("defaultPort", om.valueToTree(this.getDefaultPort()));
            }
            if (this.getSecurityGroupAllowsAllOutbound() != null) {
                obj.set("securityGroupAllowsAllOutbound", om.valueToTree(this.getSecurityGroupAllowsAllOutbound()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationListenerAttributes.Jsii$Proxy that = (ApplicationListenerAttributes.Jsii$Proxy) o;

            if (!listenerArn.equals(that.listenerArn)) return false;
            if (!securityGroupId.equals(that.securityGroupId)) return false;
            if (this.defaultPort != null ? !this.defaultPort.equals(that.defaultPort) : that.defaultPort != null) return false;
            return this.securityGroupAllowsAllOutbound != null ? this.securityGroupAllowsAllOutbound.equals(that.securityGroupAllowsAllOutbound) : that.securityGroupAllowsAllOutbound == null;
        }

        @Override
        public int hashCode() {
            int result = this.listenerArn.hashCode();
            result = 31 * result + (this.securityGroupId.hashCode());
            result = 31 * result + (this.defaultPort != null ? this.defaultPort.hashCode() : 0);
            result = 31 * result + (this.securityGroupAllowsAllOutbound != null ? this.securityGroupAllowsAllOutbound.hashCode() : 0);
            return result;
        }

    }
}
