/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancerProps;
import software.amazon.jsii.JsiiSerializable;

public interface BaseLoadBalancerProps
extends JsiiSerializable {
    public IVpc getVpc();

    public Boolean getDeletionProtection();

    public Boolean getInternetFacing();

    public String getLoadBalancerName();

    public SubnetSelection getVpcSubnets();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IVpc vpc;
        private Boolean deletionProtection;
        private Boolean internetFacing;
        private String loadBalancerName;
        private SubnetSelection vpcSubnets;

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public Builder internetFacing(Boolean internetFacing) {
            this.internetFacing = internetFacing;
            return this;
        }

        public Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public BaseLoadBalancerProps build() {
            return new Jsii.Proxy(this.vpc, this.deletionProtection, this.internetFacing, this.loadBalancerName, this.vpcSubnets, null);
        }
    }
}

