package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-08-28T10:19:26.099Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.IApplicationListener")
@software.amazon.jsii.Jsii.Proxy(IApplicationListener.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IApplicationListener extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource, software.amazon.awscdk.services.ec2.IConnectable {

    /**
     * ARN of the listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getListenerArn();

    /**
     * Add one or more certificates to this listener.
     * <p>
     * @param id This parameter is required.
     * @param arns This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addCertificateArns(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> arns);

    /**
     * Load balance incoming requests to the given target groups.
     * <p>
     * It's possible to add conditions to the TargetGroups added in this way.
     * At least one TargetGroup must be added without conditions.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addTargetGroups(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetGroupsProps props);

    /**
     * Load balance incoming requests to the given load balancing targets.
     * <p>
     * This method implicitly creates an ApplicationTargetGroup for the targets
     * involved.
     * <p>
     * It's possible to add conditions to the targets added in this way. At least
     * one set of targets must be added without conditions.
     * <p>
     * @return The newly created target group
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup addTargets(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetsProps props);

    /**
     * Register that a connectable that has been added to this load balancer.
     * <p>
     * Don't call this directly. It is called by ApplicationTargetGroup.
     * <p>
     * @param connectable This parameter is required.
     * @param portRange This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void registerConnectable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable connectable, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port portRange);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * ARN of the listener.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getListenerArn() {
            return this.jsiiGet("listenerArn", java.lang.String.class);
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return this.jsiiGet("env", software.amazon.awscdk.core.ResourceEnvironment.class);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
        }

        /**
         * Add one or more certificates to this listener.
         * <p>
         * @param id This parameter is required.
         * @param arns This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void addCertificateArns(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> arns) {
            this.jsiiCall("addCertificateArns", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(arns, "arns is required") });
        }

        /**
         * Load balance incoming requests to the given target groups.
         * <p>
         * It's possible to add conditions to the TargetGroups added in this way.
         * At least one TargetGroup must be added without conditions.
         * <p>
         * @param id This parameter is required.
         * @param props This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void addTargetGroups(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetGroupsProps props) {
            this.jsiiCall("addTargetGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
        }

        /**
         * Load balance incoming requests to the given load balancing targets.
         * <p>
         * This method implicitly creates an ApplicationTargetGroup for the targets
         * involved.
         * <p>
         * It's possible to add conditions to the targets added in this way. At least
         * one set of targets must be added without conditions.
         * <p>
         * @return The newly created target group
         * @param id This parameter is required.
         * @param props This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup addTargets(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetsProps props) {
            return this.jsiiCall("addTargets", software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
        }

        /**
         * Register that a connectable that has been added to this load balancer.
         * <p>
         * Don't call this directly. It is called by ApplicationTargetGroup.
         * <p>
         * @param connectable This parameter is required.
         * @param portRange This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void registerConnectable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable connectable, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port portRange) {
            this.jsiiCall("registerConnectable", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(connectable, "connectable is required"), java.util.Objects.requireNonNull(portRange, "portRange is required") });
        }
    }
}
