/**
 * <h2>Amazon Elastic Load Balancing V2 Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * The <code>&#64;aws-cdk/aws-elasticloadbalancingv2</code> package provides constructs for
 * configuring application and network load balancers.
 * <p>
 * For more information, see the AWS documentation for
 * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/introduction.html">Application Load Balancers</a>
 * and <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/introduction.html">Network Load Balancers</a>.
 * <p>
 * <h3>Defining an Application Load Balancer</h3>
 * <p>
 * You define an application load balancer by creating an instance of
 * <code>ApplicationLoadBalancer</code>, adding a Listener to the load balancer
 * and adding Targets to the Listener:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * import software.amazon.awscdk.services.autoscaling.AutoScalingGroup;
 * 
 * // ...
 * 
 * Vpc vpc = new Vpc(...);
 * 
 * // Create the load balancer in a VPC. 'internetFacing' is 'false'
 * // by default, which creates an internal load balancer.
 * ApplicationLoadBalancer lb = new ApplicationLoadBalancer(this, "LB", new ApplicationLoadBalancerProps()
 *         .vpc(vpc)
 *         .internetFacing(true));
 * 
 * // Add a listener and open up the load balancer's security group
 * // to the world.
 * ApplicationListener listener = lb.addListener("Listener", new BaseApplicationListenerProps()
 *         .port(80)
 * 
 *         // 'open: true' is the default, you can leave it out if you want. Set it
 *         // to 'false' and use `listener.connections` if you want to be selective
 *         // about who can access the load balancer.
 *         .open(true));
 * 
 * // Create an AutoScaling group and add it as a load balancing
 * // target to the listener.
 * AutoScalingGroup asg = new AutoScalingGroup(...);
 * listener.addTargets("ApplicationFleet", new AddApplicationTargetsProps()
 *         .port(8080)
 *         .targets(asList(asg)));
 * </pre></blockquote>
 * <p>
 * The security groups of the load balancer and the target are automatically
 * updated to allow the network traffic.
 * <p>
 * <h4>Conditions</h4>
 * <p>
 * It's possible to route traffic to targets based on conditions in the incoming
 * HTTP request. For example, the following will route requests to the indicated
 * AutoScalingGroup only if the requested host in the request is either for
 * <code>example.com/ok</code> or <code>example.com/path</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * listener.addTargets("Example.Com Fleet", Map.of(
 *         "priority", 10,
 *         "conditions", asList(ListenerCondition.hostHeaders(asList("example.com")), ListenerCondition.pathPatterns(asList("/ok", "/path"))),
 *         "port", 8080,
 *         "targets", asList(asg)));
 * </pre></blockquote>
 * <p>
 * A target with a condition contains either <code>pathPatterns</code> or <code>hostHeader</code>, or
 * both. If both are specified, both conditions must be met for the requests to
 * be routed to the given target. <code>priority</code> is a required field when you add
 * targets with conditions. The lowest number wins.
 * <p>
 * Every listener must have at least one target without conditions, which is
 * where all requests that didn't match any of the conditions will be sent.
 * <p>
 * <h4>Convenience methods and more complex Actions</h4>
 * <p>
 * Routing traffic from a Load Balancer to a Target involves the following steps:
 * <p>
 * <ul>
 * <li>Create a Target Group, register the Target into the Target Group</li>
 * <li>Add an Action to the Listener which forwards traffic to the Target Group.</li>
 * </ul>
 * <p>
 * Various methods on the <code>Listener</code> take care of this work for you to a greater
 * or lesser extent:
 * <p>
 * <ul>
 * <li><code>addTargets()</code> performs both steps: automatically creates a Target Group and the
 * required Action.</li>
 * <li><code>addTargetGroups()</code> gives you more control: you create the Target Group (or
 * Target Groups) yourself and the method creates Action that routes traffic to
 * the Target Groups.</li>
 * <li><code>addAction()</code> gives you full control: you supply the Action and wire it up
 * to the Target Groups yourself (or access one of the other ELB routing features).</li>
 * </ul>
 * <p>
 * Using <code>addAction()</code> gives you access to some of the features of an Elastic Load
 * Balancer that the other two convenience methods don't:
 * <p>
 * <ul>
 * <li><strong>Routing stickiness</strong>: use <code>ListenerAction.forward()</code> and supply a
 * <code>stickinessDuration</code> to make sure requests are routed to the same target group
 * for a given duration.</li>
 * <li><strong>Weighted Target Groups</strong>: use <code>ListenerAction.weightedForward()</code>
 * to give different weights to different target groups.</li>
 * <li><strong>Fixed Responses</strong>: use <code>ListenerAction.fixedResponse()</code> to serve
 * a static response (ALB only).</li>
 * <li><strong>Redirects</strong>: use <code>ListenerAction.redirect()</code> to serve an HTTP
 * redirect response (ALB only).</li>
 * <li><strong>Authentication</strong>: use <code>ListenerAction.authenticateOidc()</code> to
 * perform OpenID authentication before serving a request (see the
 * <code>&#64;aws-cdk/aws-elasticloadbalancingv2-actions</code> package for direct authentication
 * integration with Cognito) (ALB only).</li>
 * </ul>
 * <p>
 * Here's an example of serving a fixed response at the <code>/ok</code> URL:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * listener.addAction("Fixed", Map.of(
 *         "priority", 10,
 *         "conditions", asList(ListenerCondition.pathPatterns(asList("/ok"))),
 *         "action", ListenerAction.fixedResponse(200, Map.of(
 *                 "contentType", elbv2.ContentType.getTEXT_PLAIN(),
 *                 "messageBody", "OK"))));
 * </pre></blockquote>
 * <p>
 * Here's an example of using OIDC authentication before forwarding to a TargetGroup:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * listener.addAction("DefaultAction", Map.of(
 *         "action", ListenerAction.authenticateOidc(Map.of(
 *                 "authorizationEndpoint", "https://example.com/openid",
 *                 // Other OIDC properties here
 *                 // ...
 *                 "next", ListenerAction.forward(asList(myTargetGroup))))));
 * </pre></blockquote>
 * <p>
 * <h3>Defining a Network Load Balancer</h3>
 * <p>
 * Network Load Balancers are defined in a similar way to Application Load
 * Balancers:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * import software.amazon.awscdk.services.autoscaling.*;
 * 
 * // Create the load balancer in a VPC. 'internetFacing' is 'false'
 * // by default, which creates an internal load balancer.
 * NetworkLoadBalancer lb = new NetworkLoadBalancer(this, "LB", new NetworkLoadBalancerProps()
 *         .vpc(vpc)
 *         .internetFacing(true));
 * 
 * // Add a listener on a particular port.
 * NetworkListener listener = lb.addListener("Listener", new BaseNetworkListenerProps()
 *         .port(443));
 * 
 * // Add targets on a particular port.
 * listener.addTargets("AppFleet", new AddNetworkTargetsProps()
 *         .port(443)
 *         .targets(asList(asg)));
 * </pre></blockquote>
 * <p>
 * One thing to keep in mind is that network load balancers do not have security
 * groups, and no automatic security group configuration is done for you. You will
 * have to configure the security groups of the target yourself to allow traffic by
 * clients and/or load balancer instances, depending on your target types.  See
 * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html">Target Groups for your Network Load
 * Balancers</a>
 * and <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/target-group-register-targets.html">Register targets with your Target
 * Group</a>
 * for more information.
 * <p>
 * <h3>Targets and Target Groups</h3>
 * <p>
 * Application and Network Load Balancers organize load balancing targets in Target
 * Groups. If you add your balancing targets (such as AutoScalingGroups, ECS
 * services or individual instances) to your listener directly, the appropriate
 * <code>TargetGroup</code> will be automatically created for you.
 * <p>
 * If you need more control over the Target Groups created, create an instance of
 * <code>ApplicationTargetGroup</code> or <code>NetworkTargetGroup</code>, add the members you desire,
 * and add it to the listener by calling <code>addTargetGroups</code> instead of <code>addTargets</code>.
 * <p>
 * <code>addTargets()</code> will always return the Target Group it just created for you:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var group = listener.addTargets("AppFleet", Map.of(
 *         "port", 443,
 *         "targets", asList(asg1)));
 * 
 * group.addTarget(asg2);
 * </pre></blockquote>
 * <p>
 * <h3>Using Lambda Targets</h3>
 * <p>
 * To use a Lambda Function as a target, use the integration class in the
 * <code>&#64;aws-cdk/aws-elasticloadbalancingv2-targets</code> package:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.targets.*;
 * 
 * Function lambdaFunction = new Function(...);
 * ApplicationLoadBalancer lb = new ApplicationLoadBalancer(...);
 * 
 * ApplicationListener listener = lb.addListener("Listener", new BaseApplicationListenerProps().port(80));
 * listener.addTargets("Targets", new AddApplicationTargetsProps()
 *         .targets(asList(new LambdaTarget(lambdaFunction)))
 * 
 *         // For Lambda Targets, you need to explicitly enable health checks if you
 *         // want them.
 *         .healthCheck(new HealthCheck()
 *                 .enabled(true)));
 * </pre></blockquote>
 * <p>
 * Only a single Lambda function can be added to a single listener rule.
 * <p>
 * <h3>Configuring Health Checks</h3>
 * <p>
 * Health checks are configured upon creation of a target group:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * listener.addTargets("AppFleet", Map.of(
 *         "port", 8080,
 *         "targets", asList(asg),
 *         "healthCheck", Map.of(
 *                 "path", "/ping",
 *                 "interval", cdk.Duration.minutes(1))));
 * </pre></blockquote>
 * <p>
 * The health check can also be configured after creation by calling
 * <code>configureHealthCheck()</code> on the created object.
 * <p>
 * No attempts are made to configure security groups for the port you're
 * configuring a health check for, but if the health check is on the same port
 * you're routing traffic to, the security group already allows the traffic.
 * If not, you will have to configure the security groups appropriately:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * listener.addTargets("AppFleet", Map.of(
 *         "port", 8080,
 *         "targets", asList(asg),
 *         "healthCheck", Map.of(
 *                 "port", 8088)));
 * 
 * listener.connections.allowFrom(lb, ec2.Port.tcp(8088));
 * </pre></blockquote>
 * <p>
 * <h3>Using a Load Balancer from a different Stack</h3>
 * <p>
 * If you want to put your Load Balancer and the Targets it is load balancing to in
 * different stacks, you may not be able to use the convenience methods
 * <code>loadBalancer.addListener()</code> and <code>listener.addTargets()</code>.
 * <p>
 * The reason is that these methods will create resources in the same Stack as the
 * object they're called on, which may lead to cyclic references between stacks.
 * Instead, you will have to create an <code>ApplicationListener</code> in the target stack,
 * or an empty <code>TargetGroup</code> in the load balancer stack that you attach your
 * service to.
 * <p>
 * For an example of the alternatives while load balancing to an ECS service, see the
 * <a href="https://github.com/aws-samples/aws-cdk-examples/tree/master/typescript/ecs/cross-stack-load-balancer/">ecs/cross-stack-load-balancer
 * example</a>.
 * <p>
 * <h3>Protocol for Load Balancer Targets</h3>
 * <p>
 * Constructs that want to be a load balancer target should implement
 * <code>IApplicationLoadBalancerTarget</code> and/or <code>INetworkLoadBalancerTarget</code>, and
 * provide an implementation for the function <code>attachToXxxTargetGroup()</code>, which can
 * call functions on the load balancer and should return metadata about the
 * load balancing target:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * attachToApplicationTargetGroup(targetGroup, ApplicationTargetGroup);LoadBalancerTargetProps;{
 *     targetGroup.registerConnectable(...);return Map.of(
 *             "targetType", TargetType.getInstance() | TargetType.getIp(),
 *             "targetJson", Map.of("id", , ..., "port", , ...))
 * }
 * </pre></blockquote>
 * <p>
 * <code>targetType</code> should be one of <code>Instance</code> or <code>Ip</code>. If the target can be
 * directly added to the target group, <code>targetJson</code> should contain the <code>id</code> of
 * the target (either instance ID or IP address depending on the type) and
 * optionally a <code>port</code> or <code>availabilityZone</code> override.
 * <p>
 * Application load balancer targets can call <code>registerConnectable()</code> on the
 * target group to register themselves for addition to the load balancer's security
 * group rules.
 * <p>
 * If your load balancer target requires that the TargetGroup has been
 * associated with a LoadBalancer before registration can happen (such as is the
 * case for ECS Services for example), take a resource dependency on
 * <code>targetGroup.loadBalancerDependency()</code> as follows:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // Make sure that the listener has been created, and so the TargetGroup
 * // has been associated with the LoadBalancer, before 'resource' is created.
 * resourced.addDependency(targetGroup.loadBalancerDependency());
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.elasticloadbalancingv2;
