/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.elasticloadbalancingv2.$Module;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.Protocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupAttributes;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupBase;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupImportProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-elasticloadbalancingv2.NetworkTargetGroup")
public class NetworkTargetGroup
extends TargetGroupBase
implements INetworkTargetGroup {
    protected NetworkTargetGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkTargetGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public NetworkTargetGroup(@NotNull Construct scope, @NotNull String id, @NotNull NetworkTargetGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static INetworkTargetGroup fromTargetGroupAttributes(@NotNull Construct scope, @NotNull String id, @NotNull TargetGroupAttributes attrs) {
        return (INetworkTargetGroup)JsiiObject.jsiiStaticCall(NetworkTargetGroup.class, (String)"fromTargetGroupAttributes", INetworkTargetGroup.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Deprecated
    @NotNull
    public static INetworkTargetGroup doImport(@NotNull Construct scope, @NotNull String id, @NotNull TargetGroupImportProps props) {
        return (INetworkTargetGroup)JsiiObject.jsiiStaticCall(NetworkTargetGroup.class, (String)"import", INetworkTargetGroup.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void addTarget(INetworkLoadBalancerTarget ... targets) {
        this.jsiiCall("addTarget", NativeType.VOID, Arrays.stream(targets).toArray(Object[]::new));
    }

    @Override
    public void registerListener(@NotNull INetworkListener listener) {
        this.jsiiCall("registerListener", NativeType.VOID, new Object[]{Objects.requireNonNull(listener, "listener is required")});
    }

    @Override
    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)this.jsiiCall("validate", NativeType.listOf((NativeType)NativeType.forClass(String.class)), new Object[0]));
    }

    @Override
    @NotNull
    public String getFirstLoadBalancerFullName() {
        return (String)this.jsiiGet("firstLoadBalancerFullName", String.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<NetworkTargetGroup> {
        private final Construct scope;
        private final String id;
        private final NetworkTargetGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new NetworkTargetGroupProps.Builder();
        }

        public Builder deregistrationDelay(Duration deregistrationDelay) {
            this.props.deregistrationDelay(deregistrationDelay);
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        public Builder targetGroupName(String targetGroupName) {
            this.props.targetGroupName(targetGroupName);
            return this;
        }

        public Builder targetType(TargetType targetType) {
            this.props.targetType(targetType);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        public Builder proxyProtocolV2(Boolean proxyProtocolV2) {
            this.props.proxyProtocolV2(proxyProtocolV2);
            return this;
        }

        public Builder targets(List<? extends INetworkLoadBalancerTarget> targets) {
            this.props.targets(targets);
            return this;
        }

        public NetworkTargetGroup build() {
            return new NetworkTargetGroup(this.scope, this.id, this.props.build());
        }
    }
}

