package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding new network targets to a listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:09:25.120Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddNetworkTargetsProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The port on which the listener listens for requests.
     * 
     * Default: Determined from protocol if known
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getPort();

    /**
     * The amount of time for Elastic Load Balancing to wait before deregistering a target.
     * 
     * The range is 0-3600 seconds.
     * 
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getDeregistrationDelay();

    /**
     * Health check configuration.
     * 
     * Default: No health check
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck();

    /**
     * Indicates whether Proxy Protocol version 2 is enabled.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getProxyProtocolV2();

    /**
     * The name of the target group.
     * 
     * This name must be unique per region per account, can have a maximum of
     * 32 characters, must contain only alphanumeric characters or hyphens, and
     * must not begin or end with a hyphen.
     * 
     * Default: Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getTargetGroupName();

    /**
     * The targets to add to this target group.
     * 
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. If you use either `Instance` or `IPAddress` as targets, all
     * target must be of the same type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> getTargets();

    /**
     * @return a {@link Builder} of {@link AddNetworkTargetsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AddNetworkTargetsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.Number port;
        private software.amazon.awscdk.core.Duration deregistrationDelay;
        private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck;
        private java.lang.Boolean proxyProtocolV2;
        private java.lang.String targetGroupName;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> targets;

        /**
         * Sets the value of Port
         * @param port The port on which the listener listens for requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of DeregistrationDelay
         * @param deregistrationDelay The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deregistrationDelay(software.amazon.awscdk.core.Duration deregistrationDelay) {
            this.deregistrationDelay = deregistrationDelay;
            return this;
        }

        /**
         * Sets the value of HealthCheck
         * @param healthCheck Health check configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of ProxyProtocolV2
         * @param proxyProtocolV2 Indicates whether Proxy Protocol version 2 is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyProtocolV2(java.lang.Boolean proxyProtocolV2) {
            this.proxyProtocolV2 = proxyProtocolV2;
            return this;
        }

        /**
         * Sets the value of TargetGroupName
         * @param targetGroupName The name of the target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupName(java.lang.String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        /**
         * Sets the value of Targets
         * @param targets The targets to add to this target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddNetworkTargetsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AddNetworkTargetsProps build() {
            return new Jsii$Proxy(port, deregistrationDelay, healthCheck, proxyProtocolV2, targetGroupName, targets);
        }

    }

    /**
     * An implementation for {@link AddNetworkTargetsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddNetworkTargetsProps {
        private final java.lang.Number port;
        private final software.amazon.awscdk.core.Duration deregistrationDelay;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck;
        private final java.lang.Boolean proxyProtocolV2;
        private final java.lang.String targetGroupName;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> targets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.port = this.jsiiGet("port", java.lang.Number.class);
            this.deregistrationDelay = this.jsiiGet("deregistrationDelay", software.amazon.awscdk.core.Duration.class);
            this.healthCheck = this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
            this.proxyProtocolV2 = this.jsiiGet("proxyProtocolV2", java.lang.Boolean.class);
            this.targetGroupName = this.jsiiGet("targetGroupName", java.lang.String.class);
            this.targets = this.jsiiGet("targets", java.util.List.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Number port, software.amazon.awscdk.core.Duration deregistrationDelay, software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck, java.lang.Boolean proxyProtocolV2, java.lang.String targetGroupName, java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> targets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.port = java.util.Objects.requireNonNull(port, "port is required");
            this.deregistrationDelay = deregistrationDelay;
            this.healthCheck = healthCheck;
            this.proxyProtocolV2 = proxyProtocolV2;
            this.targetGroupName = targetGroupName;
            this.targets = targets;
        }

        @Override
        public java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public software.amazon.awscdk.core.Duration getDeregistrationDelay() {
            return this.deregistrationDelay;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public java.lang.Boolean getProxyProtocolV2() {
            return this.proxyProtocolV2;
        }

        @Override
        public java.lang.String getTargetGroupName() {
            return this.targetGroupName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> getTargets() {
            return this.targets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("port", om.valueToTree(this.getPort()));
            if (this.getDeregistrationDelay() != null) {
                obj.set("deregistrationDelay", om.valueToTree(this.getDeregistrationDelay()));
            }
            if (this.getHealthCheck() != null) {
                obj.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getProxyProtocolV2() != null) {
                obj.set("proxyProtocolV2", om.valueToTree(this.getProxyProtocolV2()));
            }
            if (this.getTargetGroupName() != null) {
                obj.set("targetGroupName", om.valueToTree(this.getTargetGroupName()));
            }
            if (this.getTargets() != null) {
                obj.set("targets", om.valueToTree(this.getTargets()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddNetworkTargetsProps.Jsii$Proxy that = (AddNetworkTargetsProps.Jsii$Proxy) o;

            if (!port.equals(that.port)) return false;
            if (this.deregistrationDelay != null ? !this.deregistrationDelay.equals(that.deregistrationDelay) : that.deregistrationDelay != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.proxyProtocolV2 != null ? !this.proxyProtocolV2.equals(that.proxyProtocolV2) : that.proxyProtocolV2 != null) return false;
            if (this.targetGroupName != null ? !this.targetGroupName.equals(that.targetGroupName) : that.targetGroupName != null) return false;
            return this.targets != null ? this.targets.equals(that.targets) : that.targets == null;
        }

        @Override
        public int hashCode() {
            int result = this.port.hashCode();
            result = 31 * result + (this.deregistrationDelay != null ? this.deregistrationDelay.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.proxyProtocolV2 != null ? this.proxyProtocolV2.hashCode() : 0);
            result = 31 * result + (this.targetGroupName != null ? this.targetGroupName.hashCode() : 0);
            result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
            return result;
        }

    }
}
