package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:09:25.129Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationLoadBalancerAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * ARN of the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getLoadBalancerArn();

    /**
     * ID of the load balancer's security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getSecurityGroupId();

    /**
     * The canonical hosted zone ID of this load balancer.
     * 
     * Default: - When not provided, LB cannot be used as Route53 Alias target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getLoadBalancerCanonicalHostedZoneId();

    /**
     * The DNS name of this load balancer.
     * 
     * Default: - When not provided, LB cannot be used as Route53 Alias target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getLoadBalancerDnsName();

    /**
     * Whether the security group allows all outbound traffic or not.
     * 
     * Unless set to `false`, no egress rules will be added to the security group.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getSecurityGroupAllowsAllOutbound();

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationLoadBalancerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String loadBalancerArn;
        private java.lang.String securityGroupId;
        private java.lang.String loadBalancerCanonicalHostedZoneId;
        private java.lang.String loadBalancerDnsName;
        private java.lang.Boolean securityGroupAllowsAllOutbound;

        /**
         * Sets the value of LoadBalancerArn
         * @param loadBalancerArn ARN of the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerArn(java.lang.String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        /**
         * Sets the value of SecurityGroupId
         * @param securityGroupId ID of the load balancer's security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupId(java.lang.String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        /**
         * Sets the value of LoadBalancerCanonicalHostedZoneId
         * @param loadBalancerCanonicalHostedZoneId The canonical hosted zone ID of this load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerCanonicalHostedZoneId(java.lang.String loadBalancerCanonicalHostedZoneId) {
            this.loadBalancerCanonicalHostedZoneId = loadBalancerCanonicalHostedZoneId;
            return this;
        }

        /**
         * Sets the value of LoadBalancerDnsName
         * @param loadBalancerDnsName The DNS name of this load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerDnsName(java.lang.String loadBalancerDnsName) {
            this.loadBalancerDnsName = loadBalancerDnsName;
            return this;
        }

        /**
         * Sets the value of SecurityGroupAllowsAllOutbound
         * @param securityGroupAllowsAllOutbound Whether the security group allows all outbound traffic or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupAllowsAllOutbound(java.lang.Boolean securityGroupAllowsAllOutbound) {
            this.securityGroupAllowsAllOutbound = securityGroupAllowsAllOutbound;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancerAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationLoadBalancerAttributes build() {
            return new Jsii$Proxy(loadBalancerArn, securityGroupId, loadBalancerCanonicalHostedZoneId, loadBalancerDnsName, securityGroupAllowsAllOutbound);
        }

    }

    /**
     * An implementation for {@link ApplicationLoadBalancerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationLoadBalancerAttributes {
        private final java.lang.String loadBalancerArn;
        private final java.lang.String securityGroupId;
        private final java.lang.String loadBalancerCanonicalHostedZoneId;
        private final java.lang.String loadBalancerDnsName;
        private final java.lang.Boolean securityGroupAllowsAllOutbound;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.loadBalancerArn = this.jsiiGet("loadBalancerArn", java.lang.String.class);
            this.securityGroupId = this.jsiiGet("securityGroupId", java.lang.String.class);
            this.loadBalancerCanonicalHostedZoneId = this.jsiiGet("loadBalancerCanonicalHostedZoneId", java.lang.String.class);
            this.loadBalancerDnsName = this.jsiiGet("loadBalancerDnsName", java.lang.String.class);
            this.securityGroupAllowsAllOutbound = this.jsiiGet("securityGroupAllowsAllOutbound", java.lang.Boolean.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String loadBalancerArn, java.lang.String securityGroupId, java.lang.String loadBalancerCanonicalHostedZoneId, java.lang.String loadBalancerDnsName, java.lang.Boolean securityGroupAllowsAllOutbound) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.loadBalancerArn = java.util.Objects.requireNonNull(loadBalancerArn, "loadBalancerArn is required");
            this.securityGroupId = java.util.Objects.requireNonNull(securityGroupId, "securityGroupId is required");
            this.loadBalancerCanonicalHostedZoneId = loadBalancerCanonicalHostedZoneId;
            this.loadBalancerDnsName = loadBalancerDnsName;
            this.securityGroupAllowsAllOutbound = securityGroupAllowsAllOutbound;
        }

        @Override
        public java.lang.String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public java.lang.String getSecurityGroupId() {
            return this.securityGroupId;
        }

        @Override
        public java.lang.String getLoadBalancerCanonicalHostedZoneId() {
            return this.loadBalancerCanonicalHostedZoneId;
        }

        @Override
        public java.lang.String getLoadBalancerDnsName() {
            return this.loadBalancerDnsName;
        }

        @Override
        public java.lang.Boolean getSecurityGroupAllowsAllOutbound() {
            return this.securityGroupAllowsAllOutbound;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
            obj.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));
            if (this.getLoadBalancerCanonicalHostedZoneId() != null) {
                obj.set("loadBalancerCanonicalHostedZoneId", om.valueToTree(this.getLoadBalancerCanonicalHostedZoneId()));
            }
            if (this.getLoadBalancerDnsName() != null) {
                obj.set("loadBalancerDnsName", om.valueToTree(this.getLoadBalancerDnsName()));
            }
            if (this.getSecurityGroupAllowsAllOutbound() != null) {
                obj.set("securityGroupAllowsAllOutbound", om.valueToTree(this.getSecurityGroupAllowsAllOutbound()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationLoadBalancerAttributes.Jsii$Proxy that = (ApplicationLoadBalancerAttributes.Jsii$Proxy) o;

            if (!loadBalancerArn.equals(that.loadBalancerArn)) return false;
            if (!securityGroupId.equals(that.securityGroupId)) return false;
            if (this.loadBalancerCanonicalHostedZoneId != null ? !this.loadBalancerCanonicalHostedZoneId.equals(that.loadBalancerCanonicalHostedZoneId) : that.loadBalancerCanonicalHostedZoneId != null) return false;
            if (this.loadBalancerDnsName != null ? !this.loadBalancerDnsName.equals(that.loadBalancerDnsName) : that.loadBalancerDnsName != null) return false;
            return this.securityGroupAllowsAllOutbound != null ? this.securityGroupAllowsAllOutbound.equals(that.securityGroupAllowsAllOutbound) : that.securityGroupAllowsAllOutbound == null;
        }

        @Override
        public int hashCode() {
            int result = this.loadBalancerArn.hashCode();
            result = 31 * result + (this.securityGroupId.hashCode());
            result = 31 * result + (this.loadBalancerCanonicalHostedZoneId != null ? this.loadBalancerCanonicalHostedZoneId.hashCode() : 0);
            result = 31 * result + (this.loadBalancerDnsName != null ? this.loadBalancerDnsName.hashCode() : 0);
            result = 31 * result + (this.securityGroupAllowsAllOutbound != null ? this.securityGroupAllowsAllOutbound.hashCode() : 0);
            return result;
        }

    }
}
