package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-23T23:57:05.655Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.NetworkLoadBalancerAttributes")
@software.amazon.jsii.Jsii.Proxy(NetworkLoadBalancerAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkLoadBalancerAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * ARN of the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerArn();

    /**
     * The canonical hosted zone ID of this load balancer.
     * <p>
     * Default: - When not provided, LB cannot be used as Route53 Alias target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancerCanonicalHostedZoneId() {
        return null;
    }

    /**
     * The DNS name of this load balancer.
     * <p>
     * Default: - When not provided, LB cannot be used as Route53 Alias target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancerDnsName() {
        return null;
    }

    /**
     * The VPC to associate with the load balancer.
     * <p>
     * Default: - When not provided, listeners cannot be created on imported load
     * balancers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NetworkLoadBalancerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkLoadBalancerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkLoadBalancerAttributes> {
        private java.lang.String loadBalancerArn;
        private java.lang.String loadBalancerCanonicalHostedZoneId;
        private java.lang.String loadBalancerDnsName;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link NetworkLoadBalancerAttributes#getLoadBalancerArn}
         * @param loadBalancerArn ARN of the load balancer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerArn(java.lang.String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancerAttributes#getLoadBalancerCanonicalHostedZoneId}
         * @param loadBalancerCanonicalHostedZoneId The canonical hosted zone ID of this load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerCanonicalHostedZoneId(java.lang.String loadBalancerCanonicalHostedZoneId) {
            this.loadBalancerCanonicalHostedZoneId = loadBalancerCanonicalHostedZoneId;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancerAttributes#getLoadBalancerDnsName}
         * @param loadBalancerDnsName The DNS name of this load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerDnsName(java.lang.String loadBalancerDnsName) {
            this.loadBalancerDnsName = loadBalancerDnsName;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancerAttributes#getVpc}
         * @param vpc The VPC to associate with the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkLoadBalancerAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkLoadBalancerAttributes build() {
            return new Jsii$Proxy(loadBalancerArn, loadBalancerCanonicalHostedZoneId, loadBalancerDnsName, vpc);
        }
    }

    /**
     * An implementation for {@link NetworkLoadBalancerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkLoadBalancerAttributes {
        private final java.lang.String loadBalancerArn;
        private final java.lang.String loadBalancerCanonicalHostedZoneId;
        private final java.lang.String loadBalancerDnsName;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.loadBalancerArn = this.jsiiGet("loadBalancerArn", java.lang.String.class);
            this.loadBalancerCanonicalHostedZoneId = this.jsiiGet("loadBalancerCanonicalHostedZoneId", java.lang.String.class);
            this.loadBalancerDnsName = this.jsiiGet("loadBalancerDnsName", java.lang.String.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String loadBalancerArn, final java.lang.String loadBalancerCanonicalHostedZoneId, final java.lang.String loadBalancerDnsName, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.loadBalancerArn = java.util.Objects.requireNonNull(loadBalancerArn, "loadBalancerArn is required");
            this.loadBalancerCanonicalHostedZoneId = loadBalancerCanonicalHostedZoneId;
            this.loadBalancerDnsName = loadBalancerDnsName;
            this.vpc = vpc;
        }

        @Override
        public java.lang.String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public java.lang.String getLoadBalancerCanonicalHostedZoneId() {
            return this.loadBalancerCanonicalHostedZoneId;
        }

        @Override
        public java.lang.String getLoadBalancerDnsName() {
            return this.loadBalancerDnsName;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
            if (this.getLoadBalancerCanonicalHostedZoneId() != null) {
                data.set("loadBalancerCanonicalHostedZoneId", om.valueToTree(this.getLoadBalancerCanonicalHostedZoneId()));
            }
            if (this.getLoadBalancerDnsName() != null) {
                data.set("loadBalancerDnsName", om.valueToTree(this.getLoadBalancerDnsName()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.NetworkLoadBalancerAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkLoadBalancerAttributes.Jsii$Proxy that = (NetworkLoadBalancerAttributes.Jsii$Proxy) o;

            if (!loadBalancerArn.equals(that.loadBalancerArn)) return false;
            if (this.loadBalancerCanonicalHostedZoneId != null ? !this.loadBalancerCanonicalHostedZoneId.equals(that.loadBalancerCanonicalHostedZoneId) : that.loadBalancerCanonicalHostedZoneId != null) return false;
            if (this.loadBalancerDnsName != null ? !this.loadBalancerDnsName.equals(that.loadBalancerDnsName) : that.loadBalancerDnsName != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public int hashCode() {
            int result = this.loadBalancerArn.hashCode();
            result = 31 * result + (this.loadBalancerCanonicalHostedZoneId != null ? this.loadBalancerCanonicalHostedZoneId.hashCode() : 0);
            result = 31 * result + (this.loadBalancerDnsName != null ? this.loadBalancerDnsName.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
