package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Options for looking up a network listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.14.1 (build 828de8a)", date = "2020-11-24T22:29:40.718Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.NetworkListenerLookupOptions")
@software.amazon.jsii.Jsii.Proxy(NetworkListenerLookupOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkListenerLookupOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseListenerLookupOptions {

    /**
     * Protocol of the listener port.
     * <p>
     * Default: - listener is not filtered by protocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getListenerProtocol() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NetworkListenerLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkListenerLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkListenerLookupOptions> {
        private software.amazon.awscdk.services.elasticloadbalancingv2.Protocol listenerProtocol;
        private java.lang.Number listenerPort;
        private java.lang.String loadBalancerArn;
        private java.util.Map<java.lang.String, java.lang.String> loadBalancerTags;

        /**
         * Sets the value of {@link NetworkListenerLookupOptions#getListenerProtocol}
         * @param listenerProtocol Protocol of the listener port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerProtocol(software.amazon.awscdk.services.elasticloadbalancingv2.Protocol listenerProtocol) {
            this.listenerProtocol = listenerProtocol;
            return this;
        }

        /**
         * Sets the value of {@link NetworkListenerLookupOptions#getListenerPort}
         * @param listenerPort Filter listeners by listener port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerPort(java.lang.Number listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        /**
         * Sets the value of {@link NetworkListenerLookupOptions#getLoadBalancerArn}
         * @param loadBalancerArn Filter listeners by associated load balancer arn.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerArn(java.lang.String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        /**
         * Sets the value of {@link NetworkListenerLookupOptions#getLoadBalancerTags}
         * @param loadBalancerTags Filter listeners by associated load balancer tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerTags(java.util.Map<java.lang.String, java.lang.String> loadBalancerTags) {
            this.loadBalancerTags = loadBalancerTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkListenerLookupOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkListenerLookupOptions build() {
            return new Jsii$Proxy(listenerProtocol, listenerPort, loadBalancerArn, loadBalancerTags);
        }
    }

    /**
     * An implementation for {@link NetworkListenerLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkListenerLookupOptions {
        private final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol listenerProtocol;
        private final java.lang.Number listenerPort;
        private final java.lang.String loadBalancerArn;
        private final java.util.Map<java.lang.String, java.lang.String> loadBalancerTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.listenerProtocol = software.amazon.jsii.Kernel.get(this, "listenerProtocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.Protocol.class));
            this.listenerPort = software.amazon.jsii.Kernel.get(this, "listenerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.loadBalancerArn = software.amazon.jsii.Kernel.get(this, "loadBalancerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerTags = software.amazon.jsii.Kernel.get(this, "loadBalancerTags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol listenerProtocol, final java.lang.Number listenerPort, final java.lang.String loadBalancerArn, final java.util.Map<java.lang.String, java.lang.String> loadBalancerTags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listenerProtocol = listenerProtocol;
            this.listenerPort = listenerPort;
            this.loadBalancerArn = loadBalancerArn;
            this.loadBalancerTags = loadBalancerTags;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getListenerProtocol() {
            return this.listenerProtocol;
        }

        @Override
        public final java.lang.Number getListenerPort() {
            return this.listenerPort;
        }

        @Override
        public final java.lang.String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLoadBalancerTags() {
            return this.loadBalancerTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getListenerProtocol() != null) {
                data.set("listenerProtocol", om.valueToTree(this.getListenerProtocol()));
            }
            if (this.getListenerPort() != null) {
                data.set("listenerPort", om.valueToTree(this.getListenerPort()));
            }
            if (this.getLoadBalancerArn() != null) {
                data.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
            }
            if (this.getLoadBalancerTags() != null) {
                data.set("loadBalancerTags", om.valueToTree(this.getLoadBalancerTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.NetworkListenerLookupOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkListenerLookupOptions.Jsii$Proxy that = (NetworkListenerLookupOptions.Jsii$Proxy) o;

            if (this.listenerProtocol != null ? !this.listenerProtocol.equals(that.listenerProtocol) : that.listenerProtocol != null) return false;
            if (this.listenerPort != null ? !this.listenerPort.equals(that.listenerPort) : that.listenerPort != null) return false;
            if (this.loadBalancerArn != null ? !this.loadBalancerArn.equals(that.loadBalancerArn) : that.loadBalancerArn != null) return false;
            return this.loadBalancerTags != null ? this.loadBalancerTags.equals(that.loadBalancerTags) : that.loadBalancerTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.listenerProtocol != null ? this.listenerProtocol.hashCode() : 0;
            result = 31 * result + (this.listenerPort != null ? this.listenerPort.hashCode() : 0);
            result = 31 * result + (this.loadBalancerArn != null ? this.loadBalancerArn.hashCode() : 0);
            result = 31 * result + (this.loadBalancerTags != null ? this.loadBalancerTags.hashCode() : 0);
            return result;
        }
    }
}
