/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.Port;
import software.amazon.awscdk.services.elasticloadbalancingv2.;
import software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationActionProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetGroupsProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetsProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.AddFixedResponseProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.AddRedirectResponseProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerAttributes;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerLookupOptions;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate;
import software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction;
import software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticloadbalancingv2.ApplicationListener")
public class ApplicationListener
extends BaseListener
implements IApplicationListener {
    protected ApplicationListener(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationListener(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ApplicationListener(@NotNull Construct scope, @NotNull String id, @NotNull ApplicationListenerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IApplicationListener fromApplicationListenerAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ApplicationListenerAttributes attrs) {
        return (IApplicationListener)JsiiObject.jsiiStaticCall(ApplicationListener.class, (String)"fromApplicationListenerAttributes", (NativeType)NativeType.forClass(IApplicationListener.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IApplicationListener fromLookup(@NotNull Construct scope, @NotNull String id, @NotNull ApplicationListenerLookupOptions options) {
        return (IApplicationListener)JsiiObject.jsiiStaticCall(ApplicationListener.class, (String)"fromLookup", (NativeType)NativeType.forClass(IApplicationListener.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    public void addAction(@NotNull String id, @NotNull AddApplicationActionProps props) {
        Kernel.call((Object)this, (String)"addAction", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @Deprecated
    public void addCertificateArns(@NotNull String id, @NotNull List<String> arns) {
        Kernel.call((Object)this, (String)"addCertificateArns", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(arns, "arns is required")});
    }

    public void addCertificates(@NotNull String id, @NotNull List<IListenerCertificate> certificates) {
        Kernel.call((Object)this, (String)"addCertificates", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(certificates, "certificates is required")});
    }

    @Deprecated
    public void addFixedResponse(@NotNull String id, @NotNull AddFixedResponseProps props) {
        Kernel.call((Object)this, (String)"addFixedResponse", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Deprecated
    public void addRedirectResponse(@NotNull String id, @NotNull AddRedirectResponseProps props) {
        Kernel.call((Object)this, (String)"addRedirectResponse", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void addTargetGroups(@NotNull String id, @NotNull AddApplicationTargetGroupsProps props) {
        Kernel.call((Object)this, (String)"addTargetGroups", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public ApplicationTargetGroup addTargets(@NotNull String id, @NotNull AddApplicationTargetsProps props) {
        return (ApplicationTargetGroup)Kernel.call((Object)this, (String)"addTargets", (NativeType)NativeType.forClass(ApplicationTargetGroup.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void registerConnectable(@NotNull IConnectable connectable, @NotNull Port portRange) {
        Kernel.call((Object)this, (String)"registerConnectable", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(connectable, "connectable is required"), Objects.requireNonNull(portRange, "portRange is required")});
    }

    @Override
    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"validate", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @NotNull
    public IApplicationLoadBalancer getLoadBalancer() {
        return (IApplicationLoadBalancer)Kernel.get((Object)this, (String)"loadBalancer", (NativeType)NativeType.forClass(IApplicationLoadBalancer.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ApplicationListener> {
        private final Construct scope;
        private final String id;
        private final ApplicationListenerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ApplicationListenerProps.Builder();
        }

        @Deprecated
        public Builder certificateArns(List<String> certificateArns) {
            this.props.certificateArns(certificateArns);
            return this;
        }

        public Builder certificates(List<? extends IListenerCertificate> certificates) {
            this.props.certificates(certificates);
            return this;
        }

        public Builder defaultAction(ListenerAction defaultAction) {
            this.props.defaultAction(defaultAction);
            return this;
        }

        public Builder defaultTargetGroups(List<? extends IApplicationTargetGroup> defaultTargetGroups) {
            this.props.defaultTargetGroups(defaultTargetGroups);
            return this;
        }

        public Builder open(Boolean open) {
            this.props.open(open);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder protocol(ApplicationProtocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        public Builder sslPolicy(SslPolicy sslPolicy) {
            this.props.sslPolicy(sslPolicy);
            return this;
        }

        public Builder loadBalancer(IApplicationLoadBalancer loadBalancer) {
            this.props.loadBalancer(loadBalancer);
            return this;
        }

        public ApplicationListener build() {
            return new ApplicationListener(this.scope, this.id, this.props.build());
        }
    }
}

