package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding a set of certificates to a listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:21:53.907Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationListenerCertificateProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ARNs of certificates to attach.
     * 
     * Duplicates are not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getCertificateArns();

    /**
     * The listener to attach the rule to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener();

    /**
     * @return a {@link Builder} of {@link ApplicationListenerCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationListenerCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.util.List<java.lang.String> certificateArns;
        private software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener;

        /**
         * Sets the value of CertificateArns
         * @param certificateArns ARNs of certificates to attach.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateArns(java.util.List<java.lang.String> certificateArns) {
            this.certificateArns = certificateArns;
            return this;
        }

        /**
         * Sets the value of Listener
         * @param listener The listener to attach the rule to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listener(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener) {
            this.listener = listener;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationListenerCertificateProps build() {
            return new Jsii$Proxy(certificateArns, listener);
        }

    }

    /**
     * An implementation for {@link ApplicationListenerCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationListenerCertificateProps {
        private final java.util.List<java.lang.String> certificateArns;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.certificateArns = this.jsiiGet("certificateArns", java.util.List.class);
            this.listener = this.jsiiGet("listener", software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.util.List<java.lang.String> certificateArns, software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificateArns = java.util.Objects.requireNonNull(certificateArns, "certificateArns is required");
            this.listener = java.util.Objects.requireNonNull(listener, "listener is required");
        }

        @Override
        public java.util.List<java.lang.String> getCertificateArns() {
            return this.certificateArns;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener() {
            return this.listener;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("certificateArns", om.valueToTree(this.getCertificateArns()));
            obj.set("listener", om.valueToTree(this.getListener()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationListenerCertificateProps.Jsii$Proxy that = (ApplicationListenerCertificateProps.Jsii$Proxy) o;

            if (!certificateArns.equals(that.certificateArns)) return false;
            return this.listener.equals(that.listener);
        }

        @Override
        public int hashCode() {
            int result = this.certificateArns.hashCode();
            result = 31 * result + (this.listener.hashCode());
            return result;
        }

    }
}
