package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a listener rule.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:21:53.908Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationListenerRuleProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerRuleProps {
    /**
     * The listener to attach the rule to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener();

    /**
     * @return a {@link Builder} of {@link ApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener;
        private java.lang.Number priority;
        private software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse;
        private java.lang.String hostHeader;
        private java.lang.String pathPattern;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups;

        /**
         * Sets the value of Listener
         * @param listener The listener to attach the rule to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listener(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener) {
            this.listener = listener;
            return this;
        }

        /**
         * Sets the value of Priority
         * @param priority Priority of the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of FixedResponse
         * @param fixedResponse Fixed response to return.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fixedResponse(software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse) {
            this.fixedResponse = fixedResponse;
            return this;
        }

        /**
         * Sets the value of HostHeader
         * @param hostHeader Rule applies if the requested host matches the indicated host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostHeader(java.lang.String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        /**
         * Sets the value of PathPattern
         * @param pathPattern Rule applies if the requested path matches the given path pattern.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathPattern(java.lang.String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        /**
         * Sets the value of TargetGroups
         * @param targetGroups Target groups to forward requests to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroups(java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups) {
            this.targetGroups = targetGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationListenerRuleProps build() {
            return new Jsii$Proxy(listener, priority, fixedResponse, hostHeader, pathPattern, targetGroups);
        }

    }

    /**
     * An implementation for {@link ApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationListenerRuleProps {
        private final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener;
        private final java.lang.Number priority;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse;
        private final java.lang.String hostHeader;
        private final java.lang.String pathPattern;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.listener = this.jsiiGet("listener", software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener.class);
            this.priority = this.jsiiGet("priority", java.lang.Number.class);
            this.fixedResponse = this.jsiiGet("fixedResponse", software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse.class);
            this.hostHeader = this.jsiiGet("hostHeader", java.lang.String.class);
            this.pathPattern = this.jsiiGet("pathPattern", java.lang.String.class);
            this.targetGroups = this.jsiiGet("targetGroups", java.util.List.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener, java.lang.Number priority, software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse fixedResponse, java.lang.String hostHeader, java.lang.String pathPattern, java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listener = java.util.Objects.requireNonNull(listener, "listener is required");
            this.priority = java.util.Objects.requireNonNull(priority, "priority is required");
            this.fixedResponse = fixedResponse;
            this.hostHeader = hostHeader;
            this.pathPattern = pathPattern;
            this.targetGroups = targetGroups;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener() {
            return this.listener;
        }

        @Override
        public java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse getFixedResponse() {
            return this.fixedResponse;
        }

        @Override
        public java.lang.String getHostHeader() {
            return this.hostHeader;
        }

        @Override
        public java.lang.String getPathPattern() {
            return this.pathPattern;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
            return this.targetGroups;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("listener", om.valueToTree(this.getListener()));
            obj.set("priority", om.valueToTree(this.getPriority()));
            if (this.getFixedResponse() != null) {
                obj.set("fixedResponse", om.valueToTree(this.getFixedResponse()));
            }
            if (this.getHostHeader() != null) {
                obj.set("hostHeader", om.valueToTree(this.getHostHeader()));
            }
            if (this.getPathPattern() != null) {
                obj.set("pathPattern", om.valueToTree(this.getPathPattern()));
            }
            if (this.getTargetGroups() != null) {
                obj.set("targetGroups", om.valueToTree(this.getTargetGroups()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationListenerRuleProps.Jsii$Proxy that = (ApplicationListenerRuleProps.Jsii$Proxy) o;

            if (!listener.equals(that.listener)) return false;
            if (!priority.equals(that.priority)) return false;
            if (this.fixedResponse != null ? !this.fixedResponse.equals(that.fixedResponse) : that.fixedResponse != null) return false;
            if (this.hostHeader != null ? !this.hostHeader.equals(that.hostHeader) : that.hostHeader != null) return false;
            if (this.pathPattern != null ? !this.pathPattern.equals(that.pathPattern) : that.pathPattern != null) return false;
            return this.targetGroups != null ? this.targetGroups.equals(that.targetGroups) : that.targetGroups == null;
        }

        @Override
        public int hashCode() {
            int result = this.listener.hashCode();
            result = 31 * result + (this.priority.hashCode());
            result = 31 * result + (this.fixedResponse != null ? this.fixedResponse.hashCode() : 0);
            result = 31 * result + (this.hostHeader != null ? this.hostHeader.hashCode() : 0);
            result = 31 * result + (this.pathPattern != null ? this.pathPattern.hashCode() : 0);
            result = 31 * result + (this.targetGroups != null ? this.targetGroups.hashCode() : 0);
            return result;
        }

    }
}
