package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::ListenerCertificate`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:21:53.924Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnListenerCertificateProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getCertificates();

    /**
     * `AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getListenerArn();

    /**
     * @return a {@link Builder} of {@link CfnListenerCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnListenerCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.Object certificates;
        private java.lang.String listenerArn;

        /**
         * Sets the value of Certificates
         * @param certificates `AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder certificates(software.amazon.awscdk.core.IResolvable certificates) {
            this.certificates = certificates;
            return this;
        }

        /**
         * Sets the value of Certificates
         * @param certificates `AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder certificates(java.util.List<java.lang.Object> certificates) {
            this.certificates = certificates;
            return this;
        }

        /**
         * Sets the value of ListenerArn
         * @param listenerArn `AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder listenerArn(java.lang.String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnListenerCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnListenerCertificateProps build() {
            return new Jsii$Proxy(certificates, listenerArn);
        }

    }

    /**
     * An implementation for {@link CfnListenerCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnListenerCertificateProps {
        private final java.lang.Object certificates;
        private final java.lang.String listenerArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.certificates = this.jsiiGet("certificates", java.lang.Object.class);
            this.listenerArn = this.jsiiGet("listenerArn", java.lang.String.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Object certificates, java.lang.String listenerArn) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificates = java.util.Objects.requireNonNull(certificates, "certificates is required");
            this.listenerArn = java.util.Objects.requireNonNull(listenerArn, "listenerArn is required");
        }

        @Override
        public java.lang.Object getCertificates() {
            return this.certificates;
        }

        @Override
        public java.lang.String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("certificates", om.valueToTree(this.getCertificates()));
            obj.set("listenerArn", om.valueToTree(this.getListenerArn()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnListenerCertificateProps.Jsii$Proxy that = (CfnListenerCertificateProps.Jsii$Proxy) o;

            if (!certificates.equals(that.certificates)) return false;
            return this.listenerArn.equals(that.listenerArn);
        }

        @Override
        public int hashCode() {
            int result = this.certificates.hashCode();
            result = 31 * result + (this.listenerArn.hashCode());
            return result;
        }

    }
}
