package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for a Network Listener attached to a Load Balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:21:53.949Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkListenerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseNetworkListenerProps {
    /**
     * The load balancer to attach this listener to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer getLoadBalancer();

    /**
     * @return a {@link Builder} of {@link NetworkListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link NetworkListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer;
        private java.lang.Number port;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListenerCertificateProps> certificates;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> defaultTargetGroups;
        private software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol;
        private software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy;

        /**
         * Sets the value of LoadBalancer
         * @param loadBalancer The load balancer to attach this listener to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancer(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        /**
         * Sets the value of Port
         * @param port The port on which the listener listens for requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of Certificates
         * @param certificates Certificate list of ACM cert ARNs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificates(java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListenerCertificateProps> certificates) {
            this.certificates = certificates;
            return this;
        }

        /**
         * Sets the value of DefaultTargetGroups
         * @param defaultTargetGroups Default target groups to load balance to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultTargetGroups(java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> defaultTargetGroups) {
            this.defaultTargetGroups = defaultTargetGroups;
            return this;
        }

        /**
         * Sets the value of Protocol
         * @param protocol Protocol for listener, expects TCP or TLS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of SslPolicy
         * @param sslPolicy SSL Policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslPolicy(software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkListenerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public NetworkListenerProps build() {
            return new Jsii$Proxy(loadBalancer, port, certificates, defaultTargetGroups, protocol, sslPolicy);
        }

    }

    /**
     * An implementation for {@link NetworkListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkListenerProps {
        private final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer;
        private final java.lang.Number port;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListenerCertificateProps> certificates;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> defaultTargetGroups;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.loadBalancer = this.jsiiGet("loadBalancer", software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer.class);
            this.port = this.jsiiGet("port", java.lang.Number.class);
            this.certificates = this.jsiiGet("certificates", java.util.List.class);
            this.defaultTargetGroups = this.jsiiGet("defaultTargetGroups", java.util.List.class);
            this.protocol = this.jsiiGet("protocol", software.amazon.awscdk.services.elasticloadbalancingv2.Protocol.class);
            this.sslPolicy = this.jsiiGet("sslPolicy", software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer, java.lang.Number port, java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListenerCertificateProps> certificates, java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> defaultTargetGroups, software.amazon.awscdk.services.elasticloadbalancingv2.Protocol protocol, software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.loadBalancer = java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required");
            this.port = java.util.Objects.requireNonNull(port, "port is required");
            this.certificates = certificates;
            this.defaultTargetGroups = defaultTargetGroups;
            this.protocol = protocol;
            this.sslPolicy = sslPolicy;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer getLoadBalancer() {
            return this.loadBalancer;
        }

        @Override
        public java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListenerCertificateProps> getCertificates() {
            return this.certificates;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> getDefaultTargetGroups() {
            return this.defaultTargetGroups;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol() {
            return this.protocol;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
            return this.sslPolicy;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("loadBalancer", om.valueToTree(this.getLoadBalancer()));
            obj.set("port", om.valueToTree(this.getPort()));
            if (this.getCertificates() != null) {
                obj.set("certificates", om.valueToTree(this.getCertificates()));
            }
            if (this.getDefaultTargetGroups() != null) {
                obj.set("defaultTargetGroups", om.valueToTree(this.getDefaultTargetGroups()));
            }
            if (this.getProtocol() != null) {
                obj.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getSslPolicy() != null) {
                obj.set("sslPolicy", om.valueToTree(this.getSslPolicy()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkListenerProps.Jsii$Proxy that = (NetworkListenerProps.Jsii$Proxy) o;

            if (!loadBalancer.equals(that.loadBalancer)) return false;
            if (!port.equals(that.port)) return false;
            if (this.certificates != null ? !this.certificates.equals(that.certificates) : that.certificates != null) return false;
            if (this.defaultTargetGroups != null ? !this.defaultTargetGroups.equals(that.defaultTargetGroups) : that.defaultTargetGroups != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            return this.sslPolicy != null ? this.sslPolicy.equals(that.sslPolicy) : that.sslPolicy == null;
        }

        @Override
        public int hashCode() {
            int result = this.loadBalancer.hashCode();
            result = 31 * result + (this.port.hashCode());
            result = 31 * result + (this.certificates != null ? this.certificates.hashCode() : 0);
            result = 31 * result + (this.defaultTargetGroups != null ? this.defaultTargetGroups.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.sslPolicy != null ? this.sslPolicy.hashCode() : 0);
            return result;
        }

    }
}
