package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-12T21:08:19.287Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationLoadBalancerAttributes")
@software.amazon.jsii.Jsii.Proxy(ApplicationLoadBalancerAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationLoadBalancerAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * ARN of the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerArn();

    /**
     * ID of the load balancer's security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupId();

    /**
     * The canonical hosted zone ID of this load balancer.
     * <p>
     * Default: - When not provided, LB cannot be used as Route53 Alias target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancerCanonicalHostedZoneId() {
        return null;
    }

    /**
     * The DNS name of this load balancer.
     * <p>
     * Default: - When not provided, LB cannot be used as Route53 Alias target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancerDnsName() {
        return null;
    }

    /**
     * Whether the security group allows all outbound traffic or not.
     * <p>
     * Unless set to <code>false</code>, no egress rules will be added to the security group.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSecurityGroupAllowsAllOutbound() {
        return null;
    }

    /**
     * The VPC this load balancer has been created in, if available.
     * <p>
     * Default: - If the Load Balancer was imported and a VPC was not specified,
     * the VPC is not available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationLoadBalancerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationLoadBalancerAttributes> {
        private java.lang.String loadBalancerArn;
        private java.lang.String securityGroupId;
        private java.lang.String loadBalancerCanonicalHostedZoneId;
        private java.lang.String loadBalancerDnsName;
        private java.lang.Boolean securityGroupAllowsAllOutbound;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link ApplicationLoadBalancerAttributes#getLoadBalancerArn}
         * @param loadBalancerArn ARN of the load balancer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerArn(java.lang.String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerAttributes#getSecurityGroupId}
         * @param securityGroupId ID of the load balancer's security group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupId(java.lang.String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerAttributes#getLoadBalancerCanonicalHostedZoneId}
         * @param loadBalancerCanonicalHostedZoneId The canonical hosted zone ID of this load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerCanonicalHostedZoneId(java.lang.String loadBalancerCanonicalHostedZoneId) {
            this.loadBalancerCanonicalHostedZoneId = loadBalancerCanonicalHostedZoneId;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerAttributes#getLoadBalancerDnsName}
         * @param loadBalancerDnsName The DNS name of this load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerDnsName(java.lang.String loadBalancerDnsName) {
            this.loadBalancerDnsName = loadBalancerDnsName;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerAttributes#getSecurityGroupAllowsAllOutbound}
         * @param securityGroupAllowsAllOutbound Whether the security group allows all outbound traffic or not.
         *                                       Unless set to <code>false</code>, no egress rules will be added to the security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupAllowsAllOutbound(java.lang.Boolean securityGroupAllowsAllOutbound) {
            this.securityGroupAllowsAllOutbound = securityGroupAllowsAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerAttributes#getVpc}
         * @param vpc The VPC this load balancer has been created in, if available.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancerAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationLoadBalancerAttributes build() {
            return new Jsii$Proxy(loadBalancerArn, securityGroupId, loadBalancerCanonicalHostedZoneId, loadBalancerDnsName, securityGroupAllowsAllOutbound, vpc);
        }
    }

    /**
     * An implementation for {@link ApplicationLoadBalancerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationLoadBalancerAttributes {
        private final java.lang.String loadBalancerArn;
        private final java.lang.String securityGroupId;
        private final java.lang.String loadBalancerCanonicalHostedZoneId;
        private final java.lang.String loadBalancerDnsName;
        private final java.lang.Boolean securityGroupAllowsAllOutbound;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.loadBalancerArn = software.amazon.jsii.Kernel.get(this, "loadBalancerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroupId = software.amazon.jsii.Kernel.get(this, "securityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerCanonicalHostedZoneId = software.amazon.jsii.Kernel.get(this, "loadBalancerCanonicalHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerDnsName = software.amazon.jsii.Kernel.get(this, "loadBalancerDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroupAllowsAllOutbound = software.amazon.jsii.Kernel.get(this, "securityGroupAllowsAllOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String loadBalancerArn, final java.lang.String securityGroupId, final java.lang.String loadBalancerCanonicalHostedZoneId, final java.lang.String loadBalancerDnsName, final java.lang.Boolean securityGroupAllowsAllOutbound, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.loadBalancerArn = java.util.Objects.requireNonNull(loadBalancerArn, "loadBalancerArn is required");
            this.securityGroupId = java.util.Objects.requireNonNull(securityGroupId, "securityGroupId is required");
            this.loadBalancerCanonicalHostedZoneId = loadBalancerCanonicalHostedZoneId;
            this.loadBalancerDnsName = loadBalancerDnsName;
            this.securityGroupAllowsAllOutbound = securityGroupAllowsAllOutbound;
            this.vpc = vpc;
        }

        @Override
        public final java.lang.String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final java.lang.String getSecurityGroupId() {
            return this.securityGroupId;
        }

        @Override
        public final java.lang.String getLoadBalancerCanonicalHostedZoneId() {
            return this.loadBalancerCanonicalHostedZoneId;
        }

        @Override
        public final java.lang.String getLoadBalancerDnsName() {
            return this.loadBalancerDnsName;
        }

        @Override
        public final java.lang.Boolean getSecurityGroupAllowsAllOutbound() {
            return this.securityGroupAllowsAllOutbound;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
            data.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));
            if (this.getLoadBalancerCanonicalHostedZoneId() != null) {
                data.set("loadBalancerCanonicalHostedZoneId", om.valueToTree(this.getLoadBalancerCanonicalHostedZoneId()));
            }
            if (this.getLoadBalancerDnsName() != null) {
                data.set("loadBalancerDnsName", om.valueToTree(this.getLoadBalancerDnsName()));
            }
            if (this.getSecurityGroupAllowsAllOutbound() != null) {
                data.set("securityGroupAllowsAllOutbound", om.valueToTree(this.getSecurityGroupAllowsAllOutbound()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.ApplicationLoadBalancerAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationLoadBalancerAttributes.Jsii$Proxy that = (ApplicationLoadBalancerAttributes.Jsii$Proxy) o;

            if (!loadBalancerArn.equals(that.loadBalancerArn)) return false;
            if (!securityGroupId.equals(that.securityGroupId)) return false;
            if (this.loadBalancerCanonicalHostedZoneId != null ? !this.loadBalancerCanonicalHostedZoneId.equals(that.loadBalancerCanonicalHostedZoneId) : that.loadBalancerCanonicalHostedZoneId != null) return false;
            if (this.loadBalancerDnsName != null ? !this.loadBalancerDnsName.equals(that.loadBalancerDnsName) : that.loadBalancerDnsName != null) return false;
            if (this.securityGroupAllowsAllOutbound != null ? !this.securityGroupAllowsAllOutbound.equals(that.securityGroupAllowsAllOutbound) : that.securityGroupAllowsAllOutbound != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.loadBalancerArn.hashCode();
            result = 31 * result + (this.securityGroupId.hashCode());
            result = 31 * result + (this.loadBalancerCanonicalHostedZoneId != null ? this.loadBalancerCanonicalHostedZoneId.hashCode() : 0);
            result = 31 * result + (this.loadBalancerDnsName != null ? this.loadBalancerDnsName.hashCode() : 0);
            result = 31 * result + (this.securityGroupAllowsAllOutbound != null ? this.securityGroupAllowsAllOutbound.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
