package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * A Target Group for Application Load Balancers.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-27T11:16:58.399Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.IApplicationTargetGroup")
@software.amazon.jsii.Jsii.Proxy(IApplicationTargetGroup.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IApplicationTargetGroup extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup {

    /**
     * Add a load balancing target to this target group.
     * <p>
     * @param targets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget... targets);

    /**
     * Register a connectable as a member of this target group.
     * <p>
     * Don't call this directly. It will be called by load balancing targets.
     * <p>
     * @param connectable This parameter is required.
     * @param portRange
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void registerConnectable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable connectable, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.Port portRange);

    /**
     * Register a connectable as a member of this target group.
     * <p>
     * Don't call this directly. It will be called by load balancing targets.
     * <p>
     * @param connectable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void registerConnectable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable connectable);

    /**
     * Register a listener that is load balancing to this target group.
     * <p>
     * Don't call this directly. It will be called by listeners.
     * <p>
     * @param listener This parameter is required.
     * @param associatingConstruct
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void registerListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener, final @org.jetbrains.annotations.Nullable software.constructs.IConstruct associatingConstruct);

    /**
     * Register a listener that is load balancing to this target group.
     * <p>
     * Don't call this directly. It will be called by listeners.
     * <p>
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void registerListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * A token representing a list of ARNs of the load balancers that route traffic to this target group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerArns() {
            return software.amazon.jsii.Kernel.get(this, "loadBalancerArns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Return an object to depend on the listeners added to this target group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IDependable getLoadBalancerAttached() {
            return software.amazon.jsii.Kernel.get(this, "loadBalancerAttached", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IDependable.class));
        }

        /**
         * ARN of the target group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getTargetGroupArn() {
            return software.amazon.jsii.Kernel.get(this, "targetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Add a load balancing target to this target group.
         * <p>
         * @param targets This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget... targets) {
            software.amazon.jsii.Kernel.call(this, "addTarget", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(targets).toArray(Object[]::new));
        }

        /**
         * Register a connectable as a member of this target group.
         * <p>
         * Don't call this directly. It will be called by load balancing targets.
         * <p>
         * @param connectable This parameter is required.
         * @param portRange
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void registerConnectable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable connectable, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.Port portRange) {
            software.amazon.jsii.Kernel.call(this, "registerConnectable", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(connectable, "connectable is required"), portRange });
        }

        /**
         * Register a connectable as a member of this target group.
         * <p>
         * Don't call this directly. It will be called by load balancing targets.
         * <p>
         * @param connectable This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void registerConnectable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable connectable) {
            software.amazon.jsii.Kernel.call(this, "registerConnectable", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(connectable, "connectable is required") });
        }

        /**
         * Register a listener that is load balancing to this target group.
         * <p>
         * Don't call this directly. It will be called by listeners.
         * <p>
         * @param listener This parameter is required.
         * @param associatingConstruct
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void registerListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener, final @org.jetbrains.annotations.Nullable software.constructs.IConstruct associatingConstruct) {
            software.amazon.jsii.Kernel.call(this, "registerListener", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(listener, "listener is required"), associatingConstruct });
        }

        /**
         * Register a listener that is load balancing to this target group.
         * <p>
         * Don't call this directly. It will be called by listeners.
         * <p>
         * @param listener This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void registerListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener) {
            software.amazon.jsii.Kernel.call(this, "registerListener", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(listener, "listener is required") });
        }
    }

    /**
     * Internal default implementation for {@link IApplicationTargetGroup}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IApplicationTargetGroup, software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup.Jsii$Default {

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * A token representing a list of ARNs of the load balancers that route traffic to this target group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerArns() {
            return software.amazon.jsii.Kernel.get(this, "loadBalancerArns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Return an object to depend on the listeners added to this target group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IDependable getLoadBalancerAttached() {
            return software.amazon.jsii.Kernel.get(this, "loadBalancerAttached", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IDependable.class));
        }

        /**
         * ARN of the target group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getTargetGroupArn() {
            return software.amazon.jsii.Kernel.get(this, "targetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Add a load balancing target to this target group.
         * <p>
         * @param targets This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget... targets) {
            software.amazon.jsii.Kernel.call(this, "addTarget", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(targets).toArray(Object[]::new));
        }

        /**
         * Register a connectable as a member of this target group.
         * <p>
         * Don't call this directly. It will be called by load balancing targets.
         * <p>
         * @param connectable This parameter is required.
         * @param portRange
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void registerConnectable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable connectable, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.Port portRange) {
            software.amazon.jsii.Kernel.call(this, "registerConnectable", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(connectable, "connectable is required"), portRange });
        }

        /**
         * Register a listener that is load balancing to this target group.
         * <p>
         * Don't call this directly. It will be called by listeners.
         * <p>
         * @param listener This parameter is required.
         * @param associatingConstruct
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void registerListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener, final @org.jetbrains.annotations.Nullable software.constructs.IConstruct associatingConstruct) {
            software.amazon.jsii.Kernel.call(this, "registerListener", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(listener, "listener is required"), associatingConstruct });
        }
    }
}
