package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing target group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-20T10:01:14.564Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TargetGroupImportProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Port target group is listening on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDefaultPort();

    /**
     * ARN of the target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getTargetGroupArn();

    /**
     * A Token representing the list of ARNs for the load balancer routing to this target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getLoadBalancerArns();

    /**
     * @return a {@link Builder} of {@link TargetGroupImportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TargetGroupImportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String defaultPort;
        private java.lang.String targetGroupArn;
        private java.lang.String loadBalancerArns;

        /**
         * Sets the value of DefaultPort
         * @param defaultPort Port target group is listening on. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultPort(java.lang.String defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        /**
         * Sets the value of TargetGroupArn
         * @param targetGroupArn ARN of the target group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupArn(java.lang.String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        /**
         * Sets the value of LoadBalancerArns
         * @param loadBalancerArns A Token representing the list of ARNs for the load balancer routing to this target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerArns(java.lang.String loadBalancerArns) {
            this.loadBalancerArns = loadBalancerArns;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TargetGroupImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public TargetGroupImportProps build() {
            return new Jsii$Proxy(defaultPort, targetGroupArn, loadBalancerArns);
        }
    }

    /**
     * An implementation for {@link TargetGroupImportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupImportProps {
        private final java.lang.String defaultPort;
        private final java.lang.String targetGroupArn;
        private final java.lang.String loadBalancerArns;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.defaultPort = this.jsiiGet("defaultPort", java.lang.String.class);
            this.targetGroupArn = this.jsiiGet("targetGroupArn", java.lang.String.class);
            this.loadBalancerArns = this.jsiiGet("loadBalancerArns", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String defaultPort, java.lang.String targetGroupArn, java.lang.String loadBalancerArns) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultPort = java.util.Objects.requireNonNull(defaultPort, "defaultPort is required");
            this.targetGroupArn = java.util.Objects.requireNonNull(targetGroupArn, "targetGroupArn is required");
            this.loadBalancerArns = loadBalancerArns;
        }

        @Override
        public java.lang.String getDefaultPort() {
            return this.defaultPort;
        }

        @Override
        public java.lang.String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public java.lang.String getLoadBalancerArns() {
            return this.loadBalancerArns;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("defaultPort", om.valueToTree(this.getDefaultPort()));
            obj.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));
            if (this.getLoadBalancerArns() != null) {
                obj.set("loadBalancerArns", om.valueToTree(this.getLoadBalancerArns()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TargetGroupImportProps.Jsii$Proxy that = (TargetGroupImportProps.Jsii$Proxy) o;

            if (!defaultPort.equals(that.defaultPort)) return false;
            if (!targetGroupArn.equals(that.targetGroupArn)) return false;
            return this.loadBalancerArns != null ? this.loadBalancerArns.equals(that.loadBalancerArns) : that.loadBalancerArns == null;
        }

        @Override
        public int hashCode() {
            int result = this.defaultPort.hashCode();
            result = 31 * result + (this.targetGroupArn.hashCode());
            result = 31 * result + (this.loadBalancerArns != null ? this.loadBalancerArns.hashCode() : 0);
            return result;
        }
    }
}
