package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define the target of a load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:47:03.527Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.TargetGroupBase")
public abstract class TargetGroupBase extends software.amazon.awscdk.core.Construct implements software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup {

    protected TargetGroupBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TargetGroupBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param baseProps This parameter is required.
     * @param additionalProps This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected TargetGroupBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps baseProps, final @org.jetbrains.annotations.NotNull java.lang.Object additionalProps) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(baseProps, "baseProps is required"), additionalProps });
    }

    /**
     * Register the given load balancing target as part of this group.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addLoadBalancerTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps props) {
        software.amazon.jsii.Kernel.call(this, "addLoadBalancerTarget", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Set/replace the target group's health check.
     * <p>
     * @param healthCheck This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void configureHealthCheck(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck) {
        software.amazon.jsii.Kernel.call(this, "configureHealthCheck", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(healthCheck, "healthCheck is required") });
    }

    /**
     * Set a non-standard attribute on the target group.
     * <p>
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes
     * @param key This parameter is required.
     * @param value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttribute(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.call(this, "setAttribute", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * Set a non-standard attribute on the target group.
     * <p>
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttribute(final @org.jetbrains.annotations.NotNull java.lang.String key) {
        software.amazon.jsii.Kernel.call(this, "setAttribute", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Validate the current construct.
     * <p>
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Default port configured for members of this target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Number getDefaultPort() {
        return software.amazon.jsii.Kernel.get(this, "defaultPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Full name of first load balancer.
     * <p>
     * This identifier is emitted as a dimensions of the metrics of this target
     * group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * app / my - load - balancer / 123456789;}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getFirstLoadBalancerFullName();

    /**
     * A token representing a list of ARNs of the load balancers that route traffic to this target group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerArns() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancerArns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * List of constructs that need to be depended on to ensure the TargetGroup is associated to a load balancer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IDependable getLoadBalancerAttached() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancerAttached", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IDependable.class));
    }

    /**
     * Configurable dependable with all resources that lead to load balancer attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConcreteDependable getLoadBalancerAttachedDependencies() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancerAttachedDependencies", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConcreteDependable.class));
    }

    /**
     * The ARN of the target group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTargetGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "targetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The full name of the target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTargetGroupFullName() {
        return software.amazon.jsii.Kernel.get(this, "targetGroupFullName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * ARNs of load balancers load balancing to this TargetGroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTargetGroupLoadBalancerArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "targetGroupLoadBalancerArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The name of the target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTargetGroupName() {
        return software.amazon.jsii.Kernel.get(this, "targetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
        return software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheck(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
        software.amazon.jsii.Kernel.set(this, "healthCheck", java.util.Objects.requireNonNull(value, "healthCheck is required"));
    }

    /**
     * The types of the directly registered members of this target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
        return software.amazon.jsii.Kernel.get(this, "targetType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.TargetType.class));
    }

    /**
     * The types of the directly registered members of this target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setTargetType(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.TargetType value) {
        software.amazon.jsii.Kernel.set(this, "targetType", value);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupBase implements software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup.Jsii$Default, software.amazon.awscdk.core.IConstruct.Jsii$Default, software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Full name of first load balancer.
         * <p>
         * This identifier is emitted as a dimensions of the metrics of this target
         * group.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * app / my - load - balancer / 123456789;}</pre></blockquote>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getFirstLoadBalancerFullName() {
            return software.amazon.jsii.Kernel.get(this, "firstLoadBalancerFullName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
